/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.rainmaker;

import com.ewyboy.rainmaker.Config;
import com.ewyboy.rainmaker.RainMaker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RainMakerBlock
extends Block {
    private int rainTime = Config.rainTime * 20;

    public RainMakerBlock() {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.func_149647_a(CreativeTabs.field_78027_g);
    }

    public void explode(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == this) {
            world.func_72876_a(null, (double)x, (double)y, (double)z, Config.explosionForce, Config.greifingExplosion);
            world.func_147468_f(x, y, z);
        }
    }

    public void thunder(World world, int x, int y, int z) {
        EntityLightningBolt Lightning = new EntityLightningBolt(world, 10.0, 10.0, 10.0);
        Lightning.func_70107_b((double)x, (double)y, (double)z);
        world.func_72838_d((Entity)Lightning);
        world.func_72980_b((double)x, (double)y, (double)z, "ambient.weather.thunder", 1.0f, 1.0f, true);
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (world.func_72937_j(x, y + 1, z)) {
            double posX = (float)x + 0.6f;
            double posY = (float)y + 1.0f + ((float)Math.random() * 3.0f + 0.0f);
            double posZ = (float)z + 0.6f;
            int times = 1000;
            this.thunder(world, x, y, z);
            for (int i = 0; i < times; ++i) {
                world.func_72869_a("splash", posX, posY + (double)(i / 300), posZ, 0.0, 0.0 + (double)(i / 300), 0.0);
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.func_72937_j(x, y + 1, z) && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            world.func_72912_H().func_76084_b(true);
            world.func_72912_H().func_76069_a(true);
            world.func_72912_H().func_76080_g(this.rainTime);
            System.out.println("Rain time = " + this.rainTime);
            if (Config.debugMode) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d("Rainmaker activated - Raining for " + this.rainTime);
            }
            int delay = 2000000000;
            for (double d = 1.0; d < (double)delay; d += 1.0) {
                if (d != (double)(delay - 1)) continue;
                this.explode(world, x, y, z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150359_w.func_149733_h(1);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149731_a(world, x, y, z, start, end);
    }

    public Item func_149650_a(int i, Random random, int i1) {
        return null;
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
    }

    public int func_149645_b() {
        return RainMaker.proxy.rainmakerRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 0;
    }

    public boolean func_149747_d(IBlockAccess iBlockAccess, int x, int y, int z, int i) {
        return true;
    }
}

