/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.visnet;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.TileVisNode;

public class VisNetHandler {
    public static HashMap<Integer, HashMap<WorldCoordinates, WeakReference<TileVisNode>>> sources = new HashMap();
    static ArrayList<WorldCoordinates> cache = new ArrayList();
    private static HashMap<WorldCoordinates, ArrayList<WeakReference<TileVisNode>>> nearbyNodes = new HashMap();

    public static int drainVis(World world, int x, int y, int z, Aspect aspect, int amount) {
        ArrayList<WeakReference<TileVisNode>> nodes;
        int drainedAmount = 0;
        WorldCoordinates drainer = new WorldCoordinates(x, y, z, world.field_73011_w.field_76574_g);
        if (!nearbyNodes.containsKey(drainer)) {
            VisNetHandler.calculateNearbyNodes(world, x, y, z);
        }
        if ((nodes = nearbyNodes.get(drainer)) != null && nodes.size() > 0) {
            for (WeakReference<TileVisNode> noderef : nodes) {
                TileVisNode node = (TileVisNode)((Object)noderef.get());
                if (node == null) continue;
                int a = node.consumeVis(aspect, amount);
                drainedAmount += a;
                amount -= a;
                if (a > 0) {
                    int color = Aspect.getPrimalAspects().indexOf(aspect);
                    VisNetHandler.generateVisEffect(world.field_73011_w.field_76574_g, x, y, z, node.field_145851_c, node.field_145848_d, node.field_145849_e, color);
                }
                if (amount > 0) continue;
                break;
            }
        }
        return drainedAmount;
    }

    public static void generateVisEffect(int dim, int x, int y, int z, int x2, int y2, int z2, int color) {
        ThaumcraftApi.internalMethods.generateVisEffect(dim, x, y, z, x2, y2, z2, color);
    }

    public static void addSource(World world, TileVisNode vs) {
        HashMap<WorldCoordinates, WeakReference<TileVisNode>> sourcelist = sources.get(world.field_73011_w.field_76574_g);
        if (sourcelist == null) {
            sourcelist = new HashMap();
        }
        sourcelist.put(vs.getLocation(), new WeakReference<TileVisNode>(vs));
        sources.put(world.field_73011_w.field_76574_g, sourcelist);
        nearbyNodes.clear();
    }

    public static boolean isNodeValid(WeakReference<TileVisNode> node) {
        return node != null && node.get() != null && !((TileVisNode)((Object)node.get())).func_145837_r();
    }

    public static WeakReference<TileVisNode> addNode(World world, TileVisNode vn) {
        WeakReference<TileVisNode> ref = new WeakReference<TileVisNode>(vn);
        HashMap<WorldCoordinates, WeakReference<TileVisNode>> sourcelist = sources.get(world.field_73011_w.field_76574_g);
        if (sourcelist == null) {
            new HashMap();
            return null;
        }
        ArrayList<Object[]> nearby = new ArrayList<Object[]>();
        for (WeakReference<TileVisNode> root : sourcelist.values()) {
            if (!VisNetHandler.isNodeValid(root)) continue;
            TileVisNode source = (TileVisNode)((Object)root.get());
            float r = VisNetHandler.inRange(world, vn.getLocation(), source.getLocation(), vn.getRange());
            if (r > 0.0f) {
                nearby.add(new Object[]{source, Float.valueOf(r - (float)(vn.getRange() * 2))});
            }
            nearby = VisNetHandler.findClosestNodes(vn, source, nearby);
            cache.clear();
        }
        float dist = Float.MAX_VALUE;
        TileVisNode closest = null;
        if (nearby.size() > 0) {
            for (Object[] o : nearby) {
                if (!(((Float)o[1]).floatValue() < dist) || vn.getAttunement() != -1 && ((TileVisNode)((Object)o[0])).getAttunement() != -1 && vn.getAttunement() != ((TileVisNode)((Object)o[0])).getAttunement() || !VisNetHandler.canNodeBeSeen(vn, (TileVisNode)((Object)o[0]))) continue;
                dist = ((Float)o[1]).floatValue();
                closest = (TileVisNode)((Object)o[0]);
            }
        }
        if (closest != null) {
            closest.getChildren().add(ref);
            nearbyNodes.clear();
            return new WeakReference<TileVisNode>(closest);
        }
        return null;
    }

    public static ArrayList<Object[]> findClosestNodes(TileVisNode target, TileVisNode parent, ArrayList<Object[]> in) {
        if (cache.size() <= 512 && !cache.contains(new WorldCoordinates(parent))) {
            cache.add(new WorldCoordinates(parent));
            for (WeakReference<TileVisNode> childWR : parent.getChildren()) {
                TileVisNode child = (TileVisNode)((Object)childWR.get());
                if (child == null || ((Object)((Object)child)).equals((Object)target) || ((Object)((Object)child)).equals((Object)parent)) continue;
                float r2 = VisNetHandler.inRange(child.func_145831_w(), child.getLocation(), target.getLocation(), target.getRange());
                if (r2 > 0.0f) {
                    in.add(new Object[]{child, Float.valueOf(r2)});
                }
                in = VisNetHandler.findClosestNodes(target, child, in);
            }
            return in;
        }
        return in;
    }

    private static float inRange(World world, WorldCoordinates cc1, WorldCoordinates cc2, int range) {
        float distance = cc1.getDistanceSquaredToWorldCoordinates(cc2);
        return distance > (float)(range * range) ? -1.0f : distance;
    }

    private static void calculateNearbyNodes(World world, int x, int y, int z) {
        HashMap<WorldCoordinates, WeakReference<TileVisNode>> sourcelist = sources.get(world.field_73011_w.field_76574_g);
        if (sourcelist == null) {
            new HashMap();
        } else {
            ArrayList<WeakReference<TileVisNode>> cn = new ArrayList<WeakReference<TileVisNode>>();
            WorldCoordinates drainer = new WorldCoordinates(x, y, z, world.field_73011_w.field_76574_g);
            new ArrayList();
            for (WeakReference<TileVisNode> root : sourcelist.values()) {
                if (!VisNetHandler.isNodeValid(root)) continue;
                TileVisNode source = (TileVisNode)((Object)root.get());
                TileVisNode closest = null;
                float range = Float.MAX_VALUE;
                float r = VisNetHandler.inRange(world, drainer, source.getLocation(), source.getRange());
                if (r > 0.0f) {
                    range = r;
                    closest = source;
                }
                ArrayList<WeakReference<TileVisNode>> children = new ArrayList<WeakReference<TileVisNode>>();
                for (WeakReference<TileVisNode> child : VisNetHandler.getAllChildren(source, children)) {
                    float r2;
                    TileVisNode n = (TileVisNode)((Object)child.get());
                    if (n == null || ((Object)((Object)n)).equals((Object)source) || !((r2 = VisNetHandler.inRange(n.func_145831_w(), n.getLocation(), drainer, n.getRange())) > 0.0f) || !(r2 < range)) continue;
                    range = r2;
                    closest = n;
                }
                if (closest == null) continue;
                cn.add(new WeakReference<TileVisNode>(closest));
            }
            nearbyNodes.put(drainer, cn);
        }
    }

    private static ArrayList<WeakReference<TileVisNode>> getAllChildren(TileVisNode source, ArrayList<WeakReference<TileVisNode>> list) {
        return VisNetHandler.getAllChildren(new HashSet<TileVisNode>(), source, list);
    }

    private static ArrayList<WeakReference<TileVisNode>> getAllChildren(Set<TileVisNode> tiles, TileVisNode source, ArrayList<WeakReference<TileVisNode>> list) {
        if (!tiles.add(source)) {
            return list;
        }
        for (WeakReference<TileVisNode> child : source.getChildren()) {
            TileVisNode n = (TileVisNode)((Object)child.get());
            if (n == null || n.func_145831_w() == null || !VisNetHandler.isChunkLoaded(n.func_145831_w(), n.field_145851_c, n.field_145849_e)) continue;
            list.add(child);
            list = VisNetHandler.getAllChildren(tiles, n, list);
        }
        return list;
    }

    public static boolean isChunkLoaded(World world, int x, int z) {
        int xx = x >> 4;
        int zz = z >> 4;
        return world.func_72863_F().func_73149_a(xx, zz);
    }

    public static boolean canNodeBeSeen(TileVisNode source, TileVisNode target) {
        World world = source.func_145831_w();
        Vec3 v1 = Vec3.func_72443_a((double)((double)source.field_145851_c + 0.5), (double)((double)source.field_145848_d + 0.5), (double)((double)source.field_145849_e + 0.5));
        Vec3 v2 = Vec3.func_72443_a((double)((double)target.field_145851_c + 0.5), (double)((double)target.field_145848_d + 0.5), (double)((double)target.field_145849_e + 0.5));
        if (Double.isNaN(v1.field_72450_a) || Double.isNaN(v1.field_72448_b) || Double.isNaN(v1.field_72449_c)) {
            return false;
        }
        if (Double.isNaN(v2.field_72450_a) || Double.isNaN(v2.field_72448_b) || Double.isNaN(v2.field_72449_c)) {
            return false;
        }
        int i = MathHelper.func_76128_c((double)v2.field_72450_a);
        int j = MathHelper.func_76128_c((double)v2.field_72448_b);
        int k = MathHelper.func_76128_c((double)v2.field_72449_c);
        int l = MathHelper.func_76128_c((double)v1.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)v1.field_72448_b);
        int j1 = MathHelper.func_76128_c((double)v1.field_72449_c);
        int k1 = source.getRange() * 5;
        while (k1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            int l1;
            int b0;
            if (Double.isNaN(v1.field_72450_a) || Double.isNaN(v1.field_72448_b) || Double.isNaN(v1.field_72449_c)) {
                return false;
            }
            if (l == i && i1 == j && j1 == k) continue;
            boolean flag6 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d0 = (double)l + 1.0;
            } else if (i < l) {
                d0 = (double)l + 0.0;
            } else {
                flag6 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = v2.field_72450_a - v1.field_72450_a;
            double d7 = v2.field_72448_b - v1.field_72448_b;
            double d8 = v2.field_72449_c - v1.field_72449_c;
            if (flag6) {
                d3 = (d0 - v1.field_72450_a) / d6;
            }
            if (flag3) {
                d4 = (d1 - v1.field_72448_b) / d7;
            }
            if (flag4) {
                d5 = (d2 - v1.field_72449_c) / d8;
            }
            if (d3 < d4 && d3 < d5) {
                b0 = i > l ? 4 : 5;
                v1.field_72450_a = d0;
                v1.field_72448_b += d7 * d3;
                v1.field_72449_c += d8 * d3;
            } else if (d4 < d5) {
                b0 = j > i1 ? 0 : 1;
                v1.field_72450_a += d6 * d4;
                v1.field_72448_b = d1;
                v1.field_72449_c += d8 * d4;
            } else {
                b0 = k > j1 ? 2 : 3;
                v1.field_72450_a += d6 * d5;
                v1.field_72448_b += d7 * d5;
                v1.field_72449_c = d2;
            }
            l = MathHelper.func_76128_c((double)v1.field_72450_a);
            if (b0 == 5) {
                --l;
            }
            i1 = MathHelper.func_76128_c((double)v1.field_72448_b);
            if (b0 == 1) {
                --i1;
            }
            j1 = MathHelper.func_76128_c((double)v1.field_72449_c);
            if (b0 == 3) {
                --j1;
            }
            if (l == target.field_145851_c && i1 == target.field_145848_d && j1 == target.field_145849_e) {
                return true;
            }
            Block block1 = world.func_147439_a(l, i1, j1);
            if (!block1.func_149678_a(l1 = world.func_72805_g(l, i1, j1), false) || block1.func_149668_a(world, l, i1, j1) == null || (movingobjectposition1 = block1.func_149731_a(world, l, i1, j1, v1, v2)) == null || movingobjectposition1.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) continue;
            return false;
        }
        return false;
    }
}

