/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.blocks.BlockCosmeticOpaque;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.foci.ItemFocusWarding;
import thaumcraft.common.tiles.TileWarded;

@SideOnly(value=Side.CLIENT)
public class TileWardedRenderer
extends TileEntitySpecialRenderer {
    static HashMap<Location, IIcon[]> iconCache = new HashMap();
    RenderBlocks renderBlocks = new RenderBlocks();

    public TileWardedRenderer() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void renderTileEntityAt(TileWarded tile, double x, double y, double z, float f) {
        ItemWandCasting wand;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack e = player.func_71045_bC();
        if (e != null && e.func_77973_b() instanceof ItemWandCasting && (wand = (ItemWandCasting)e.func_77973_b()).getFocus(e) instanceof ItemFocusWarding) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
            World world = tile.func_145831_w();
            GL11.glDisable((int)2896);
            Tessellator t = Tessellator.field_78398_a;
            this.renderBlocks.func_147782_a((double)-0.001f, (double)-0.001f, (double)-0.001f, (double)1.001f, (double)1.001f, (double)1.001f);
            if (tile.owner == player.func_70005_c_().hashCode()) {
                float r = MathHelper.func_76126_a((float)((float)player.field_70173_aa / 2.0f + (float)tile.field_145851_c)) * 0.2f + 0.8f;
                float g = MathHelper.func_76126_a((float)((float)player.field_70173_aa / 3.0f + (float)tile.field_145848_d)) * 0.2f + 0.7f;
                float b = MathHelper.func_76126_a((float)((float)player.field_70173_aa / 4.0f + (float)tile.field_145849_e)) * 0.2f + 0.28f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)0.5f);
            } else {
                float r = MathHelper.func_76126_a((float)((float)player.field_70173_aa / 2.0f + (float)tile.field_145851_c)) * 0.2f + 0.8f;
                float g = MathHelper.func_76126_a((float)((float)player.field_70173_aa / 3.0f + (float)tile.field_145848_d)) * 0.2f + 0.28f;
                float b = MathHelper.func_76126_a((float)((float)player.field_70173_aa / 4.0f + (float)tile.field_145849_e)) * 0.2f + 0.28f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)0.25f);
            }
            t.func_78382_b();
            t.func_78380_c(200);
            this.field_147501_a.field_147553_e.func_110577_a(TextureMap.field_110575_b);
            GL11.glTexEnvi((int)8960, (int)8704, (int)260);
            if (this.shouldSideBeRendered(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1)) {
                this.renderBlocks.func_147768_a(ConfigBlocks.blockJar, -0.5001, 0.0, -0.5001, this.getIconOnSide(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 0, tile.owner, player.field_70173_aa));
            }
            if (this.shouldSideBeRendered(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 0)) {
                this.renderBlocks.func_147806_b(ConfigBlocks.blockJar, -0.5001, 0.0, -0.5001, this.getIconOnSide(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1, tile.owner, player.field_70173_aa));
            }
            if (this.shouldSideBeRendered(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 3)) {
                this.renderBlocks.func_147761_c(ConfigBlocks.blockJar, -0.5001, 0.0, -0.5001, this.getIconOnSide(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 2, tile.owner, player.field_70173_aa));
            }
            if (this.shouldSideBeRendered(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 2)) {
                this.renderBlocks.func_147734_d(ConfigBlocks.blockJar, -0.5001, 0.0, -0.5001, this.getIconOnSide(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 3, tile.owner, player.field_70173_aa));
            }
            if (this.shouldSideBeRendered(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 5)) {
                this.renderBlocks.func_147798_e(ConfigBlocks.blockJar, -0.5001, 0.0, -0.5001, this.getIconOnSide(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 4, tile.owner, player.field_70173_aa));
            }
            if (this.shouldSideBeRendered(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 4)) {
                this.renderBlocks.func_147764_f(ConfigBlocks.blockJar, -0.5001, 0.0, -0.5001, this.getIconOnSide(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 5, tile.owner, player.field_70173_aa));
            }
            t.func_78381_a();
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glEnable((int)2896);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDisable((int)3042);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    private boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z) != world.func_72805_g(x - Facing.field_71586_b[side], y - Facing.field_71587_c[side], z - Facing.field_71585_d[side]) || world.func_147439_a(x - Facing.field_71586_b[side], y - Facing.field_71587_c[side], z - Facing.field_71585_d[side]) != ConfigBlocks.blockWarded;
    }

    private boolean isConnectedBlock(World world, int x, int y, int z, int owner) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileWarded) {
            return ((TileWarded)tile).owner == owner;
        }
        return false;
    }

    private IIcon getIconOnSide(World world, int x, int y, int z, int side, int owner, int ticks) {
        Location wc = new Location(x, y, z);
        IIcon[] out = null;
        if ((ticks + side) % 10 == 0 || (out = iconCache.get(wc)) == null || out[side] == null) {
            byte result;
            byte result1;
            byte result2;
            byte result3;
            byte result4;
            byte result5;
            byte result6;
            byte result7;
            byte bitMatrix = 0;
            if (side == 0 || side == 1) {
                result7 = this.isConnectedBlock(world, x - 1, y, z - 1, owner) ? (byte)(bitMatrix | 1) : (byte)0;
                bitMatrix = result7;
                result6 = this.isConnectedBlock(world, x, y, z - 1, owner) ? (byte)(bitMatrix | 2) : (byte)(bitMatrix & 0xFFFFFFFD);
                bitMatrix = result6;
                result5 = this.isConnectedBlock(world, x + 1, y, z - 1, owner) ? (byte)(bitMatrix | 4) : (byte)(bitMatrix & 0xFFFFFFFB);
                bitMatrix = result5;
                result4 = this.isConnectedBlock(world, x - 1, y, z, owner) ? (byte)(bitMatrix | 8) : (byte)(bitMatrix & 0xFFFFFFF7);
                bitMatrix = result4;
                result3 = this.isConnectedBlock(world, x + 1, y, z, owner) ? (byte)(bitMatrix | 0x10) : (byte)(bitMatrix & 0xFFFFFFEF);
                bitMatrix = result3;
                result2 = this.isConnectedBlock(world, x - 1, y, z + 1, owner) ? (byte)(bitMatrix | 0x20) : (byte)(bitMatrix & 0xFFFFFFDF);
                bitMatrix = result2;
                result1 = this.isConnectedBlock(world, x, y, z + 1, owner) ? (byte)(bitMatrix | 0x40) : (byte)(bitMatrix & 0xFFFFFFBF);
                bitMatrix = result1;
                result = this.isConnectedBlock(world, x + 1, y, z + 1, owner) ? (byte)(bitMatrix | 0x80) : (byte)(bitMatrix & 0xFFFFFF7F);
                bitMatrix = result;
            }
            if (side == 2 || side == 3) {
                result7 = this.isConnectedBlock(world, x + (side == 2 ? 1 : -1), y + 1, z, owner) ? (byte)(bitMatrix | 1) : (byte)0;
                bitMatrix = result7;
                result6 = this.isConnectedBlock(world, x, y + 1, z, owner) ? (byte)(bitMatrix | 2) : (byte)(bitMatrix & 0xFFFFFFFD);
                bitMatrix = result6;
                result5 = this.isConnectedBlock(world, x + (side == 3 ? 1 : -1), y + 1, z, owner) ? (byte)(bitMatrix | 4) : (byte)(bitMatrix & 0xFFFFFFFB);
                bitMatrix = result5;
                result4 = this.isConnectedBlock(world, x + (side == 2 ? 1 : -1), y, z, owner) ? (byte)(bitMatrix | 8) : (byte)(bitMatrix & 0xFFFFFFF7);
                bitMatrix = result4;
                result3 = this.isConnectedBlock(world, x + (side == 3 ? 1 : -1), y, z, owner) ? (byte)(bitMatrix | 0x10) : (byte)(bitMatrix & 0xFFFFFFEF);
                bitMatrix = result3;
                result2 = this.isConnectedBlock(world, x + (side == 2 ? 1 : -1), y - 1, z, owner) ? (byte)(bitMatrix | 0x20) : (byte)(bitMatrix & 0xFFFFFFDF);
                bitMatrix = result2;
                result1 = this.isConnectedBlock(world, x, y - 1, z, owner) ? (byte)(bitMatrix | 0x40) : (byte)(bitMatrix & 0xFFFFFFBF);
                bitMatrix = result1;
                result = this.isConnectedBlock(world, x + (side == 3 ? 1 : -1), y - 1, z, owner) ? (byte)(bitMatrix | 0x80) : (byte)(bitMatrix & 0xFFFFFF7F);
                bitMatrix = result;
            }
            if (side == 4 || side == 5) {
                result7 = this.isConnectedBlock(world, x, y + 1, z + (side == 5 ? 1 : -1), owner) ? (byte)(bitMatrix | 1) : (byte)0;
                bitMatrix = result7;
                result6 = this.isConnectedBlock(world, x, y + 1, z, owner) ? (byte)(bitMatrix | 2) : (byte)(bitMatrix & 0xFFFFFFFD);
                bitMatrix = result6;
                result5 = this.isConnectedBlock(world, x, y + 1, z + (side == 4 ? 1 : -1), owner) ? (byte)(bitMatrix | 4) : (byte)(bitMatrix & 0xFFFFFFFB);
                bitMatrix = result5;
                result4 = this.isConnectedBlock(world, x, y, z + (side == 5 ? 1 : -1), owner) ? (byte)(bitMatrix | 8) : (byte)(bitMatrix & 0xFFFFFFF7);
                bitMatrix = result4;
                result3 = this.isConnectedBlock(world, x, y, z + (side == 4 ? 1 : -1), owner) ? (byte)(bitMatrix | 0x10) : (byte)(bitMatrix & 0xFFFFFFEF);
                bitMatrix = result3;
                result2 = this.isConnectedBlock(world, x, y - 1, z + (side == 5 ? 1 : -1), owner) ? (byte)(bitMatrix | 0x20) : (byte)(bitMatrix & 0xFFFFFFDF);
                bitMatrix = result2;
                result1 = this.isConnectedBlock(world, x, y - 1, z, owner) ? (byte)(bitMatrix | 0x40) : (byte)(bitMatrix & 0xFFFFFFBF);
                bitMatrix = result1;
                result = this.isConnectedBlock(world, x, y - 1, z + (side == 4 ? 1 : -1), owner) ? (byte)(bitMatrix | 0x80) : (byte)(bitMatrix & 0xFFFFFF7F);
                bitMatrix = result;
            }
            int idBuilder = 0;
            for (int i = 0; i <= 7; ++i) {
                idBuilder += (bitMatrix & 1 << i) != 0 ? (i == 0 ? 1 : (i == 1 ? 2 : (i == 2 ? 4 : (i == 3 ? 8 : (i == 4 ? 16 : (i == 5 ? 32 : (i == 6 ? 64 : 128))))))) : 0;
            }
            IIcon var13 = idBuilder <= 255 && idBuilder >= 0 ? BlockCosmeticOpaque.wardedGlassIcon[UtilsFX.connectedTextureRefByID[idBuilder]] : BlockCosmeticOpaque.wardedGlassIcon[0];
            if (out == null) {
                out = new IIcon[8];
                iconCache.put(wc, out);
            }
            out[side] = var13;
        }
        return out[side];
    }

    public void func_147500_a(TileEntity par1TileEntity, double par2, double par4, double par6, float par8) {
        this.renderTileEntityAt((TileWarded)par1TileEntity, par2, par4, par6, par8);
    }

    @SubscribeEvent
    public void cleanupCache(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.CLIENT && event.player.field_70173_aa % 120 == 0) {
            iconCache.clear();
        }
    }

    private static final class Location {
        final int x;
        final int y;
        final int z;

        private Location(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            Location p = (Location)other;
            return this.x == p.x && this.y == p.y && this.z == p.z;
        }

        public int hashCode() {
            return this.y & 0xFF | (this.x & Short.MAX_VALUE) << 8 | (this.z & Short.MAX_VALUE) << 24 | (this.x < 0 ? Integer.MIN_VALUE : 0) | (this.z < 0 ? 32768 : 0);
        }
    }
}

