/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.common.Thaumcraft;

public class PacketSyncScannedEntities
implements IMessage,
IMessageHandler<PacketSyncScannedEntities, IMessage> {
    protected ArrayList<String> data = new ArrayList();

    public PacketSyncScannedEntities() {
    }

    public PacketSyncScannedEntities(EntityPlayer player) {
        this.data = Thaumcraft.proxy.getScannedEntities().get(player.func_70005_c_());
    }

    public void toBytes(ByteBuf buffer) {
        if (this.data != null && this.data.size() > 0) {
            buffer.writeShort(this.data.size());
            for (String s : this.data) {
                if (s == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)s);
            }
        } else {
            buffer.writeShort(0);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int size = buffer.readShort();
        this.data = new ArrayList();
        for (int a = 0; a < size; ++a) {
            this.data.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketSyncScannedEntities message, MessageContext ctx) {
        String username = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        ArrayList completed = Thaumcraft.proxy.getScannedEntities().computeIfAbsent(username, userName -> new ArrayList());
        for (String key : message.data) {
            completed.remove(key);
            completed.add(key);
            String t = key.replaceFirst("#", "@");
            if (!key.startsWith("#")) continue;
            completed.remove(t);
        }
        return null;
    }
}

