/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.api.block.IBlockAppearance;
import cofh.api.block.IBlockConfigGui;
import cofh.core.block.TileCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.render.IconRegistry;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.core.render.hitbox.RenderHitbox;
import cofh.core.util.CoreUtils;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.BlockTDBase;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.core.TDProps;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.ItemBlockDuct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.TileStructuralDuct;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.energy.EnergyGrid;
import cofh.thermaldynamics.duct.energy.TileEnergyDuct;
import cofh.thermaldynamics.duct.energy.TileEnergyDuctSuper;
import cofh.thermaldynamics.duct.energy.subgrid.SubTileEnergyRedstone;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.TileTransportDuct;
import cofh.thermaldynamics.duct.entity.TileTransportDuctCrossover;
import cofh.thermaldynamics.duct.entity.TileTransportDuctLongRange;
import cofh.thermaldynamics.duct.entity.TransportHandler;
import cofh.thermaldynamics.duct.fluid.PacketFluid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.duct.fluid.TileFluidDuctFlux;
import cofh.thermaldynamics.duct.fluid.TileFluidDuctFragile;
import cofh.thermaldynamics.duct.fluid.TileFluidDuctSuper;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TileItemDuctEnder;
import cofh.thermaldynamics.duct.item.TileItemDuctFlux;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDuct
extends BlockTDBase
implements IBlockAppearance,
IBlockConfigGui {
    public int offset;

    public BlockDuct(int var1) {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
        this.func_149663_c("thermaldynamics.duct");
        this.func_149647_a(ThermalDynamics.tabCommon);
        this.offset = var1 * 16;
    }

    public void func_149666_a(Item var1, CreativeTabs var2, List var3) {
        for (int var4 = 0; var4 < 16; ++var4) {
            if (!TDDucts.isValid(var4 + this.offset)) continue;
            var3.add(TDDucts.getDuct((int)(var4 + this.offset)).itemStack.func_77946_l());
        }
    }

    public boolean hasTileEntity(int var1) {
        return TDDucts.isValid(var1 + this.offset);
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        Duct var3 = TDDucts.getType(var2 + this.offset);
        return var3.factory.createTileEntity(var3, var1);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int var1, int var2) {
        return TDDucts.getType((int)(var2 + this.offset)).iconBaseTexture;
    }

    public int func_149692_a(int var1) {
        return var1;
    }

    public boolean canCreatureSpawn(EnumCreatureType var1, IBlockAccess var2, int var3, int var4, int var5) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent var1) {
        if (var1.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && var1.player.field_70170_p.func_147439_a(var1.target.field_72311_b, var1.target.field_72312_c, var1.target.field_72309_d).func_149739_a().equals(this.func_149739_a())) {
            RayTracer.retraceBlock((World)var1.player.field_70170_p, (EntityPlayer)var1.player, (int)var1.target.field_72311_b, (int)var1.target.field_72312_c, (int)var1.target.field_72309_d);
            ICustomHitBox var2 = (ICustomHitBox)var1.player.field_70170_p.func_147438_o(var1.target.field_72311_b, var1.target.field_72312_c, var1.target.field_72309_d);
            if (var2.shouldRenderCustomHitBox(var1.target.subHit, var1.player)) {
                var1.setCanceled(true);
                RenderHitbox.drawSelectionBox((EntityPlayer)var1.player, (MovingObjectPosition)var1.target, (float)var1.partialTicks, (CustomHitBox)var2.getCustomHitBox(var1.target.subHit, var1.player));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister var1) {
        if (this.offset == 0) {
            int var2;
            for (var2 = 0; var2 < 5; ++var2) {
                for (int var3 = 0; var3 < 2; ++var3) {
                    IconRegistry.addIcon((String)("ServoBase" + (var2 * 2 + var3)), (String)("thermaldynamics:duct/attachment/servo/ServoBase" + var2 + "" + var3), (IIconRegister)var1);
                    IconRegistry.addIcon((String)("RetrieverBase" + (var2 * 2 + var3)), (String)("thermaldynamics:duct/attachment/retriever/RetrieverBase" + var2 + "" + var3), (IIconRegister)var1);
                }
            }
            IconRegistry.addIcon((String)"Signaller", (String)"thermaldynamics:duct/attachment/signallers/Signaller", (IIconRegister)var1);
            IconRegistry.addIcon((String)"CoverBase", (String)"thermaldynamics:duct/attachment/cover/support", (IIconRegister)var1);
            for (var2 = 0; var2 < 5; ++var2) {
                IconRegistry.addIcon((String)("FilterBase" + var2), (String)("thermaldynamics:duct/attachment/filter/Filter" + var2 + "0"), (IIconRegister)var1);
            }
            IconRegistry.addIcon((String)"SideDucts", (String)"thermaldynamics:duct/sideDucts", (IIconRegister)var1);
            for (var2 = 0; var2 < TDDucts.ductList.size(); ++var2) {
                if (!TDDucts.isValid(var2)) continue;
                TDDucts.ductList.get(var2).registerIcons(var1);
            }
            TDDucts.structureInvis.registerIcons(var1);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition var1, World var2, int var3, int var4, int var5) {
        ItemStack var7;
        TileTDBase var6;
        if (var1.subHit >= 14 && var1.subHit < 20) {
            var6 = (TileTDBase)var2.func_147438_o(var3, var4, var5);
            var7 = var6.attachments[var1.subHit - 14].getPickBlock();
            if (var7 != null) {
                return var7;
            }
        }
        if (var1.subHit >= 20 && var1.subHit < 26) {
            var6 = (TileTDBase)var2.func_147438_o(var3, var4, var5);
            var7 = var6.covers[var1.subHit - 20].getPickBlock();
            if (var7 != null) {
                return var7;
            }
        }
        return super.getPickBlock(var1, var2, var3, var4, var5);
    }

    public int func_149645_b() {
        return TDProps.renderDuctId;
    }

    public boolean canRenderInPass(int var1) {
        renderPass = var1;
        return var1 < 2;
    }

    public int func_149701_w() {
        return 1;
    }

    public Block getVisualBlock(IBlockAccess var1, int var2, int var3, int var4, ForgeDirection var5) {
        Cover var7;
        TileEntity var6 = var1.func_147438_o(var2, var3, var4);
        if (var6 instanceof TileTDBase && (var7 = ((TileTDBase)var6).covers[var5.ordinal()]) != null) {
            return var7.block;
        }
        return this;
    }

    public int getVisualMeta(IBlockAccess var1, int var2, int var3, int var4, ForgeDirection var5) {
        Cover var7;
        TileEntity var6 = var1.func_147438_o(var2, var3, var4);
        if (var6 instanceof TileTDBase && (var7 = ((TileTDBase)var6).covers[var5.ordinal()]) != null) {
            return var7.meta;
        }
        return var1.func_72805_g(var2, var3, var4);
    }

    public boolean supportsVisualConnections() {
        return true;
    }

    public boolean openConfigGui(IBlockAccess var1, int var2, int var3, int var4, ForgeDirection var5, EntityPlayer var6) {
        Attachment var10;
        TileTDBase var7 = (TileTDBase)var1.func_147438_o(var2, var3, var4);
        if (var7 instanceof IBlockConfigGui) {
            return ((IBlockConfigGui)var7).openConfigGui(var1, var2, var3, var4, var5, var6);
        }
        int var8 = var5.ordinal();
        if (var1 instanceof World) {
            MovingObjectPosition var9 = RayTracer.retraceBlock((World)((World)var1), (EntityPlayer)var6, (int)var2, (int)var3, (int)var4);
            if (var9 == null) {
                return false;
            }
            if (var8 > 13 && var8 < 20) {
                var8 = var9.subHit - 14;
            }
        }
        if (var8 > 13 && var8 < 20 && (var10 = var7.attachments[var8 - 14]) instanceof IBlockConfigGui) {
            return ((IBlockConfigGui)var10).openConfigGui(var1, var2, var3, var4, var5, var6);
        }
        return false;
    }

    public void func_149689_a(World var1, int var2, int var3, int var4, EntityLivingBase var5, ItemStack var6) {
        super.func_149689_a(var1, var2, var3, var4, var5, var6);
        TileEntity var7 = var1.func_147438_o(var2, var3, var4);
        if (var7 instanceof TileTDBase) {
            ((TileTDBase)var7).onPlacedBy(var5, var6);
        }
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer var1, NBTTagCompound var2, World var3, int var4, int var5, int var6, boolean var7, boolean var8) {
        TileEntity var9 = var3.func_147438_o(var4, var5, var6);
        int var10 = var3.func_72805_g(var4, var5, var6);
        ItemStack var11 = var9 instanceof TileTDBase ? ((TileTDBase)var9).getDrop() : new ItemStack((Block)this, 1, var10);
        ArrayList<ItemStack> var12 = new ArrayList<ItemStack>();
        var12.add(var11);
        if (var9 instanceof TileTDBase) {
            TileTDBase var13 = (TileTDBase)var9;
            for (Attachment var17 : var13.attachments) {
                if (var17 == null) continue;
                var12.addAll(var17.getDrops());
            }
            for (Cover var27 : var13.covers) {
                if (var27 == null) continue;
                var12.addAll(var27.getDrops());
            }
            var13.dropAdditional(var12);
        }
        if (var2 != null) {
            var11.func_77982_d(var2);
        }
        if (!var8) {
            if (var9 instanceof TileCoFHBase) {
                ((TileCoFHBase)var9).blockDismantled();
            }
            var3.func_147468_f(var4, var5, var6);
            if (!var7) {
                float var23 = 0.3f;
                for (ItemStack var26 : var12) {
                    double var28 = (double)(var3.field_73012_v.nextFloat() * var23) + (double)(1.0f - var23) * 0.5;
                    double var18 = (double)(var3.field_73012_v.nextFloat() * var23) + (double)(1.0f - var23) * 0.5;
                    double var20 = (double)(var3.field_73012_v.nextFloat() * var23) + (double)(1.0f - var23) * 0.5;
                    EntityItem var22 = new EntityItem(var3, (double)var4 + var28, (double)var5 + var18, (double)var6 + var20, var26);
                    var22.field_145804_b = 10;
                    var3.func_72838_d((Entity)var22);
                }
                if (var1 != null) {
                    CoreUtils.dismantleLog((String)var1.func_70005_c_(), (Block)this, (int)var10, (double)var4, (double)var5, (double)var6);
                }
            }
        }
        return var12;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World var1, int var2, int var3, int var4, Random var5) {
        super.func_149734_b(var1, var2, var3, var4, var5);
        TileEntity var6 = var1.func_147438_o(var2, var3, var4);
        if (var6 instanceof TileTDBase) {
            ((TileTDBase)var6).randomDisplayTick();
        }
    }

    @Override
    public float getSize(World var1, int var2, int var3, int var4) {
        return TDDucts.getDuct(this.offset + var1.func_72805_g(var2, var3, var4)).isLargeTube() ? 0.05f : super.getSize(var1, var2, var3, var4);
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, ItemBlockDuct.class, (String)("ThermalDynamics_" + this.offset));
        for (int var1 = 0; var1 < 16; ++var1) {
            if (!TDDucts.isValid(this.offset + var1)) continue;
            TDDucts.getType((int)(this.offset + var1)).itemStack = new ItemStack((Block)this, 1, var1);
        }
        return true;
    }

    public boolean initialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (this.offset != 0) {
            return true;
        }
        GameRegistry.registerTileEntity(TileEnergyDuct.class, (String)"thermaldynamics.FluxDuct");
        GameRegistry.registerTileEntity(TileEnergyDuctSuper.class, (String)"thermaldynamics.FluxDuctSuperConductor");
        EnergyGrid.initialize();
        SubTileEnergyRedstone.initialize();
        PacketHandler.instance.registerPacket(PacketFluid.class);
        GameRegistry.registerTileEntity(TileFluidDuct.class, (String)"thermaldynamics.FluidDuct");
        GameRegistry.registerTileEntity(TileFluidDuctFragile.class, (String)"thermaldynamics.FluidDuctFragile");
        GameRegistry.registerTileEntity(TileFluidDuctFlux.class, (String)"thermaldynamics.FluidDuctFlux");
        GameRegistry.registerTileEntity(TileFluidDuctSuper.class, (String)"thermaldynamics.FluidDuctSuper");
        GameRegistry.registerTileEntity(TileItemDuct.class, (String)"thermaldynamics.ItemDuct");
        GameRegistry.registerTileEntity(TileItemDuctEnder.class, (String)"thermaldynamics.ItemDuctEnder");
        GameRegistry.registerTileEntity(TileItemDuctFlux.class, (String)"thermaldynamics.ItemDuctFlux");
        GameRegistry.registerTileEntity(TileStructuralDuct.class, (String)"thermaldynamics.StructuralDuct");
        GameRegistry.registerTileEntity(TileTransportDuct.class, (String)"thermaldynamics.TransportDuct");
        GameRegistry.registerTileEntity(TileTransportDuctLongRange.class, (String)"thermaldynamics.TransportDuctLongRange");
        GameRegistry.registerTileEntity(TileTransportDuctCrossover.class, (String)"thermaldynamics.TransportDuctCrossover");
        EntityRegistry.registerModEntity(EntityTransport.class, (String)"Transport", (int)0, (Object)((Object)ThermalDynamics.instance), (int)64, (int)1, (boolean)true);
        MinecraftForge.EVENT_BUS.register((Object)TransportHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)TransportHandler.INSTANCE);
        return true;
    }

    public boolean postInit() {
        return true;
    }

    public int func_149709_b(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        TileTDBase var6 = (TileTDBase)var1.func_147438_o(var2, var3, var4);
        return var6 != null && var6.attachments[var5 ^ 1] != null ? var6.attachments[var5 ^ 1].getRSOutput() : 0;
    }

    public int func_149748_c(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        if (var5 == -1) {
            return false;
        }
        int var6 = var5 == 0 ? 2 : (var5 == 1 ? 5 : (var5 == 2 ? 3 : 4));
        TileTDBase var7 = (TileTDBase)var1.func_147438_o(var2, var3, var4);
        return var7 != null && var7.attachments[var6] != null && var7.attachments[var6].shouldRSConnect();
    }

    public static enum ConnectionTypes {
        NONE(false),
        DUCT,
        TILECONNECTION,
        STRUCTURE,
        CLEANDUCT;

        private final boolean renderDuct;
        public static ConnectionTypes[] VALUES;

        private ConnectionTypes() {
            this.renderDuct = true;
        }

        private ConnectionTypes(boolean var3) {
            this.renderDuct = var3;
        }

        public boolean renderDuct() {
            return this.renderDuct;
        }

        static {
            VALUES = ConnectionTypes.values();
        }
    }
}

