/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import cofh.thermaldynamics.ThermalDynamics;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CoverHelper {
    public static HashMap<Fluid, Block> fluidToBlockMap;

    public static void initFluids() {
        fluidToBlockMap = new HashMap(0);
    }

    public static Block getFluidBlock(FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        return fluidStack.getFluid().getBlock();
    }

    public static boolean isValid(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return false;
        }
        return item instanceof ItemBlock && CoverHelper.isValid(((ItemBlock)item).field_150939_a, item.func_77647_b(stack.func_77960_j())) || CoverHelper.getFluidBlock(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null;
    }

    public static boolean isValid(Block block, int meta) {
        return block != null && !block.hasTileEntity(meta) && !block.func_149716_u();
    }

    public static ItemStack getCoverStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        if (item instanceof ItemBlock) {
            return CoverHelper.getCoverStack(((ItemBlock)item).field_150939_a, item.func_77647_b(stack.func_77960_j()));
        }
        Block fluidBlock = CoverHelper.getFluidBlock(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack));
        return fluidBlock != null ? CoverHelper.getCoverStack(fluidBlock, 0) : null;
    }

    public static ItemStack getCoverStack(Block block, int meta) {
        ItemStack stack = new ItemStack((Item)ThermalDynamics.itemCover, 1);
        if (block == null) {
            return stack;
        }
        String blockName = Block.field_149771_c.func_148750_c((Object)block);
        if (blockName == null) {
            return stack;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Block", blockName);
        nbt.func_74774_a("Meta", (byte)meta);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack getCoverItemStack(ItemStack stack, boolean removeInvalidTags) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("Meta", 1) && nbt.func_150297_b("Block", 8)) {
            byte meta = nbt.func_74771_c("Meta");
            Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
            if (block == null) {
                block = Blocks.field_150350_a;
            }
            if (block != Blocks.field_150350_a && meta >= 0 && meta < 16 && CoverHelper.isValid(block, meta)) {
                return new ItemStack(block, 1, (int)meta);
            }
            if (removeInvalidTags) {
                nbt.func_82580_o("Meta");
                nbt.func_82580_o("Block");
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            return null;
        }
        return null;
    }
}

