/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy.subgrid;

import cofh.thermaldynamics.block.SubTileMultiBlock;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.energy.subgrid.EnergySubGrid;
import cofh.thermaldynamics.duct.energy.subgrid.EnergySubGridDistribute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.nbt.NBTTagCompound;

public class SubTileEnergy
extends SubTileMultiBlock {
    public int energyForGrid;
    public EnergySubGrid energyGrid;
    public int lastStoredValue;

    public SubTileEnergy(TileTDBase tileTDBase) {
        super(tileTDBase);
    }

    @Override
    public MultiBlockGrid getNewGrid() {
        return new EnergySubGridDistribute(this.world(), 2400, 400);
    }

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        super.setGrid(multiBlockGrid);
        this.energyGrid = (EnergySubGrid)multiBlockGrid;
    }

    @Override
    public boolean isNode() {
        return this.parent.isSubNode();
    }

    @Override
    public void onNeighborBlockChange() {
        this.parent.onNeighborBlockChange();
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        this.energyForGrid = nBTTagCompound.func_74762_e("Energy");
    }

    @Override
    public void tileUnloading() {
        if (this.isNode()) {
            this.energyGrid.myStorage.extractEnergy(this.lastStoredValue, false);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        if (this.energyGrid != null) {
            if (this.isNode()) {
                this.lastStoredValue = this.energyGrid.getNodeShare(this);
                nBTTagCompound.func_74768_a("Energy", this.lastStoredValue);
            }
        } else if (this.energyForGrid > 0) {
            nBTTagCompound.func_74768_a("Energy", this.energyForGrid);
        } else {
            this.energyForGrid = 0;
        }
    }
}

