/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Scale;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.core.TDProps;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.render.ModelHelper;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderDuct
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderDuct instance = new RenderDuct();
    static final int[] INV_CONNECTIONS = new int[]{BlockDuct.ConnectionTypes.DUCT.ordinal(), BlockDuct.ConnectionTypes.DUCT.ordinal(), 0, 0, 0, 0};
    static int[] connections = new int[6];
    static IIcon textureCenterLine;
    public static IIcon coverBase;
    public static IIcon signalTexture;
    public static IIcon[] servoTexture;
    public static IIcon[] retrieverTexture;
    public static IIcon[] filterTexture;
    public static IIcon sideDucts;
    static CCModel[][] modelFluid;
    public static CCModel[][] modelConnection;
    static CCModel modelCenter;
    static CCModel[] modelLine;
    static CCModel modelLineCenter;
    static CCModel[] modelFrameConnection;
    static CCModel[] modelFrame;
    static CCModel[] modelTransportConnection;
    static CCModel[] modelTransport;
    public static CCModel[] modelOpaqueTubes;
    public static CCModel[] modelTransTubes;
    private static CCModel[] modelFluidTubes;
    private static CCModel[] modelLargeTubes;

    public static void initialize() {
        RenderDuct.generateFluidModels();
        RenderDuct.generateModels();
        for (int var0 = 0; var0 < 10; ++var0) {
            RenderDuct.servoTexture[var0] = IconRegistry.getIcon((String)("ServoBase" + var0));
            RenderDuct.retrieverTexture[var0] = IconRegistry.getIcon((String)("RetrieverBase" + var0));
        }
        for (int var1 = 0; var1 < 5; ++var1) {
            RenderDuct.filterTexture[var1] = IconRegistry.getIcon((String)("FilterBase" + var1));
        }
        coverBase = IconRegistry.getIcon((String)"CoverBase");
        sideDucts = IconRegistry.getIcon((String)"SideDucts");
        signalTexture = IconRegistry.getIcon((String)"Signaller");
        textureCenterLine = TFFluids.fluidSteam.getIcon();
    }

    private static void generateFluidModels() {
        for (int var0 = 1; var0 < 7; ++var0) {
            double var1 = 0.47 - 0.025 * (double)var0;
            double var3 = 0.53 + 0.025 * (double)var0;
            double var5 = 0.32 + 0.06 * (double)var0;
            double var7 = 0.32;
            double var9 = 0.68;
            double[][] var11 = new double[][]{{var1, 0.0, var1, var3, var7, var3}, {var1, var5, var1, var3, 1.0, var3}, {var7, var7, 0.0, var9, var5, var7}, {var7, var7, var9, var9, var5, 1.0}, {0.0, var7, var7, var7, var5, var9}, {var9, var7, var7, 1.0, var5, var9}, {var7, var7, var7, var9, var5, var9}};
            for (int var12 = 0; var12 < 7; ++var12) {
                RenderDuct.modelFluid[var0 - 1][var12] = CCModel.quadModel((int)24).generateBlock(0, var11[var12][0], var11[var12][1], var11[var12][2], var11[var12][3], var11[var12][4], var11[var12][5]).computeNormals();
            }
        }
    }

    private static void generateModels() {
        modelCenter = CCModel.quadModel((int)48).generateBox(0, -3.0, -3.0, -3.0, 6.0, 6.0, 6.0, 0.0, 0.0, 32.0, 32.0, 16.0);
        RenderDuct.modelConnection[0][1] = CCModel.quadModel((int)48).generateBlock(0, new Cuboid6(0.3125, 0.6875, 0.3125, 0.6875, 1.0, 0.6875).expand(-9.765625E-4));
        RenderDuct.modelConnection[1][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 3.9990234375, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0).computeNormals();
        RenderDuct.modelConnection[2][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 3.9990234375, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0).computeNormals();
        double var0 = 0.4;
        modelLineCenter = CCModel.quadModel((int)24).generateBlock(0, var0, var0, var0, 1.0 - var0, 1.0 - var0, 1.0 - var0).computeNormals();
        RenderDuct.modelLine[1] = CCModel.quadModel((int)16).generateBlock(0, var0, 1.0 - var0, var0, 1.0 - var0, 1.0, 1.0 - var0, 3).computeNormals();
        CCModel.generateSidedModels((CCModel[])modelLine, (int)1, (Vector3)Vector3.center);
        modelOpaqueTubes = ModelHelper.StandardTubes.genModels(0.1875f, true);
        modelTransTubes = ModelHelper.StandardTubes.genModels(0.1875f, false);
        modelFluidTubes = ModelHelper.StandardTubes.genModels(0.1875f * TDProps.smallInnerModelScaling, false, false);
        modelLargeTubes = ModelHelper.StandardTubes.genModels(0.21875f, true);
        modelFrameConnection = new ModelHelper.OctagonalTubeGen(0.375, 0.1812, true).generateModels();
        modelFrame = new ModelHelper.OctagonalTubeGen(0.375 * (double)TDProps.largeInnerModelScaling, 0.1812, false).generateModels();
        modelTransportConnection = new ModelHelper.OctagonalTubeGen(0.5 * (double)TDProps.largeInnerModelScaling, 0.1812, true).generateModels();
        modelTransport = new ModelHelper.OctagonalTubeGen(0.5 * (double)TDProps.largeInnerModelScaling * (double)TDProps.largeInnerModelScaling, 0.1812, false).generateModels();
        CCModel.generateBackface((CCModel)modelCenter, (int)0, (CCModel)modelCenter, (int)24, (int)24);
        CCModel.generateBackface((CCModel)modelConnection[0][1], (int)0, (CCModel)modelConnection[0][1], (int)24, (int)24);
        modelConnection[0][1].apply((Transformation)RenderUtils.getRenderVector((double)-0.5, (double)-0.5, (double)-0.5).translation());
        for (int var2 = 0; var2 < modelConnection.length; ++var2) {
            CCModel.generateSidedModels((CCModel[])modelConnection[var2], (int)1, (Vector3)Vector3.zero);
        }
        Scale[] var11 = new Scale[]{new Scale(1.0, -1.0, 1.0), new Scale(1.0, 1.0, -1.0), new Scale(-1.0, 1.0, 1.0)};
        for (int var3 = 0; var3 < modelConnection.length; ++var3) {
            CCModel[] var4 = modelConnection[var3];
            for (int var5 = 2; var5 < 6; var5 += 2) {
                var4[var5] = var4[0].sidedCopy(0, var5, Vector3.zero);
            }
            for (int var14 = 1; var14 < 6; var14 += 2) {
                var4[var14] = var4[var14 - 1].backfacedCopy().apply((Transformation)var11[var14 / 2]);
            }
        }
        modelCenter.computeNormals().computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
        CCModel[][] cCModelArray = modelConnection;
        int n = cCModelArray.length;
        for (int i = 0; i < n; ++i) {
            CCModel[] var6;
            for (CCModel var10 : var6 = cCModelArray[i]) {
                var10.computeNormals().computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
            }
        }
    }

    public boolean renderBase(boolean var1, int var2, int[] var3, double var4, double var6, double var8, IIcon var10) {
        Translation var11 = RenderUtils.getRenderVector((double)(var4 += 0.5), (double)(var6 += 0.5), (double)(var8 += 0.5)).translation();
        int var12 = 0;
        Duct var13 = TDDucts.ductList.get(var2);
        for (int var14 = 0; var14 < 6; ++var14) {
            if (!BlockDuct.ConnectionTypes.VALUES[var3[var14]].renderDuct()) continue;
            if (BlockDuct.ConnectionTypes.VALUES[var3[var14]] == BlockDuct.ConnectionTypes.STRUCTURE) {
                RenderUtils.ScaledIconTransformation var15 = RenderUtils.getIconTransformation((IIcon)TDDucts.structure.iconBaseTexture);
                modelConnection[0][var14].render(8, 24, new CCRenderState.IVertexOperation[]{var11, var15});
                modelConnection[0][var14].render(32, 48, new CCRenderState.IVertexOperation[]{var11, var15});
                if (var13.iconConnectionTexture == null) continue;
                modelConnection[1][var14].render(new CCRenderState.IVertexOperation[]{var11, RenderUtils.getIconTransformation((IIcon)var13.iconConnectionTexture)});
                continue;
            }
            var12 |= 1 << var14;
            if (var1 && var10 != null) {
                RenderUtils.ScaledIconTransformation var24 = RenderUtils.getIconTransformation((IIcon)TDDucts.structureInvis.iconBaseTexture);
                modelConnection[0][var14].render(4, 8, new CCRenderState.IVertexOperation[]{var11, var24});
            }
            if (var3[var14] != BlockDuct.ConnectionTypes.TILECONNECTION.ordinal() || var13.iconConnectionTexture == null) continue;
            modelConnection[1][var14].render(new CCRenderState.IVertexOperation[]{var11, RenderUtils.getIconTransformation((IIcon)var13.iconConnectionTexture)});
        }
        if (var10 != null) {
            RenderUtils.ScaledIconTransformation var21 = RenderUtils.getIconTransformation((IIcon)var10);
            (var13.opaque ? modelOpaqueTubes[var12] : modelTransTubes[var12]).render(new CCRenderState.IVertexOperation[]{var11, var21});
        }
        if (var13.iconFluidTexture != null && var13.fluidTransparency == -1) {
            modelFluidTubes[var12].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var13.iconFluidTexture));
        }
        if (var13.frameType == 1) {
            this.renderSideTubes(0, var3, var4 - 0.5, var6 - 0.5, var8 - 0.5, sideDucts);
        } else if (var13.frameType == 2 && var13.iconFrameTexture != null) {
            var12 = 0;
            for (int var23 = 0; var23 < 6; ++var23) {
                if (!BlockDuct.ConnectionTypes.VALUES[var3[var23]].renderDuct() || var3[var23] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                var12 |= 1 << var23;
                if (!var1 && var3[var23] == BlockDuct.ConnectionTypes.DUCT.ordinal()) continue;
                modelFrameConnection[64 + var23].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var13.iconFrameBandTexture));
                modelFrame[70 + var23].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var13.iconFrameTexture));
            }
            if (RenderDuct.modelFrameConnection[var12].verts.length != 0) {
                modelFrameConnection[var12].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var13.iconFrameTexture));
            }
        } else if (var13.frameType == 3 && var13.iconFrameTexture != null) {
            modelLargeTubes[var12].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var13.iconFrameTexture));
        } else if (var13.frameType == 4 && var13.iconFrameTexture != null) {
            var12 = 0;
            for (int var22 = 0; var22 < 6; ++var22) {
                if (!BlockDuct.ConnectionTypes.VALUES[var3[var22]].renderDuct() || var3[var22] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                var12 |= 1 << var22;
                if (!var1 && var3[var22] == BlockDuct.ConnectionTypes.DUCT.ordinal()) continue;
                modelTransportConnection[64 + var22].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var13.iconFrameBandTexture));
            }
            if (RenderDuct.modelTransportConnection[var12].verts.length != 0) {
                modelTransportConnection[var12].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var13.iconFrameTexture));
            }
        }
        return true;
    }

    public boolean renderSideTubes(int var1, int[] var2, double var3, double var5, double var7, IIcon var9) {
        CCModel[] var10 = var1 == 0 ? ModelHelper.SideTubeGen.standardTubes : ModelHelper.SideTubeGen.standardTubesInner;
        int var11 = 0;
        for (int var12 = 0; var12 < 6; ++var12) {
            if (!BlockDuct.ConnectionTypes.VALUES[var2[var12]].renderDuct() || var2[var12] == BlockDuct.ConnectionTypes.CLEANDUCT.ordinal()) continue;
            var11 |= 1 << var12;
            if (var2[var12] == BlockDuct.ConnectionTypes.DUCT.ordinal()) continue;
            var10[64 + var12].render(var3 + 0.5, var5 + 0.5, var7 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var9));
        }
        if (var10[var11].verts.length == 0) {
            return false;
        }
        var10[var11].render(var3 + 0.5, var5 + 0.5, var7 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var9));
        return true;
    }

    public boolean renderWorldExtra(boolean var1, TileTDBase var2, int var3, int[] var4, double var5, double var7, double var9) {
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Duct var11 = TDDucts.ductList.get(var3);
        IIcon var12 = var11.iconFluidTexture;
        boolean var13 = false;
        if (var12 != null && var11.fluidTransparency != -1) {
            int var14 = 0;
            for (int var15 = 0; var15 < 6; ++var15) {
                if (!BlockDuct.ConnectionTypes.VALUES[var4[var15]].renderDuct() || var4[var15] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                var14 |= 1 << var15;
            }
            modelFluidTubes[var14].render(var5 + 0.5, var7 + 0.5, var9 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var12));
            var13 = true;
        }
        if (var11.frameType == 1 && var11.iconFrameFluidTexture != null) {
            boolean bl = var13 = this.renderSideTubes(1, var4, var5, var7, var9, var11.iconFrameFluidTexture) || var13;
        }
        if (var11.frameType == 2 && var11.iconFrameFluidTexture != null) {
            int var16 = 0;
            for (int var18 = 0; var18 < 6; ++var18) {
                if (!BlockDuct.ConnectionTypes.VALUES[var4[var18]].renderDuct() || var4[var18] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                var16 |= 1 << var18;
                if (!var1 && var4[var18] == BlockDuct.ConnectionTypes.DUCT.ordinal()) continue;
                modelFrame[70 + var18].render(var5 + 0.5, var7 + 0.5, var9 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var11.iconFrameFluidTexture));
            }
            if (RenderDuct.modelFrame[var16].verts.length != 0) {
                modelFrame[var16].render(var5 + 0.5, var7 + 0.5, var9 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var11.iconFrameFluidTexture));
                var13 = true;
            }
        }
        if (var11.frameType == 4 && var11.iconFrameFluidTexture != null) {
            int var17 = 0;
            for (int var19 = 0; var19 < 6; ++var19) {
                if (!BlockDuct.ConnectionTypes.VALUES[var4[var19]].renderDuct() || var4[var19] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                var17 |= 1 << var19;
            }
            if (RenderDuct.modelTransport[var17].verts.length != 0) {
                modelTransport[var17].render(var5 + 0.5, var7 + 0.5, var9 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var11.iconFrameFluidTexture));
                var13 = true;
            }
        }
        return var13;
    }

    public void renderFluid(FluidStack var1, int[] var2, int var3, double var4, double var6, double var8) {
        if (var1 != null && var1.amount > 0 && var3 > 0) {
            GL11.glBlendFunc((int)770, (int)771);
            CCRenderState.startDrawing();
            Fluid var10 = var1.getFluid();
            RenderUtils.setFluidRenderColor((FluidStack)var1);
            RenderHelper.bindTexture((ResourceLocation)RenderHelper.MC_BLOCK_SHEET);
            IIcon var11 = RenderHelper.getFluidTexture((FluidStack)var1);
            if (var10.isGaseous(var1)) {
                CCRenderState.alphaOverride = 32 + 32 * var3;
                var3 = 6;
            }
            if (var3 < 6) {
                CCModel[] var12 = modelFluid[var3 - 1];
                for (int var13 = 0; var13 < 6; ++var13) {
                    if (!BlockDuct.ConnectionTypes.VALUES[var2[var13]].renderDuct() || var2[var13] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                    var12[var13].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var11));
                }
                var12[6].render(var4, var6, var8, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var11));
            } else {
                int var14 = 0;
                for (int var15 = 0; var15 < 6; ++var15) {
                    if (!BlockDuct.ConnectionTypes.VALUES[var2[var15]].renderDuct() || var2[var15] == BlockDuct.ConnectionTypes.STRUCTURE.ordinal()) continue;
                    var14 |= 1 << var15;
                }
                modelFluidTubes[var14].render(var4 + 0.5, var6 + 0.5, var8 + 0.5, (UVTransformation)RenderUtils.getIconTransformation((IIcon)var11));
            }
            CCRenderState.draw();
        }
    }

    public void getDuctConnections(TileTDBase var1) {
        for (int var2 = 0; var2 < 6; ++var2) {
            RenderDuct.connections[var2] = var1.getRenderConnectionType(var2).ordinal();
        }
    }

    public void renderInventoryBlock(Block var1, int var2, int var3, RenderBlocks var4) {
    }

    public boolean renderWorldBlock(IBlockAccess var1, int var2, int var3, int var4, Block var5, int var6, RenderBlocks var7) {
        TileEntity var8 = var1.func_147438_o(var2, var3, var4);
        if (!(var8 instanceof TileTDBase)) {
            return false;
        }
        TileTDBase var9 = (TileTDBase)var8;
        RenderUtils.preWorldRender((IBlockAccess)var1, (int)var2, (int)var3, (int)var4);
        this.getDuctConnections(var9);
        boolean var10 = false;
        for (Attachment attachment : var9.attachments) {
            if (attachment == null) continue;
            var10 = attachment.render(BlockCoFHBase.renderPass, var7) || var10;
        }
        for (Attachment attachment : var9.covers) {
            if (attachment == null) continue;
            var10 = ((Cover)attachment).render(BlockCoFHBase.renderPass, var7) || var10;
        }
        int var18 = TDDucts.getDuct((int)(((BlockDuct)var5).offset + var1.func_72805_g((int)var2, (int)var3, (int)var4))).id;
        if (BlockCoFHBase.renderPass == 0) {
            this.renderBase(false, var18, connections, var2, var3, var4, var9.getBaseIcon());
            var10 = true;
        } else {
            var10 = this.renderWorldExtra(false, var9, var18, connections, var2, var3, var4) || var10;
        }
        var10 = var9.renderAdditional(var18, connections, BlockCoFHBase.renderPass) || var10;
        return var10;
    }

    public boolean shouldRender3DInInventory(int var1) {
        return true;
    }

    public int getRenderId() {
        return TDProps.renderDuctId;
    }

    public boolean handleRenderType(ItemStack var1, IItemRenderer.ItemRenderType var2) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType var1, ItemStack var2, IItemRenderer.ItemRendererHelper var3) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType var1, ItemStack var2, Object ... var3) {
        Block var4 = Block.func_149634_a((Item)var2.func_77973_b());
        Duct var5 = TDDucts.getDuct(((BlockDuct)var4).offset + var2.func_77960_j());
        int var6 = var5.id;
        GL11.glPushMatrix();
        double var7 = -0.5;
        if (var1 == IItemRenderer.ItemRenderType.EQUIPPED || var1 == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            var7 = 0.0;
        }
        RenderHelper.setBlockTextureSheet();
        RenderUtils.preItemRender();
        RenderHelper.enableGUIStandardItemLighting();
        CCRenderState.startDrawing();
        this.renderBase(true, var6, INV_CONNECTIONS, var7, var7, var7, var5.getBaseTexture(var2));
        CCRenderState.draw();
        CCRenderState.startDrawing();
        this.renderWorldExtra(true, null, var6, INV_CONNECTIONS, var7, var7 - 9.765625E-4, var7);
        CCRenderState.draw();
        CCRenderState.useNormals = false;
        RenderHelper.setItemTextureSheet();
        RenderUtils.postItemRender();
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    static {
        servoTexture = new IIcon[10];
        retrieverTexture = new IIcon[10];
        filterTexture = new IIcon[5];
        modelFluid = new CCModel[6][7];
        modelConnection = new CCModel[3][6];
        modelLine = new CCModel[6];
        modelFrameConnection = new CCModel[64];
        modelFrame = new CCModel[64];
        modelTransportConnection = new CCModel[64];
        modelTransport = new CCModel[64];
        TDProps.renderDuctId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderDuct.generateModels();
        RenderDuct.generateFluidModels();
    }
}

