/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.tileentity.IRedstoneControl;
import cofh.asm.relauncher.CoFHSide;
import cofh.asm.relauncher.Implementable;
import cofh.asm.relauncher.Strippable;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.audio.ISoundSource;
import cofh.lib.audio.SoundTile;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.network.PacketTEBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Implementable(value={"buildcraft.api.tiles.IHasWork"})
@Strippable(value={"cofh.lib.audio.ISoundSource"}, side=CoFHSide.SERVER)
public abstract class TileRSControl
extends TileInventory
implements IRedstoneControl,
ISoundSource {
    public boolean isActive;
    protected boolean isPowered;
    protected boolean wasPowered;
    protected IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.DISABLED;

    public void onNeighborBlockChange() {
        this.wasPowered = this.isPowered;
        this.isPowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.wasPowered != this.isPowered && this.sendRedstoneUpdates()) {
            PacketTEBase.sendRSPowerUpdatePacketToClients(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.onRedstoneUpdate();
        }
    }

    protected boolean sendRedstoneUpdates() {
        return false;
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    public void onRedstoneUpdate() {
    }

    @Override
    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.isActive = var1.func_74767_n("Active");
        NBTTagCompound var2 = var1.func_74775_l("RS");
        this.isPowered = var2.func_74767_n("Power");
        this.rsMode = IRedstoneControl.ControlMode.controlModes[var2.func_74771_c("Mode")];
    }

    @Override
    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        var1.func_74757_a("Active", this.isActive);
        NBTTagCompound var2 = new NBTTagCompound();
        var2.func_74757_a("Power", this.isPowered);
        var2.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        var1.func_74782_a("RS", (NBTBase)var2);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase var1 = super.getPacket();
        var1.addBool(this.isPowered);
        var1.addByte(this.rsMode.ordinal());
        var1.addBool(this.isActive);
        return var1;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase var1, boolean var2) {
        super.handleTilePacket(var1, var2);
        this.isPowered = var1.getBool();
        this.rsMode = IRedstoneControl.ControlMode.controlModes[var1.getByte()];
        if (!var2) {
            boolean var3 = this.isActive;
            this.isActive = var1.getBool();
            if (this.isActive && !var3 && this.getSoundName() != null && !this.getSoundName().isEmpty()) {
                SoundHelper.playSound((ISound)this.getSound());
            }
        } else {
            var1.getBool();
        }
    }

    public final void setPowered(boolean var1) {
        this.wasPowered = this.isPowered;
        this.isPowered = var1;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public final boolean isPowered() {
        return this.isPowered;
    }

    public final void setControl(IRedstoneControl.ControlMode var1) {
        this.rsMode = var1;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            PacketTEBase.sendRSConfigUpdatePacketToServer(this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundTile((ISoundSource)this, this.getSoundName(), 1.0f, 1.0f, true, 0, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public String getSoundName() {
        return "";
    }

    public boolean shouldPlaySound() {
        return !this.field_145846_f && this.isActive;
    }

    public boolean hasWork() {
        return this.isActive;
    }
}

