/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.workbench;

import cofh.api.core.ICustomInventory;
import cofh.api.inventory.IInventoryRetainer;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.workbench.BlockWorkbench;
import cofh.thermalexpansion.gui.client.GuiWorkbench;
import cofh.thermalexpansion.gui.container.ContainerWorkbench;
import cofh.thermalexpansion.util.helpers.SchematicHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileWorkbench
extends TileInventory
implements ICustomInventory,
ISidedInventory,
IInventoryRetainer {
    public static int[] INVENTORY = new int[]{36, 18, 27, 33, 36};
    public static int[] SCHEMATICS = new int[]{12, 3, 6, 9, 12};
    private static int[][] SLOTS = new int[INVENTORY.length][];
    public static boolean enableSecurity;
    public byte type = 1;
    public int selectedSchematic = 0;
    public boolean[] missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
    public ItemStack[] craftingGrid = new ItemStack[9];
    public boolean updateClient = false;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileWorkbench.class, (String)"thermalexpansion.NewWorkbench");
        TileWorkbench.configure();
    }

    public static void configure() {
        String var0 = "Enable this to allow for Workbenches to be securable.";
        enableSecurity = ThermalExpansion.config.get("Security", "Workbench.All.Securable", enableSecurity, var0);
    }

    public TileWorkbench() {
        this.inventory = new ItemStack[SCHEMATICS[1] + INVENTORY[1]];
    }

    public TileWorkbench(int var1) {
        this.type = (byte)var1;
        this.inventory = new ItemStack[SCHEMATICS[var1] + INVENTORY[var1]];
    }

    public String getName() {
        return "tile.thermalexpansion.workbench." + BlockWorkbench.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public int getCurrentSchematicSlot() {
        return this.selectedSchematic;
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean createItem(boolean var1, ItemStack stack) {
        ItemStack[] inventory = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean var6 = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack gridStack = this.craftingGrid[i];
            String oreName = OreDictionaryArbiter.getOreName((ItemStack)gridStack);
            if (gridStack == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                ItemStack var9;
                if (inventory[j] == null || !ItemHelper.craftingEquivalent((ItemStack)inventory[j], (ItemStack)gridStack, (String)oreName, (ItemStack)stack) || inventory[j].func_77960_j() != gridStack.func_77960_j() || !ItemHelper.doNBTsMatch((NBTTagCompound)inventory[j].field_77990_d, (NBTTagCompound)gridStack.field_77990_d)) continue;
                this.craftingGrid[i] = ItemHelper.cloneStack((ItemStack)inventory[j], (int)1);
                --inventory[j].field_77994_a;
                if (inventory[j].func_77973_b().hasContainerItem(inventory[j]) && (var9 = inventory[j].func_77973_b().getContainerItem(inventory[j])) != null) {
                    if (var9.func_77984_f() && var9.func_77960_j() > var9.func_77958_k()) {
                        var9 = null;
                    }
                    if (!(var9 == null || inventory[j].func_77973_b().func_77630_h(inventory[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])inventory, (ItemStack)var9, (int)SCHEMATICS[this.type]))) {
                        if (inventory[j].field_77994_a > 0) {
                            return false;
                        }
                        inventory[j] = var9;
                        if (var9.field_77994_a <= 0) {
                            inventory[j].field_77994_a = 1;
                        }
                    }
                }
                if (inventory[j].field_77994_a <= 0) {
                    inventory[j] = null;
                }
                var6 = true;
                break;
            }
            if (!var6) {
                return false;
            }
            var6 = false;
        }
        if (var1) {
            this.inventory = inventory;
        }
        return true;
    }

    public boolean createItemClient(boolean var1, ItemStack stack) {
        ItemStack[] inventory = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean var6 = false;
        boolean var7 = true;
        this.missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
        for (int i = 0; i < 9; ++i) {
            ItemStack gridStack = this.craftingGrid[i];
            String oreName = OreDictionaryArbiter.getOreName((ItemStack)gridStack);
            if (gridStack == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                if (inventory[j] == null || !ItemHelper.craftingEquivalent((ItemStack)inventory[j], (ItemStack)gridStack, (String)oreName, (ItemStack)stack) || inventory[j].func_77960_j() != gridStack.func_77960_j() || !ItemHelper.doNBTsMatch((NBTTagCompound)inventory[j].field_77990_d, (NBTTagCompound)gridStack.field_77990_d)) continue;
                this.craftingGrid[i] = ItemHelper.cloneStack((ItemStack)inventory[j], (int)1);
                --inventory[j].field_77994_a;
                if (inventory[j].func_77973_b().hasContainerItem(inventory[j])) {
                    ItemStack var10 = inventory[j].func_77973_b().getContainerItem(inventory[j]);
                    if (var10 == null || var10.func_77984_f() && var10.func_77960_j() > var10.func_77958_k()) {
                        var10 = null;
                    }
                    if (!(var10 == null || inventory[j].func_77973_b().func_77630_h(inventory[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])inventory, (ItemStack)var10, (int)2))) {
                        if (inventory[j].field_77994_a > 0) {
                            return false;
                        }
                        inventory[j] = var10;
                        if (var10.field_77994_a <= 0) {
                            inventory[j].field_77994_a = 1;
                        }
                    }
                }
                if (inventory[j].field_77994_a <= 0) {
                    inventory[j] = null;
                }
                var6 = true;
                break;
            }
            if (!var6) {
                var7 = false;
                this.missingItem[i] = true;
            }
            var6 = false;
        }
        if (!var7) {
            return false;
        }
        if (var1) {
            this.inventory = inventory;
        }
        return true;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    public void clearCraftingGrid() {
        this.updateClient = true;
        for (int var1 = 0; var1 < 9; ++var1) {
            this.craftingGrid[var1] = null;
        }
        PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.CLEAR_GRID.ordinal()));
    }

    public void setCraftingGrid() {
        this.updateClient = true;
        for (int var1 = 0; var1 < 9; ++var1) {
            this.craftingGrid[var1] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), var1);
        }
        PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.SET_GRID.ordinal()));
    }

    public void setCurrentSchematicSlot(int var1) {
        this.selectedSchematic = var1;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase var1 = super.getPacket();
        var1.addByte(this.type);
        var1.addByte(this.selectedSchematic);
        return var1;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        return null;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase var1, boolean var2) {
        super.handleTilePacket(var1, var2);
        this.type = var1.getByte();
        this.selectedSchematic = var1.getByte();
    }

    @Override
    public void handleTileInfoPacket(PacketCoFHBase var1, boolean var2, EntityPlayer var3) {
        byte var4 = var1.getByte();
        if (var4 == PacketInfoID.CLEAR_GRID.ordinal()) {
            for (int var5 = 0; var5 < 9; ++var5) {
                this.craftingGrid[var5] = null;
                if (var3.field_71070_bA == null) continue;
                var3.field_71070_bA.func_75130_a(null);
            }
        } else if (var4 == PacketInfoID.SET_GRID.ordinal()) {
            for (int var7 = 0; var7 < 9; ++var7) {
                this.craftingGrid[var7] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), var7);
                if (var3.field_71070_bA == null) continue;
                var3.field_71070_bA.func_75130_a(null);
            }
        } else if (var4 == PacketInfoID.NEI_SUP.ordinal()) {
            byte var8;
            for (int var6 = 0; var6 < 9; ++var6) {
                this.craftingGrid[var6] = null;
            }
            while ((var8 = var1.getByte()) >= 0) {
                this.craftingGrid[var8] = var1.getItemStack();
            }
            Container var9 = var3.field_71070_bA;
            if (var9 != null) {
                ((ICrafting)var3).func_71110_a(var9, var9.func_75138_a());
                var9.func_75130_a(null);
            }
        }
    }

    public Object getGuiClient(InventoryPlayer var1) {
        return new GuiWorkbench(var1, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer var1) {
        return new ContainerWorkbench(var1, (TileEntity)this);
    }

    @Override
    public void sendGuiNetworkData(Container var1, ICrafting var2) {
        var2.func_71112_a(var1, 0, this.canPlayerAccess((EntityPlayer)var2) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound var1) {
        this.type = var1.func_74771_c("Type");
        this.selectedSchematic = var1.func_74771_c("Mode");
        this.readCraftingFromNBT(var1);
        this.inventory = new ItemStack[SCHEMATICS[this.type] + INVENTORY[this.type]];
        super.func_145839_a(var1);
    }

    @Override
    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        var1.func_74774_a("Type", this.type);
        var1.func_74774_a("Mode", (byte)this.selectedSchematic);
        this.writeCraftingToNBT(var1);
    }

    public void readCraftingFromNBT(NBTTagCompound var1) {
        NBTTagList var2 = var1.func_150295_c("Crafting", 10);
        this.craftingGrid = new ItemStack[9];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74762_e("Slot");
            if (var5 < 0 || var5 >= this.craftingGrid.length) continue;
            this.craftingGrid[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void writeCraftingToNBT(NBTTagCompound var1) {
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.craftingGrid.length; ++var3) {
            if (this.craftingGrid[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74768_a("Slot", var3);
            this.craftingGrid[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        var1.func_74782_a("Crafting", (NBTBase)var2);
    }

    @Override
    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack var3 = super.func_70298_a(var1, var2);
        this.updateClient = true;
        return var3;
    }

    @Override
    public void func_70299_a(int var1, ItemStack var2) {
        super.func_70299_a(var1, var2);
        this.updateClient = true;
    }

    public ItemStack[] getInventorySlots(int var1) {
        return this.craftingGrid;
    }

    public int getSlotStackLimit(int var1) {
        return 1;
    }

    public void onSlotUpdate() {
        this.func_70296_d();
    }

    public int[] func_94128_d(int var1) {
        return SLOTS[this.type];
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return var1 >= SCHEMATICS[this.type];
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return var1 >= SCHEMATICS[this.type];
    }

    static {
        for (int var0 = 0; var0 < SLOTS.length; ++var0) {
            int[] var1 = new int[INVENTORY[var0]];
            int var3 = SCHEMATICS[var0];
            for (int var2 = 0; var2 < var1.length; ++var2) {
                var1[var2] = var3++;
            }
            TileWorkbench.SLOTS[var0] = var1;
        }
        enableSecurity = true;
    }

    public static enum PacketInfoID {
        CLEAR_GRID,
        SET_GRID,
        NEI_SUP;

    }
}

