/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.item.ItemBase;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import com.gamerforea.cofh.EventConfig;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemCapacitor
extends ItemBase
implements IEnergyContainerItem {
    public static final String[] NAMES = new String[]{"creative", "potato", "basic", "hardened", "reinforced", "resonant"};
    public static boolean[] ENABLE = new boolean[]{true, true, true, true, true, true};
    public static int[] SEND = new int[]{100000, 160, 80, 400, 4000, 16000};
    public static int[] RECEIVE = new int[]{0, 0, 200, 800, 8000, 32000};
    public static int[] CAPACITY = new int[]{100000, 32000, 80000, 400000, 4000000, 20000000};

    public ItemCapacitor() {
        super("thermalexpansion");
        if (EventConfig.fixMaxDamage) {
            this.func_77627_a(true);
            this.func_77656_e(0);
        } else {
            this.func_77656_e(1);
        }
        this.func_77625_d(1);
        this.func_77637_a(ThermalExpansion.tabTools);
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public void func_150895_a(Item var1, CreativeTabs var2, List var3) {
        if (ENABLE[0]) {
            var3.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(var1, 1, Types.CREATIVE.ordinal()), (int)CAPACITY[Types.CREATIVE.ordinal()]));
        }
        var3.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(var1, 1, Types.POTATO.ordinal()), (int)CAPACITY[Types.POTATO.ordinal()]));
        for (int var4 = 2; var4 < Types.values().length; ++var4) {
            var3.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(var1, 1, var4), (int)0));
            var3.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(var1, 1, var4), (int)CAPACITY[var4]));
        }
    }

    public String func_77667_c(ItemStack var1) {
        return "item.thermalexpansion.capacitor." + NAMES[ItemHelper.getItemDamage((ItemStack)var1)];
    }

    public void func_77624_a(ItemStack var1, EntityPlayer var2, List var3, boolean var4) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            var3.add(StringHelper.shiftForDetails());
        }
        if (var1.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)var1, (int)0);
        }
        if (StringHelper.isShiftKeyDown()) {
            if (ItemHelper.getItemDamage((ItemStack)var1) == Types.CREATIVE.ordinal()) {
                var3.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
                var3.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + SEND[Types.CREATIVE.ordinal()] + " RF/t");
            } else {
                var3.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)var1.field_77990_d.func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber((long)CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)]) + " RF");
                var3.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + SEND[ItemHelper.getItemDamage((ItemStack)var1)] + "/" + RECEIVE[ItemHelper.getItemDamage((ItemStack)var1)] + " RF/t");
            }
            if (this.isActive(var1)) {
                var3.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.2"));
                var3.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.4"));
                var3.add(StringHelper.getDeactivationText((String)"info.thermalexpansion.capacitor.3"));
            } else {
                var3.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.0"));
                var3.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.4"));
                var3.add(StringHelper.getActivationText((String)"info.thermalexpansion.capacitor.1"));
            }
            if (ItemHelper.getItemDamage((ItemStack)var1) == Types.POTATO.ordinal()) {
                var3.add(StringHelper.getFlavorText((String)"info.thermalexpansion.capacitor.potato"));
            }
        }
    }

    public void func_77663_a(ItemStack var1, World var2, Entity var3, int var4, boolean var5) {
        if (var4 <= 8 && this.isActive(var1) && !var5) {
            InventoryPlayer var6 = ((EntityPlayer)var3).field_71071_by;
            int var8 = Math.min(this.getEnergyStored(var1), SEND[ItemHelper.getItemDamage((ItemStack)var1)]);
            ItemStack var9 = var6.func_70448_g();
            if (EnergyHelper.isEnergyContainerItem((ItemStack)var9)) {
                IEnergyContainerItem var7 = (IEnergyContainerItem)var9.func_77973_b();
                this.extractEnergy(var1, var7.receiveEnergy(var9, var8, false), false);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack var1, World var2, EntityPlayer var3) {
        if (CoreUtils.isFakePlayer((EntityPlayer)var3)) {
            return var1;
        }
        if (var3.func_70093_af() && this.setActiveState(var1, !this.isActive(var1))) {
            if (this.isActive(var1)) {
                var3.field_70170_p.func_72956_a((Entity)var3, "random.orb", 0.2f, 0.8f);
            } else {
                var3.field_70170_p.func_72956_a((Entity)var3, "random.orb", 0.2f, 0.5f);
            }
        }
        var3.func_71038_i();
        return var1;
    }

    public boolean func_77636_d(ItemStack var1) {
        return this.isActive(var1);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack var1) {
        return false;
    }

    public boolean isDamaged(ItemStack var1) {
        return ItemHelper.getItemDamage((ItemStack)var1) != Types.CREATIVE.ordinal();
    }

    public boolean func_77648_a(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, int var7, float var8, float var9, float var10) {
        return false;
    }

    public int getDisplayDamage(ItemStack var1) {
        return var1.field_77990_d == null ? CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)] : CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)] - var1.field_77990_d.func_74762_e("Energy");
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77960_j() != Types.CREATIVE.ordinal();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp((double)(1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack)), (double)0.0, (double)1.0);
    }

    public int getMaxDamage(ItemStack stack) {
        if (EventConfig.fixMaxDamage) {
            return super.getMaxDamage(stack);
        }
        return CAPACITY[ItemHelper.getItemDamage((ItemStack)stack)];
    }

    public int receiveEnergy(ItemStack var1, int var2, boolean var3) {
        int var4 = ItemHelper.getItemDamage((ItemStack)var1);
        if (var4 <= Types.POTATO.ordinal()) {
            return 0;
        }
        if (var1.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)var1, (int)0);
        }
        int var5 = var1.field_77990_d.func_74762_e("Energy");
        int var6 = Math.min(var2, Math.min(CAPACITY[var4] - var5, RECEIVE[var4]));
        if (!var3 && var1.func_77960_j() != Types.CREATIVE.ordinal()) {
            var1.field_77990_d.func_74768_a("Energy", var5 += var6);
        }
        return var6;
    }

    public int extractEnergy(ItemStack var1, int var2, boolean var3) {
        if (var1.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)var1, (int)0);
        }
        int var4 = var1.field_77990_d.func_74762_e("Energy");
        int var5 = Math.min(var2, Math.min(var4, SEND[ItemHelper.getItemDamage((ItemStack)var1)]));
        if (!var3 && var1.func_77960_j() != Types.CREATIVE.ordinal()) {
            var1.field_77990_d.func_74768_a("Energy", var4 -= var5);
            if (var4 == 0 && var1.func_77960_j() == Types.POTATO.ordinal()) {
                var1.func_150996_a(Items.field_151168_bH);
            }
        }
        return var5;
    }

    public int getEnergyStored(ItemStack var1) {
        if (var1.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)var1, (int)0);
        }
        return var1.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack var1) {
        return CAPACITY[var1.func_77960_j()];
    }

    public boolean isActive(ItemStack var1) {
        return var1.field_77990_d != null && var1.field_77990_d.func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack var1, boolean var2) {
        if (this.getEnergyStored(var1) > 0) {
            var1.field_77990_d.func_74757_a("Active", var2);
            return true;
        }
        var1.field_77990_d.func_74757_a("Active", false);
        return false;
    }

    static {
        String var0 = "Item.Capacitor.";
        String var1 = var0 + StringHelper.titleCase((String)NAMES[0]);
        ItemCapacitor.ENABLE[0] = ThermalExpansion.config.get(var1, "Enable", ENABLE[0]);
        for (int var2 = 1; var2 < Types.values().length; ++var2) {
            var1 = var0 + StringHelper.titleCase((String)NAMES[var2]);
            ItemCapacitor.ENABLE[var2] = ThermalExpansion.config.get(var1, "Recipe", ENABLE[var2]);
        }
        var1 = var0 + StringHelper.titleCase((String)NAMES[5]);
        ItemCapacitor.CAPACITY[5] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Capacity", CAPACITY[5]), (int)(CAPACITY[5] / 10), (int)1000000000);
        ItemCapacitor.SEND[5] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Send", SEND[5]), (int)(SEND[5] / 10), (int)(SEND[5] * 1000));
        ItemCapacitor.RECEIVE[5] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Receive", RECEIVE[5]), (int)(RECEIVE[5] / 10), (int)(RECEIVE[4] * 1000));
        var1 = var0 + StringHelper.titleCase((String)NAMES[4]);
        ItemCapacitor.CAPACITY[4] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Capacity", CAPACITY[4]), (int)(CAPACITY[4] / 10), (int)CAPACITY[5]);
        ItemCapacitor.SEND[4] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Send", SEND[4]), (int)(SEND[4] / 10), (int)(SEND[4] * 1000));
        ItemCapacitor.RECEIVE[4] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Receive", RECEIVE[4]), (int)(RECEIVE[4] / 10), (int)(RECEIVE[4] * 1000));
        var1 = var0 + StringHelper.titleCase((String)NAMES[3]);
        ItemCapacitor.CAPACITY[3] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Capacity", CAPACITY[3]), (int)(CAPACITY[3] / 10), (int)CAPACITY[4]);
        ItemCapacitor.SEND[3] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Send", SEND[3]), (int)(SEND[3] / 10), (int)(SEND[3] * 1000));
        ItemCapacitor.RECEIVE[3] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Receive", RECEIVE[3]), (int)(RECEIVE[3] / 10), (int)(RECEIVE[3] * 1000));
        var1 = var0 + StringHelper.titleCase((String)NAMES[2]);
        ItemCapacitor.CAPACITY[2] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Capacity", CAPACITY[2]), (int)(CAPACITY[2] / 10), (int)CAPACITY[3]);
        ItemCapacitor.RECEIVE[2] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Receive", RECEIVE[2]), (int)(RECEIVE[2] / 10), (int)(RECEIVE[2] * 1000));
        ItemCapacitor.SEND[2] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Send", SEND[2]), (int)(SEND[2] / 10), (int)(SEND[2] * 1000));
        var1 = var0 + StringHelper.titleCase((String)NAMES[1]);
        ItemCapacitor.CAPACITY[1] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Capacity", CAPACITY[1]), (int)(CAPACITY[1] / 10), (int)CAPACITY[2]);
        ItemCapacitor.SEND[1] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Send", SEND[1]), (int)(SEND[1] / 10), (int)(SEND[1] * 1000));
        var1 = var0 + StringHelper.titleCase((String)NAMES[0]);
        ItemCapacitor.SEND[0] = MathHelper.clamp((int)ThermalExpansion.config.get(var1, "Send", SEND[0]), (int)(SEND[0] / 10), (int)(SEND[0] * 1000));
        ItemCapacitor.CAPACITY[0] = SEND[0];
    }

    public static enum Types {
        CREATIVE,
        POTATO,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

