/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.core.CoFHProps;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.crafting.ChargerManager;
import cofh.thermalexpansion.util.crafting.CrucibleManager;
import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cofh.thermalexpansion.util.crafting.InsolatorManager;
import cofh.thermalexpansion.util.crafting.PulverizerManager;
import cofh.thermalexpansion.util.crafting.SawmillManager;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class TECraftingParser {
    private static File craftingFolder;

    private TECraftingParser() {
    }

    public static void initialize() {
        craftingFolder = new File(CoFHProps.configDir, "/cofh/thermalexpansion/crafting/");
        if (!craftingFolder.exists()) {
            try {
                craftingFolder.mkdir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void addFiles(ArrayList<File> arrayList, File file) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                if (string == null) {
                    return false;
                }
                return string.toLowerCase(Locale.US).endsWith(".json") || new File(file, string).isDirectory();
            }
        });
        if (fileArray == null || fileArray.length <= 0) {
            ThermalExpansion.log.info("There are no crafting files present in " + file + ".");
            return;
        }
        ThermalExpansion.log.info(fileArray.length + " crafting files present in " + file + "/.");
        arrayList.addAll(Arrays.asList(fileArray));
    }

    public static void parseCraftingFiles() {
        JsonParser jsonParser = new JsonParser();
        ArrayList<File> arrayList = new ArrayList<File>();
        TECraftingParser.addFiles(arrayList, craftingFolder);
        for (int i = 0; i < arrayList.size(); ++i) {
            JsonObject jsonObject;
            File file = arrayList.get(i);
            if (file.isDirectory()) {
                TECraftingParser.addFiles(arrayList, file);
                continue;
            }
            try {
                jsonObject = (JsonObject)jsonParser.parse((Reader)new FileReader(file));
            }
            catch (Throwable throwable) {
                ThermalExpansion.log.error("Critical error reading from a crafting file: " + file + " > Please be sure the file is correct!", throwable);
                continue;
            }
            ThermalExpansion.log.info("Reading template info from: " + file + ":");
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (TECraftingParser.acquireCraftingEntry((String)entry.getKey(), (JsonElement)entry.getValue())) {
                    ThermalExpansion.log.debug("Crafting entry added: \"" + (String)entry.getKey() + "\"");
                    continue;
                }
                ThermalExpansion.log.error("Error handling entry: \"" + (String)entry.getKey() + "\" > Please check the parameters. If adding a recipe, it *may* conflict with an existing recipe or entry. If removing a recipe, the recipe may not have existed.");
            }
        }
    }

    private static boolean acquireCraftingEntry(String string, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String string2 = jsonObject.get("type").getAsString().toLowerCase(Locale.US);
        boolean bl = false;
        if (jsonObject.has("remove")) {
            bl = jsonObject.get("remove").getAsBoolean();
        }
        if (!bl) {
            if (string2.equals("furnace") || string2.equalsIgnoreCase("furnaceAdd")) {
                return TECraftingParser.addFurnaceRecipe(string, jsonObject);
            }
            if (string2.equals("pulverizer") || string2.equalsIgnoreCase("pulverizerAdd")) {
                return TECraftingParser.addPulverizerRecipe(string, jsonObject);
            }
            if (string2.equals("sawmill") || string2.equalsIgnoreCase("sawmillAdd")) {
                return TECraftingParser.addSawmillRecipe(string, jsonObject);
            }
            if (string2.equals("smelter") || string2.equalsIgnoreCase("smelterAdd")) {
                return TECraftingParser.addSmelterRecipe(string, jsonObject);
            }
            if (string2.equals("crucible") || string2.equalsIgnoreCase("crucibleAdd")) {
                return TECraftingParser.addCrucibleRecipe(string, jsonObject);
            }
            if (string2.equals("transposer") || string2.equalsIgnoreCase("transposerAdd")) {
                return TECraftingParser.addTransposerRecipe(string, jsonObject);
            }
            if (string2.equals("charger") || string2.equalsIgnoreCase("chargerAdd")) {
                return TECraftingParser.addChargerRecipe(string, jsonObject);
            }
            if (string2.equals("insolator") || string2.equalsIgnoreCase("insolatorAdd")) {
                return TECraftingParser.addInsolatorRecipe(string, jsonObject);
            }
        }
        if (string2.equals("furnace") || string2.equals("furnaceRemove") || string2.equalsIgnoreCase("furnaceRem")) {
            return TECraftingParser.removeFurnaceRecipe(string, jsonObject);
        }
        if (string2.equals("pulverizer") || string2.equals("pulverizerRemove") || string2.equalsIgnoreCase("pulverizerRem")) {
            return TECraftingParser.removePulverizerRecipe(string, jsonObject);
        }
        if (string2.equals("sawmill") || string2.equals("sawmillRemove") || string2.equalsIgnoreCase("sawmillRem")) {
            return TECraftingParser.removeSawmillRecipe(string, jsonObject);
        }
        if (string2.equals("smelter") || string2.equals("smelterRemove") || string2.equalsIgnoreCase("smelterRem")) {
            return TECraftingParser.removeSmelterRecipe(string, jsonObject);
        }
        if (string2.equals("crucible") || string2.equals("crucibleRemove") || string2.equalsIgnoreCase("crucibleRem")) {
            return TECraftingParser.removeCrucibleRecipe(string, jsonObject);
        }
        if (string2.equals("transposer") || string2.equals("transposerRemove") || string2.equalsIgnoreCase("transposerRem")) {
            return TECraftingParser.removeTransposerRecipe(string, jsonObject);
        }
        if (string2.equals("charger") || string2.equals("chargerRemove") || string2.equalsIgnoreCase("chargerRem")) {
            return TECraftingParser.removeChargerRecipe(string, jsonObject);
        }
        if (string2.equals("insolator") || string2.equals("insolatorRemove") || string2.equalsIgnoreCase("insolatorRem")) {
            return TECraftingParser.removeInsolatorRecipe(string, jsonObject);
        }
        return false;
    }

    private static boolean addFurnaceRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") || !jsonObject.has("output")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        ItemStack itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("output"));
        int n = 1600;
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 1600;
        }
        return FurnaceManager.addRecipe(n, itemStack, itemStack2, true);
    }

    private static boolean addPulverizerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        if (!jsonObject.has("output") && !jsonObject.has("primaryOutput")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        ItemStack itemStack2 = null;
        ItemStack itemStack3 = null;
        int n = 3200;
        int n2 = 100;
        if (jsonObject.has("output")) {
            JsonElement jsonElement = jsonObject.get("output");
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject2 = (JsonObject)jsonElement;
                itemStack2 = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack3 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("output"));
                if (jsonObject.has("secondaryOutput")) {
                    itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
                }
            }
        } else {
            if (jsonObject.has("primaryOutput")) {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("primaryOutput"));
            }
            if (jsonObject.has("secondaryOutput")) {
                itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
            }
        }
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 3200;
        }
        if (jsonObject.has("chance")) {
            n2 = jsonObject.get("chance").getAsInt();
        } else if (jsonObject.has("secondaryChance")) {
            n2 = jsonObject.get("secondaryChance").getAsInt();
        }
        if (n2 <= 0) {
            n2 = 100;
        }
        return PulverizerManager.addRecipe(n, itemStack, itemStack2, itemStack3, n2, true);
    }

    private static boolean addSawmillRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        if (!jsonObject.has("output") && !jsonObject.has("primaryOutput")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        ItemStack itemStack2 = null;
        ItemStack itemStack3 = null;
        int n = 1600;
        int n2 = 100;
        if (jsonObject.has("output")) {
            JsonElement jsonElement = jsonObject.get("output");
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject2 = (JsonObject)jsonElement;
                itemStack2 = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack3 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("output"));
                if (jsonObject.has("secondaryOutput")) {
                    itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
                }
            }
        } else {
            if (jsonObject.has("primaryOutput")) {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("primaryOutput"));
            }
            if (jsonObject.has("secondaryOutput")) {
                itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
            }
        }
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 1600;
        }
        if (jsonObject.has("chance")) {
            n2 = jsonObject.get("chance").getAsInt();
        } else if (jsonObject.has("secondaryChance")) {
            n2 = jsonObject.get("secondaryChance").getAsInt();
        }
        if (n2 <= 0) {
            n2 = 100;
        }
        return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, n2, true);
    }

    private static boolean addSmelterRecipe(String string, JsonObject jsonObject) {
        JsonObject jsonObject2;
        JsonElement jsonElement;
        if (!jsonObject.has("input") && !jsonObject.has("primaryInput")) {
            return false;
        }
        if (!jsonObject.has("output") && !jsonObject.has("primaryOutput")) {
            return false;
        }
        ItemStack itemStack = null;
        ItemStack itemStack2 = null;
        ItemStack itemStack3 = null;
        ItemStack itemStack4 = null;
        int n = 3200;
        int n2 = 100;
        if (jsonObject.has("input")) {
            jsonElement = jsonObject.get("input");
            if (jsonElement.isJsonObject()) {
                jsonObject2 = (JsonObject)jsonElement;
                itemStack = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack2 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
                if (jsonObject.has("secondaryInput")) {
                    itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
                }
            }
        } else {
            if (jsonObject.has("primaryInput")) {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("primaryInput"));
            }
            if (jsonObject.has("secondaryInput")) {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
            }
        }
        if (jsonObject.has("output")) {
            jsonElement = jsonObject.get("output");
            if (jsonElement.isJsonObject()) {
                jsonObject2 = (JsonObject)jsonElement;
                itemStack3 = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack4 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("output"));
                if (jsonObject.has("secondaryOutput")) {
                    itemStack4 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
                }
            }
        } else {
            if (jsonObject.has("primaryOutput")) {
                itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("primaryOutput"));
            }
            if (jsonObject.has("secondaryOutput")) {
                itemStack4 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
            }
        }
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 3200;
        }
        if (jsonObject.has("chance")) {
            n2 = jsonObject.get("chance").getAsInt();
        } else if (jsonObject.has("secondaryChance")) {
            n2 = jsonObject.get("secondaryChance").getAsInt();
        }
        if (n2 <= 0) {
            n2 = 100;
        }
        return SmelterManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, n2, true);
    }

    private static boolean addCrucibleRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") || !jsonObject.has("output")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        FluidStack fluidStack = TECraftingParser.parseFluidStack(jsonObject.get("output"));
        int n = 8000;
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 8000;
        }
        return CrucibleManager.addRecipe(n, itemStack, fluidStack, true);
    }

    private static boolean addTransposerRecipe(String string, JsonObject jsonObject) {
        String string2;
        if (!(jsonObject.has("input") && jsonObject.has("output") && jsonObject.has("fluid"))) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        ItemStack itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("output"));
        FluidStack fluidStack = TECraftingParser.parseFluidStack(jsonObject.get("fluid"));
        int n = 1600;
        int n2 = 100;
        boolean bl = false;
        boolean bl2 = false;
        if (jsonObject.has("style") && (string2 = jsonObject.get("style").getAsString()).equalsIgnoreCase("extract")) {
            bl = true;
        }
        if (jsonObject.has("reversible")) {
            bl2 = jsonObject.get("reversible").getAsBoolean();
        }
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 1600;
        }
        if (jsonObject.has("chance")) {
            n2 = jsonObject.get("chance").getAsInt();
            bl = true;
        } else if (jsonObject.has("secondaryChance")) {
            n2 = jsonObject.get("secondaryChance").getAsInt();
            bl = true;
        }
        if (n2 <= 0) {
            n2 = 100;
        }
        if (bl) {
            return TransposerManager.addExtractionRecipe(n, itemStack, itemStack2, fluidStack, n2, bl2, true);
        }
        return TransposerManager.addFillRecipe(n, itemStack, itemStack2, fluidStack, bl2, true);
    }

    private static boolean addChargerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") || !jsonObject.has("output")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        ItemStack itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("output"));
        int n = 4000;
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 4000;
        }
        return ChargerManager.addRecipe(n, itemStack, itemStack2, true);
    }

    private static boolean addInsolatorRecipe(String string, JsonObject jsonObject) {
        JsonObject jsonObject2;
        JsonElement jsonElement;
        if (!jsonObject.has("input") && !jsonObject.has("primaryInput")) {
            return false;
        }
        if (!jsonObject.has("output") && !jsonObject.has("primaryOutput")) {
            return false;
        }
        ItemStack itemStack = null;
        ItemStack itemStack2 = null;
        ItemStack itemStack3 = null;
        ItemStack itemStack4 = null;
        int n = 7200;
        int n2 = 100;
        if (jsonObject.has("input")) {
            jsonElement = jsonObject.get("input");
            if (jsonElement.isJsonObject()) {
                jsonObject2 = (JsonObject)jsonElement;
                itemStack = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack2 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
                if (jsonObject.has("secondaryInput")) {
                    itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
                }
            }
        } else {
            if (jsonObject.has("primaryInput")) {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("primaryInput"));
            }
            if (jsonObject.has("secondaryInput")) {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
            }
        }
        if (jsonObject.has("output")) {
            jsonElement = jsonObject.get("output");
            if (jsonElement.isJsonObject()) {
                jsonObject2 = (JsonObject)jsonElement;
                itemStack3 = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack4 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("output"));
                if (jsonObject.has("secondaryOutput")) {
                    itemStack4 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
                }
            }
        } else {
            if (jsonObject.has("primaryOutput")) {
                itemStack3 = TECraftingParser.parseItemStack(jsonObject.get("primaryOutput"));
            }
            if (jsonObject.has("secondaryOutput")) {
                itemStack4 = TECraftingParser.parseItemStack(jsonObject.get("secondaryOutput"));
            }
        }
        if (jsonObject.has("energy")) {
            n = jsonObject.get("energy").getAsInt();
        }
        if (n <= 0) {
            n = 7200;
        }
        if (jsonObject.has("chance")) {
            n2 = jsonObject.get("chance").getAsInt();
        } else if (jsonObject.has("secondaryChance")) {
            n2 = jsonObject.get("secondaryChance").getAsInt();
        }
        if (n2 <= 0) {
            n2 = 100;
        }
        return InsolatorManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, n2, true);
    }

    private static boolean removeFurnaceRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        return FurnaceManager.removeRecipe(itemStack);
    }

    private static boolean removePulverizerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        return PulverizerManager.removeRecipe(itemStack);
    }

    private static boolean removeSawmillRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        return SawmillManager.removeRecipe(itemStack);
    }

    private static boolean removeSmelterRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") && !jsonObject.has("primaryInput")) {
            return false;
        }
        ItemStack itemStack = null;
        ItemStack itemStack2 = null;
        if (jsonObject.has("input")) {
            JsonElement jsonElement = jsonObject.get("input");
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject2 = (JsonObject)jsonElement;
                itemStack = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack2 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
                if (jsonObject.has("secondaryInput")) {
                    itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
                }
            }
        } else {
            if (jsonObject.has("primaryInput")) {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("primaryInput"));
            }
            if (jsonObject.has("secondaryInput")) {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
            }
        }
        return SmelterManager.removeRecipe(itemStack, itemStack2);
    }

    private static boolean removeCrucibleRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        return CrucibleManager.removeRecipe(itemStack);
    }

    private static boolean removeTransposerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        FluidStack fluidStack = null;
        boolean bl = true;
        if (jsonObject.has("fluid")) {
            fluidStack = TECraftingParser.parseFluidStack(jsonObject.get("fluid"));
            bl = false;
        }
        if (bl) {
            return TransposerManager.removeExtractionRecipe(itemStack);
        }
        return TransposerManager.removeFillRecipe(itemStack, fluidStack);
    }

    private static boolean removeChargerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        ItemStack itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
        return ChargerManager.removeRecipe(itemStack);
    }

    private static boolean removeInsolatorRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") && !jsonObject.has("primaryInput")) {
            return false;
        }
        ItemStack itemStack = null;
        ItemStack itemStack2 = null;
        if (jsonObject.has("input")) {
            JsonElement jsonElement = jsonObject.get("input");
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject2 = (JsonObject)jsonElement;
                itemStack = TECraftingParser.parseItemStack(jsonObject2.get("primary"));
                itemStack2 = TECraftingParser.parseItemStack(jsonObject2.get("secondary"));
            } else {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("input"));
                if (jsonObject.has("secondaryInput")) {
                    itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
                }
            }
        } else {
            if (jsonObject.has("primaryInput")) {
                itemStack = TECraftingParser.parseItemStack(jsonObject.get("primaryInput"));
            }
            if (jsonObject.has("secondaryInput")) {
                itemStack2 = TECraftingParser.parseItemStack(jsonObject.get("secondaryInput"));
            }
        }
        return InsolatorManager.removeRecipe(itemStack, itemStack2);
    }

    public static ItemStack parseItemStack(JsonElement jsonElement) {
        ItemStack itemStack;
        if (jsonElement.isJsonNull()) {
            return null;
        }
        int n = 0;
        int n2 = 1;
        if (jsonElement.isJsonPrimitive()) {
            itemStack = new ItemStack((Item)GameData.getItemRegistry().func_82594_a(jsonElement.getAsString()), 1, n);
        } else {
            ItemStack itemStack2;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("meta")) {
                n = jsonObject.get("meta").getAsInt();
            } else if (jsonObject.has("metadata")) {
                n = jsonObject.get("metadata").getAsInt();
            }
            if (jsonObject.has("stackSize")) {
                n2 = jsonObject.get("stackSize").getAsInt();
            } else if (jsonObject.has("quantity")) {
                n2 = jsonObject.get("quantity").getAsInt();
            } else if (jsonObject.has("amount")) {
                n2 = jsonObject.get("amount").getAsInt();
            }
            if (n2 <= 0) {
                n2 = 1;
            }
            if (jsonObject.has("oreName") && ItemHelper.oreNameExists((String)jsonObject.get("oreName").getAsString())) {
                itemStack2 = (ItemStack)OreDictionary.getOres((String)jsonObject.get("oreName").getAsString()).get(0);
                itemStack = ItemHelper.cloneStack((ItemStack)itemStack2, (int)n2);
            } else {
                if (!jsonObject.has("name")) {
                    ThermalExpansion.log.error("Item entry missing valid name or oreName!");
                    return null;
                }
                itemStack = new ItemStack((Item)GameData.getItemRegistry().func_82594_a(jsonObject.get("name").getAsString()), n2, n);
            }
            if (jsonObject.has("nbt")) {
                try {
                    itemStack2 = JsonToNBT.func_150315_a((String)jsonObject.get("nbt").getAsString());
                    if (!(itemStack2 instanceof NBTTagCompound)) {
                        ThermalExpansion.log.error("Item has invalid NBT data.");
                    }
                    itemStack.func_77982_d((NBTTagCompound)itemStack2);
                }
                catch (NBTException nBTException) {
                    ThermalExpansion.log.error("Item has invalid NBT data.", (Throwable)nBTException);
                }
            }
        }
        if (itemStack.func_77973_b() == null) {
            return null;
        }
        return itemStack;
    }

    public static FluidStack parseFluidStack(JsonElement jsonElement) {
        FluidStack fluidStack;
        if (jsonElement.isJsonNull()) {
            return null;
        }
        int n = 1000;
        if (jsonElement.isJsonPrimitive()) {
            fluidStack = new FluidStack(FluidRegistry.getFluid((String)jsonElement.getAsString()), n);
        } else {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("amount")) {
                n = jsonObject.get("amount").getAsInt();
            }
            if (n <= 0) {
                n = 1000;
            }
            if (!jsonObject.has("name")) {
                ThermalExpansion.log.error("Fluid entry missing valid name!");
                return null;
            }
            fluidStack = new FluidStack(FluidRegistry.getFluid((String)jsonObject.get("name").getAsString()), n);
            if (jsonObject.has("nbt")) {
                try {
                    NBTBase nBTBase = JsonToNBT.func_150315_a((String)jsonObject.get("nbt").getAsString());
                    if (!(nBTBase instanceof NBTTagCompound)) {
                        ThermalExpansion.log.error("Fluid has invalid NBT data.");
                    }
                    fluidStack.tag = (NBTTagCompound)nBTBase;
                }
                catch (NBTException nBTException) {
                    ThermalExpansion.log.error("Fluid has invalid NBT data.", (Throwable)nBTException);
                }
            }
        }
        if (fluidStack.getFluid() == null) {
            return null;
        }
        return fluidStack;
    }
}

