/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.lib.util.BlockWrapper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.DamageHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.TFBlocks;
import cofh.thermalfoundation.entity.monster.EntityBlizz;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class BlockFluidCryotheum
extends BlockFluidInteractive {
    Random random = new Random();
    public static final int LEVELS = 5;
    public static final Material materialFluidCryotheum = new MaterialLiquid(MapColor.field_151657_g);
    private static boolean enableSourceFall = true;
    private static boolean effect = true;

    public BlockFluidCryotheum() {
        super("thermalfoundation", TFFluids.fluidCryotheum, materialFluidCryotheum, "cryotheum");
        this.setQuantaPerBlock(5);
        this.setTickRate(15);
        this.func_149711_c(1000.0f);
        this.func_149713_g(1);
        this.setParticleColor(0.15f, 0.7f, 1.0f);
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, (String)"FluidCryotheum");
        this.addInteraction((Block)Blocks.field_150349_c, Blocks.field_150346_d);
        this.addInteraction(Blocks.field_150355_j, 0, Blocks.field_150432_aD);
        this.addInteraction(Blocks.field_150355_j, Blocks.field_150433_aE);
        this.addInteraction((Block)Blocks.field_150358_i, 0, Blocks.field_150432_aD);
        this.addInteraction((Block)Blocks.field_150358_i, Blocks.field_150433_aE);
        this.addInteraction(Blocks.field_150353_l, 0, Blocks.field_150343_Z);
        this.addInteraction(Blocks.field_150353_l, Blocks.field_150348_b);
        this.addInteraction((Block)Blocks.field_150356_k, 0, Blocks.field_150343_Z);
        this.addInteraction((Block)Blocks.field_150356_k, Blocks.field_150348_b);
        this.addInteraction((Block)Blocks.field_150362_t, Blocks.field_150350_a);
        this.addInteraction((Block)Blocks.field_150329_H, Blocks.field_150350_a);
        this.addInteraction((Block)Blocks.field_150480_ab, Blocks.field_150350_a);
        this.addInteraction((Block)TFBlocks.blockFluidGlowstone, 0, Blocks.field_150426_aN);
        String string = "Fluid.Cryotheum";
        String string2 = "Enable this for Fluid Cryotheum to be worse than lava, except cold.";
        effect = ThermalFoundation.config.get(string, "Effect", true, string2);
        string2 = "Enable this for Fluid Cryotheum Source blocks to gradually fall downwards.";
        enableSourceFall = ThermalFoundation.config.get(string, "Fall", enableSourceFall, string2);
        return true;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        entity.func_70066_B();
        if (!effect) {
            return;
        }
        if (entity.field_70181_x < -0.05 || entity.field_70181_x > 0.05) {
            entity.field_70181_x *= 0.05;
        }
        if (entity.field_70179_y < -0.05 || entity.field_70179_y > 0.05) {
            entity.field_70179_y *= 0.05;
        }
        if (entity.field_70159_w < -0.05 || entity.field_70159_w > 0.05) {
            entity.field_70159_w *= 0.05;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L != 0L) {
            return;
        }
        if (entity instanceof EntityZombie || entity instanceof EntityCreeper) {
            EntitySnowman entitySnowman = new EntitySnowman(world);
            entitySnowman.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            world.func_72838_d((Entity)entitySnowman);
            entity.func_70106_y();
        } else if (entity instanceof EntityBlizz || entity instanceof EntitySnowman) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 120, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 120, 0));
        } else if (entity instanceof EntityBlaze) {
            entity.func_70097_a((DamageSource)DamageHelper.cryotheum, 10.0f);
        } else {
            boolean bl = entity.field_70133_I;
            entity.func_70097_a((DamageSource)DamageHelper.cryotheum, 2.0f);
            entity.field_70133_I = bl;
        }
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return TFFluids.fluidCryotheum.getLuminosity();
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        if (effect) {
            this.checkForInteraction(world, n, n2, n3);
        }
        if (enableSourceFall && world.func_72805_g(n, n2, n3) == 0) {
            Block block = world.func_147439_a(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            int n4 = world.func_72805_g(n, n2 + ((BlockFluidBase)this).densityDir, n3);
            if (block == this && n4 != 0) {
                world.func_147465_d(n, n2 + ((BlockFluidBase)this).densityDir, n3, (Block)this, 0, 3);
                world.func_147468_f(n, n2, n3);
                return;
            }
        }
        super.func_149674_a(world, n, n2, n3, random);
    }

    protected void checkForInteraction(World world, int n, int n2, int n3) {
        if (world.func_147439_a(n, n2, n3) != this) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        for (int i = 0; i < 6; ++i) {
            n4 = n + BlockHelper.SIDE_COORD_MOD[i][0];
            n5 = n2 + BlockHelper.SIDE_COORD_MOD[i][1];
            n6 = n3 + BlockHelper.SIDE_COORD_MOD[i][2];
            this.interactWithBlock(world, n4, n5, n6);
        }
        this.interactWithBlock(world, n - 1, n2, n3 - 1);
        this.interactWithBlock(world, n - 1, n2, n3 + 1);
        this.interactWithBlock(world, n + 1, n2, n3 - 1);
        this.interactWithBlock(world, n + 1, n2, n3 + 1);
    }

    protected void interactWithBlock(World world, int n, int n2, int n3) {
        Block block = world.func_147439_a(n, n2, n3);
        if (block == Blocks.field_150350_a || block == this) {
            return;
        }
        int n4 = world.func_72805_g(n, n2, n3);
        if (this.hasInteraction(block, n4)) {
            BlockWrapper blockWrapper = this.getInteraction(block, n4);
            world.func_147465_d(n, n2, n3, blockWrapper.block, blockWrapper.metadata, 3);
        } else if (world.isSideSolid(n, n2, n3, ForgeDirection.UP) && world.func_147437_c(n, n2 + 1, n3)) {
            world.func_147465_d(n, n2 + 1, n3, Blocks.field_150431_aC, 0, 3);
        }
    }

    protected void triggerInteractionEffects(World world, int n, int n2, int n3) {
    }
}

