/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.network;

import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.storage.BackpackDefinition;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketBagsSync
extends ForestryPacket
implements IForestryPacketClient {
    private NBTTagCompound packet;

    @Override
    protected void writeData(DataOutputStreamForestry data) {
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.packet = data.readNBTTagCompound();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) {
        for (String key : this.packet.func_150296_c()) {
            IBackpackDefinition h = BackpackManager.definitions.get(key);
            if (!(h instanceof BackpackDefinition)) continue;
            BackpackDefinition handler = (BackpackDefinition)h;
            handler.getValidOreIds().clear();
            handler.getValidItemStacks().clear();
            handler.getValidItemClasses().clear();
            handler.getValidBlockClasses().clear();
            NBTTagCompound backPackFilters = this.packet.func_74775_l(key);
            for (int ore : backPackFilters.func_74759_k("validOreIds")) {
                handler.getValidOreIds().add(ore);
            }
            NBTTagList validItemStacks = backPackFilters.func_150295_c("validItemStacks", 8);
            for (int index = 0; index < validItemStacks.func_74745_c(); ++index) {
                handler.getValidItemStacks().add(validItemStacks.func_150307_f(index));
            }
            try {
                NBTTagList validItemClasses = backPackFilters.func_150295_c("validItemClasses", 8);
                for (int index = 0; index < validItemClasses.func_74745_c(); ++index) {
                    handler.getValidItemClasses().add(Class.forName(validItemClasses.func_150307_f(index)));
                }
                NBTTagList validBlockClasses = backPackFilters.func_150295_c("validBlockClasses", 8);
                for (int index = 0; index < validBlockClasses.func_74745_c(); ++index) {
                    handler.getValidBlockClasses().add(Class.forName(validBlockClasses.func_150307_f(index)));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.BAGS_ITEMS_SYNC;
    }
}

