/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import net.minecraft.world.ColorizerFoliage;
import reifnsk.minimap.IChunkData;

public enum BlockType {
    NORMAL,
    AIR,
    GRASS{

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.smoothGrassColors[i];
        }
    }
    ,
    FOLIAGE{

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.smoothFoliageColors[i];
        }
    }
    ,
    FOLIAGE_PINE{

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.foliageColorPine;
        }
    }
    ,
    FOLIAGE_BIRCH{

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.foliageColorBirch;
        }
    }
    ,
    WATER(true){

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.smoothWaterColors[i];
        }
    }
    ,
    ICE(true),
    GLASS,
    SIMPLE_GRASS{

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.grassColors[i];
        }
    }
    ,
    SIMPLE_FOLIAGE{

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.foliageColors[i];
        }
    }
    ,
    SIMPLE_WATER{

        @Override
        protected int getColorMultiplayer(Data data, int i) {
            return data.waterColors[i];
        }
    }
    ,
    END_PORTAL_FRAME,
    END_PORTAL_FRAME_EYE,
    EX_WATER(true);

    protected final boolean water;

    private BlockType() {
        this.water = false;
    }

    private BlockType(boolean water) {
        this.water = water;
    }

    protected int getColorMultiplayer(Data data, int i) {
        return 0xFFFFFF;
    }

    protected static final class Data {
        protected final int[] foliageColors;
        protected final int[] grassColors;
        protected final int[] waterColors;
        protected final int[] smoothFoliageColors;
        protected final int[] smoothGrassColors;
        protected final int[] smoothWaterColors;
        protected final int foliageColorBirch = ColorizerFoliage.func_77469_b();
        protected final int foliageColorPine = ColorizerFoliage.func_77466_a();

        public Data(IChunkData chunkData) {
            this.foliageColors = chunkData.getFoliageColors();
            this.grassColors = chunkData.getGrassColors();
            this.waterColors = chunkData.getWaterColors();
            this.smoothFoliageColors = chunkData.getSmoothFoliageColors();
            this.smoothGrassColors = chunkData.getSmoothGrassColors();
            this.smoothWaterColors = chunkData.getSmoothWaterColors();
        }
    }
}

