/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import reifnsk.minimap.ICustomChunk;
import reifnsk.minimap.ReiMinimap;

public class ChunkData {
    private static final int CHUNK_RELOAD_INTERVAL = 60;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int CHUNK_ARRAY_SIZE = 1024;
    private static final int CHUNK_SHIFT = 5;
    public final int xPosition;
    public final int zPosition;
    private Chunk chunk;
    private boolean chunkFileExist = true;
    private boolean chunkModified;
    private int chunkUpdateCount;
    private boolean chunkUpdate;
    private int lastRenderCount = reimm.getUpdateCount();
    private int lastAccessCount = reimm.getUpdateCount();
    private int lastUpdateCount = reimm.getUpdateCount();
    private int chunkReloadCount = reimm.getUpdateCount();
    protected int[] foliageColors = new int[256];
    protected int[] grassColors = new int[256];
    protected int[] waterColors = new int[256];
    protected int[] smoothFoliageColors = new int[256];
    protected int[] smoothGrassColors = new int[256];
    protected int[] smoothWaterColors = new int[256];
    protected float[] heightValues = new float[256];
    protected BiomeGenBase[] biomes = PLAINS;
    protected boolean enviromnentColorUpdateReq;
    protected boolean slime;
    private static BiomeGenBase[] PLAINS = new BiomeGenBase[256];
    private static final ReiMinimap reimm;
    private static final ChunkData[] cache;
    private static Minecraft minecraft;
    private static World world;
    private static WorldProvider worldProvider;
    private static WorldChunkManager worldChunkManager;
    private static IChunkProvider chunkProvider;
    private static IChunkLoader chunkLoader;
    private static long seed;

    private ChunkData(int cx, int cz) {
        this.xPosition = cx;
        this.zPosition = cz;
        this.slime = seed != 0L && new Random(seed + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ 0x3AD8025FL).nextInt(10) == 0;
    }

    public final boolean isAtLocation(int cx, int cz) {
        return cx == this.xPosition && cz == this.zPosition;
    }

    protected boolean updateChunk(boolean chunkLoadFromFile) {
        boolean result = false;
        int currentCount = reimm.getUpdateCount();
        IChunkLoader loader = chunkLoadFromFile ? chunkLoader : null;
        Chunk prevChunk = this.chunk;
        if (this.chunkReloadCount - currentCount <= 0) {
            this.chunkReloadCount = currentCount + 60;
            if (chunkProvider.func_73149_a(this.xPosition, this.zPosition)) {
                this.chunk = chunkProvider.func_73154_d(this.xPosition, this.zPosition);
                this.chunkFileExist = true;
            } else if (this.chunk == null && loader != null && this.chunkFileExist) {
                try {
                    this.chunk = loader.func_75815_a(world, this.xPosition, this.zPosition);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.chunkFileExist = this.chunk != null;
                result = true;
            } else {
                this.chunkReloadCount = currentCount + 7;
            }
        }
        if (this.chunk == null) {
            this.chunk = prevChunk;
        }
        if (this.chunk != prevChunk || this.enviromnentColorUpdateReq) {
            this.updateEnvironmentColor();
            this.chunkUpdate = true;
        }
        if (this.chunk != null) {
            if (this.chunk instanceof ICustomChunk) {
                ICustomChunk icc = (ICustomChunk)this.chunk;
                if (this.chunkUpdateCount != icc.updateCount()) {
                    this.chunkUpdateCount = icc.updateCount();
                    this.chunkUpdate = true;
                }
            } else if (this.chunkModified != this.chunk.field_76643_l || this.chunkModified && currentCount - this.lastUpdateCount >= 10) {
                this.chunkModified = this.chunk.field_76643_l;
                this.chunkUpdate = true;
            }
        }
        return result;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    private void updateEnvironmentColor() {
        if (this.chunk != null) {
            byte[] biomesArray = this.chunk.func_76605_m();
            this.biomes = Arrays.copyOf(this.biomes, 256);
            for (int i = 0; i < 256; ++i) {
                int id = biomesArray[i] & 0xFF;
                if (id == 255) {
                    this.enviromnentColorUpdateReq = true;
                    return;
                }
                BiomeGenBase biome = BiomeGenBase.func_150565_n()[id];
                this.biomes[i] = biome == null ? BiomeGenBase.field_76772_c : biome;
            }
        }
        this.enviromnentColorUpdateReq = false;
        for (int i = 0; i < 256; ++i) {
            BiomeGenBase biome = this.biomes[i];
            this.waterColors[i] = biome.field_76759_H;
            int x = this.xPosition * 16 + (i & 0xF);
            int z = this.zPosition * 16 + (i >> 4);
            this.foliageColors[i] = biome.func_150571_c(x, 64, z);
            this.grassColors[i] = biome.func_150558_b(x, 64, z);
        }
        for (int z = -1; z <= 16; ++z) {
            for (int x = -1; x <= 16; ++x) {
                this.calcSmoothColor(x, z);
            }
        }
    }

    private void calcSmoothColor(int x, int z) {
        int setPtr = x & 0xF | (z & 0xF) << 4;
        ChunkData target = ChunkData.getChunkData((x += this.xPosition << 4) >> 4, (z += this.zPosition << 4) >> 4);
        if (target != null) {
            int count = 0;
            int fr = 0;
            int fg = 0;
            int fb = 0;
            int gr = 0;
            int gg = 0;
            int gb = 0;
            int wr = 0;
            int wg = 0;
            int wb = 0;
            for (int bz = z - 1; bz <= z + 1; ++bz) {
                for (int bx = x - 1; bx <= x + 1; ++bx) {
                    ChunkData cd = ChunkData.getChunkData(bx >> 4, bz >> 4);
                    if (cd == null || cd.biomes == null) continue;
                    int p = bx & 0xF | (bz & 0xF) << 4;
                    int foliageColor = cd.foliageColors[p];
                    fr += foliageColor >> 16 & 0xFF;
                    fg += foliageColor >> 8 & 0xFF;
                    fb += foliageColor & 0xFF;
                    int grassColor = cd.grassColors[p];
                    gr += grassColor >> 16 & 0xFF;
                    gg += grassColor >> 8 & 0xFF;
                    gb += grassColor & 0xFF;
                    int waterColor = cd.waterColors[p];
                    wr += waterColor >> 16 & 0xFF;
                    wg += waterColor >> 8 & 0xFF;
                    wb += waterColor & 0xFF;
                    ++count;
                }
            }
            target.smoothFoliageColors[setPtr] = (fr / count & 0xFF) << 16 | (fg / count & 0xFF) << 8 | fb / count & 0xFF;
            target.smoothGrassColors[setPtr] = (gr / count & 0xFF) << 16 | (gg / count & 0xFF) << 8 | gb / count & 0xFF;
            target.smoothWaterColors[setPtr] = (wr / count & 0xFF) << 16 | (wg / count & 0xFF) << 8 | wb / count & 0xFF;
        }
    }

    protected static void init() {
        try {
            WorldServer[] ws;
            Arrays.fill(cache, null);
            minecraft = reimm.getMinecraft();
            world = reimm.getWorld();
            seed = 0L;
            if (Minecraft.func_71410_x().func_71401_C() != null && (ws = Minecraft.func_71410_x().func_71401_C().field_71305_c) != null && ws.length >= 1) {
                seed = ws[0].func_72905_C();
            }
            worldProvider = ChunkData.world.field_73011_w;
            worldChunkManager = world.func_72959_q();
            chunkProvider = world.func_72863_F();
            chunkLoader = ChunkData.getChunkLoader(chunkProvider);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IChunkLoader getChunkLoader(IChunkProvider chunkProvider) {
        try {
            for (Class<?> c = chunkProvider.getClass(); c != null; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    if (f.getType() != IChunkLoader.class) continue;
                    f.setAccessible(true);
                    return (IChunkLoader)f.get(chunkProvider);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkData getChunkData(int cx, int cz) {
        int ptr = ChunkData.chunkPointer(cx, cz);
        ChunkData data = cache[ptr];
        return data != null && data.isAtLocation(cx, cz) ? data : null;
    }

    protected static ChunkData createChunkData(int cx, int cz) {
        int ptr = ChunkData.chunkPointer(cx, cz);
        ChunkData data = cache[ptr];
        return data != null && data.isAtLocation(cx, cz) ? data : new ChunkData(cx, cz);
    }

    private static int chunkPointer(int cx, int cz) {
        return (cz & 0x1F) << 5 | cx & 0x1F;
    }

    protected void setHeightValue(int x, int z, float value) {
        this.heightValues[z << 4 | x] = value;
    }

    protected float getHeightValue(int x, int z) {
        return this.heightValues[z << 4 | x];
    }

    protected static void updateTexture() {
        for (ChunkData cd : cache) {
            if (cd == null) continue;
            cd.enviromnentColorUpdateReq = true;
        }
    }

    static {
        Arrays.fill(PLAINS, BiomeGenBase.field_76772_c);
        reimm = ReiMinimap.instance;
        cache = new ChunkData[1024];
    }
}

