/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Keyboard;
import reifnsk.minimap.GuiScreenInterface;
import reifnsk.minimap.GuiScrollbar;
import reifnsk.minimap.GuiSimpleButton;
import reifnsk.minimap.GuiTextField;
import reifnsk.minimap.GuiWaypointScreen;
import reifnsk.minimap.ReiMinimap;
import reifnsk.minimap.Waypoint;

public class GuiWaypointEditorScreen
extends GuiScreen
implements GuiScreenInterface {
    private GuiWaypointScreen parrent;
    private Waypoint waypoint;
    private Waypoint waypointBackup;
    private GuiTextField nameTextField;
    private GuiTextField xCoordTextField;
    private GuiTextField yCoordTextField;
    private GuiTextField zCoordTextField;
    private GuiScrollbar[] rgb;
    private GuiSimpleButton okButton;
    private GuiSimpleButton cancelButton;

    public GuiWaypointEditorScreen(Minecraft mc, Waypoint waypoint) {
        int y;
        int z;
        int x;
        String name;
        this.waypoint = waypoint;
        Waypoint waypoint2 = this.waypointBackup = waypoint == null ? null : new Waypoint(waypoint);
        if (waypoint == null) {
            name = "";
            EntityClientPlayerMP player = mc.field_71439_g;
            x = MathHelper.func_76128_c((double)player.field_70165_t);
            z = MathHelper.func_76128_c((double)player.field_70161_v);
            y = MathHelper.func_76128_c((double)player.field_70163_u) - 1;
        } else {
            name = waypoint.name;
            x = waypoint.x;
            z = waypoint.z;
            y = waypoint.y;
        }
        this.nameTextField = new GuiTextField(name);
        this.nameTextField.setInputType(0);
        this.nameTextField.active();
        this.xCoordTextField = new GuiTextField(Integer.toString(x));
        this.xCoordTextField.setInputType(1);
        this.zCoordTextField = new GuiTextField(Integer.toString(z));
        this.zCoordTextField.setInputType(1);
        this.yCoordTextField = new GuiTextField(Integer.toString(y));
        this.yCoordTextField.setInputType(2);
        this.nameTextField.setNext(this.xCoordTextField);
        this.nameTextField.setPrev(this.zCoordTextField);
        this.xCoordTextField.setNext(this.zCoordTextField);
        this.xCoordTextField.setPrev(this.nameTextField);
        this.zCoordTextField.setNext(this.yCoordTextField);
        this.zCoordTextField.setPrev(this.xCoordTextField);
        this.yCoordTextField.setNext(this.nameTextField);
        this.yCoordTextField.setPrev(this.zCoordTextField);
        this.rgb = new GuiScrollbar[3];
        for (int i = 0; i < 3; ++i) {
            GuiScrollbar gs = new GuiScrollbar(0, 0, 0, 118, 10);
            gs.setMinimum(0.0f);
            gs.setMaximum(255.0f);
            gs.setVisibleAmount(0.0f);
            gs.setBlockIncrement(10.0f);
            gs.orientation = 1;
            this.rgb[i] = gs;
        }
        this.rgb[0].setValue((float)(waypoint == null ? Math.random() : (double)waypoint.red) * 255.0f);
        this.rgb[1].setValue((float)(waypoint == null ? Math.random() : (double)waypoint.green) * 255.0f);
        this.rgb[2].setValue((float)(waypoint == null ? Math.random() : (double)waypoint.blue) * 255.0f);
    }

    public GuiWaypointEditorScreen(GuiWaypointScreen parrent, Waypoint waypoint) {
        this(parrent.getMinecraft(), waypoint);
        this.parrent = parrent;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        for (int i = 0; i < 3; ++i) {
            this.rgb[i].field_146128_h = this.field_146294_l - 150 >> 1;
            this.rgb[i].field_146129_i = this.field_146295_m / 2 + 20 + i * 10;
            this.field_146292_n.add(this.rgb[i]);
        }
        this.nameTextField.setBounds(this.field_146294_l - 150 >> 1, this.field_146295_m / 2 - 40, 150, 9);
        this.xCoordTextField.setBounds(this.field_146294_l - 10 >> 1, this.field_146295_m / 2 - 20, 80, 9);
        this.zCoordTextField.setBounds(this.field_146294_l - 10 >> 1, this.field_146295_m / 2 - 10, 80, 9);
        this.yCoordTextField.setBounds(this.field_146294_l - 10 >> 1, this.field_146295_m / 2, 80, 9);
        this.field_146292_n.add(this.nameTextField);
        this.field_146292_n.add(this.xCoordTextField);
        this.field_146292_n.add(this.zCoordTextField);
        this.field_146292_n.add(this.yCoordTextField);
        this.okButton = new GuiSimpleButton(0, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 58, 60, 14, "OK");
        this.cancelButton = new GuiSimpleButton(1, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 58, 60, 14, "Cancel");
        this.field_146292_n.add(this.okButton);
        this.field_146292_n.add(this.cancelButton);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public void func_73863_a(int mx, int my, float f) {
        int x = MathHelper.func_76128_c((double)this.field_146297_k.field_71439_g.field_70165_t);
        int z = MathHelper.func_76128_c((double)this.field_146297_k.field_71439_g.field_70161_v);
        int y = MathHelper.func_76128_c((double)this.field_146297_k.field_71439_g.field_70163_u);
        this.xCoordTextField.setNorm(x);
        this.zCoordTextField.setNorm(z);
        this.yCoordTextField.setNorm(y);
        String title = "Waypoint Edit";
        int titleWidth = this.field_146289_q.func_78256_a(title);
        int titleLeft = this.field_146294_l - titleWidth >> 1;
        int titleRight = this.field_146294_l + titleWidth >> 1;
        GuiWaypointEditorScreen.func_73734_a((int)(titleLeft - 2), (int)(this.field_146295_m / 2 - 71), (int)(titleRight + 2), (int)(this.field_146295_m / 2 - 57), (int)-1610612736);
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, this.field_146295_m / 2 - 70 + 2, -1);
        GuiWaypointEditorScreen.func_73734_a((int)((this.field_146294_l - 150) / 2 - 2), (int)(this.field_146295_m / 2 - 50), (int)((this.field_146294_l + 150) / 2 + 2), (int)(this.field_146295_m / 2 + 52), (int)-1610612736);
        String temp = Integer.toString(x).equals(this.xCoordTextField.field_146126_j) ? "X: (Current)" : "X:";
        this.func_73731_b(this.field_146289_q, temp, (this.field_146294_l - 150) / 2 + 1, this.field_146295_m / 2 - 19, -4144960);
        temp = Integer.toString(z).equals(this.zCoordTextField.field_146126_j) ? "Z: (Current)" : "Z:";
        this.func_73731_b(this.field_146289_q, temp, (this.field_146294_l - 150) / 2 + 1, this.field_146295_m / 2 - 9, -4144960);
        temp = Integer.toString(y).equals(this.yCoordTextField.field_146126_j) ? "Y: (Current)" : "Y:";
        this.func_73731_b(this.field_146289_q, temp, (this.field_146294_l - 150) / 2 + 1, this.field_146295_m / 2 + 1, -4144960);
        this.func_73732_a(this.field_146289_q, "Waypoint Name", this.field_146294_l >> 1, this.field_146295_m / 2 - 49, -4144960);
        this.func_73732_a(this.field_146289_q, "Coordinate", this.field_146294_l >> 1, this.field_146295_m / 2 - 29, -4144960);
        this.func_73732_a(this.field_146289_q, "Color", this.field_146294_l >> 1, this.field_146295_m / 2 + 11, -4144960);
        if (this.waypoint != null) {
            this.waypoint.red = this.rgb[0].getValue() / 255.0f;
            this.waypoint.green = this.rgb[1].getValue() / 255.0f;
            this.waypoint.blue = this.rgb[2].getValue() / 255.0f;
        }
        int r = (int)this.rgb[0].getValue() & 0xFF;
        int g = (int)this.rgb[1].getValue() & 0xFF;
        int b = (int)this.rgb[2].getValue() & 0xFF;
        int color = 0xFF000000 | r << 16 | g << 8 | b;
        this.func_73732_a(this.field_146289_q, String.format("R: %03d", r), this.field_146294_l / 2 - 15, this.field_146295_m / 2 + 21, -2139062144);
        this.func_73732_a(this.field_146289_q, String.format("G: %03d", g), this.field_146294_l / 2 - 15, this.field_146295_m / 2 + 31, -2139062144);
        this.func_73732_a(this.field_146289_q, String.format("B: %03d", b), this.field_146294_l / 2 - 15, this.field_146295_m / 2 + 41, -2139062144);
        GuiWaypointEditorScreen.func_73734_a((int)(this.field_146294_l + 90 >> 1), (int)(this.field_146295_m / 2 + 20), (int)(this.field_146294_l + 150 >> 1), (int)(this.field_146295_m / 2 + 50), (int)color);
        super.func_73863_a(mx, my, f);
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1) {
            this.cancel();
        } else if (i == 28 && GuiTextField.getActive() == this.zCoordTextField) {
            this.zCoordTextField.norm();
            this.accept();
        } else {
            GuiTextField.keyType(this.field_146297_k, c, i);
        }
    }

    private void cancel() {
        if (this.waypoint != null) {
            this.waypoint.set(this.waypointBackup);
        }
        this.field_146297_k.func_147108_a((GuiScreen)this.parrent);
    }

    private void accept() {
        if (this.waypoint != null) {
            this.waypoint.name = this.nameTextField.field_146126_j;
            this.waypoint.x = GuiWaypointEditorScreen.parseInt(this.xCoordTextField.field_146126_j);
            this.waypoint.z = GuiWaypointEditorScreen.parseInt(this.zCoordTextField.field_146126_j);
            this.waypoint.y = GuiWaypointEditorScreen.parseInt(this.yCoordTextField.field_146126_j);
            this.waypoint.red = this.rgb[0].getValue() / 255.0f;
            this.waypoint.green = this.rgb[1].getValue() / 255.0f;
            this.waypoint.blue = this.rgb[2].getValue() / 255.0f;
            this.parrent.updateWaypoint(this.waypoint);
        } else {
            String name = this.nameTextField.field_146126_j;
            int x = GuiWaypointEditorScreen.parseInt(this.xCoordTextField.field_146126_j);
            int z = GuiWaypointEditorScreen.parseInt(this.zCoordTextField.field_146126_j);
            int y = GuiWaypointEditorScreen.parseInt(this.yCoordTextField.field_146126_j);
            float r = this.rgb[0].getValue() / 255.0f;
            float g = this.rgb[1].getValue() / 255.0f;
            float b = this.rgb[2].getValue() / 255.0f;
            this.waypoint = new Waypoint(name, x, y, z, true, r, g, b);
            if (this.parrent == null) {
                ReiMinimap rmm = ReiMinimap.instance;
                List<Waypoint> wayPts = rmm.getWaypoints();
                wayPts.add(this.waypoint);
                rmm.saveWaypoints();
            } else {
                this.parrent.addWaypoint(this.waypoint);
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this.parrent);
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.okButton) {
            this.accept();
        } else if (guibutton == this.cancelButton) {
            this.cancel();
        }
    }
}

