/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.io.File;
import java.io.PrintWriter;
import java.util.Scanner;
import org.lwjgl.input.Keyboard;
import reifnsk.minimap.ReiMinimap;

public enum KeyInput {
    MENU_KEY(50),
    TOGGLE_ENABLE(0),
    TOGGLE_RENDER_TYPE(0),
    TOGGLE_ZOOM(44),
    TOGGLE_LARGE_MAP(45),
    TOGGLE_LARGE_MAP_LABEL(0),
    TOGGLE_WAYPOINTS_VISIBLE(0),
    TOGGLE_WAYPOINTS_MARKER(0),
    TOGGLE_WAYPOINTS_DIMENSION(0),
    TOGGLE_ENTITIES_RADAR(0),
    SET_WAYPOINT(46),
    WAYPOINT_LIST(0),
    ZOOM_IN(209),
    ZOOM_OUT(201);

    private static File configFile;
    private final int defaultKeyIndex;
    private String label;
    private int keyIndex;
    private boolean keyDown;
    private boolean oldKeyDown;

    private KeyInput(int keyIndex) {
        this.defaultKeyIndex = keyIndex;
        this.keyIndex = keyIndex;
        this.label = ReiMinimap.capitalize(this.name());
    }

    private KeyInput(String label, int keyIndex) {
        this.label = label;
        this.defaultKeyIndex = keyIndex;
        this.keyIndex = keyIndex;
    }

    public void setKey(int keyIndex) {
        if (keyIndex == 1) {
            keyIndex = 0;
        }
        if (keyIndex != 0 || this != MENU_KEY) {
            if (keyIndex != 0) {
                for (KeyInput temp : KeyInput.values()) {
                    if (temp.keyIndex != keyIndex) continue;
                    if (temp == MENU_KEY && this.keyIndex == 0) {
                        return;
                    }
                    temp.keyIndex = this.keyIndex;
                    temp.keyDown = false;
                    temp.oldKeyDown = false;
                    break;
                }
            }
            this.keyIndex = keyIndex;
            this.keyDown = false;
            this.oldKeyDown = false;
        }
    }

    public int getKey() {
        return this.keyIndex;
    }

    public String label() {
        return this.label;
    }

    public String getKeyName() {
        String keyName = Keyboard.getKeyName((int)this.keyIndex);
        return keyName == null ? String.format("#%02X", this.keyIndex) : ReiMinimap.capitalize(keyName);
    }

    public void setKey(String keyName) {
        int key = Keyboard.getKeyIndex((String)keyName);
        if (keyName.startsWith("#")) {
            try {
                key = Integer.parseInt(keyName.substring(1), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setKey(key);
    }

    public boolean isKeyDown() {
        return this.keyDown;
    }

    public boolean isKeyPush() {
        return this.keyDown && !this.oldKeyDown;
    }

    public boolean isKeyPushUp() {
        return !this.keyDown && this.oldKeyDown;
    }

    public static void update() {
        for (KeyInput input : KeyInput.values()) {
            input.oldKeyDown = input.keyDown;
            input.keyDown = input.keyIndex != 0 && Keyboard.isKeyDown((int)input.keyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKeyConfig() {
        boolean flag;
        PrintWriter out = null;
        try {
            out = new PrintWriter(configFile);
            for (KeyInput key : KeyInput.values()) {
                out.println(key.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadKeyConfig() {
        Scanner in = null;
        try {
            in = new Scanner(configFile);
            while (in.hasNextLine()) {
                try {
                    String[] strs = in.nextLine().split(":");
                    KeyInput.valueOf(ReiMinimap.toUpperCase(strs[0].trim())).setKey(ReiMinimap.toUpperCase(strs[1].trim()));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void setDefault() {
        this.keyIndex = this.defaultKeyIndex;
    }

    public boolean isDefault() {
        return this.keyIndex == this.defaultKeyIndex;
    }

    public String toString() {
        return ReiMinimap.capitalize(this.name()) + ": " + this.getKeyName();
    }

    static {
        configFile = new File(ReiMinimap.optionsDir, "keybinds.cfg");
        KeyInput.loadKeyConfig();
        KeyInput.saveKeyConfig();
    }
}

