/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.blocks;

import com.google.common.base.Preconditions;
import com.piepenguin.rfwindmill.blocks.ItemBlockWindmillBlock;
import com.piepenguin.rfwindmill.blocks.ModBlocks;
import com.piepenguin.rfwindmill.blocks.RotorBlock;
import com.piepenguin.rfwindmill.items.ModItems;
import com.piepenguin.rfwindmill.items.RFWItem;
import com.piepenguin.rfwindmill.lib.Lang;
import com.piepenguin.rfwindmill.lib.ModConfiguration;
import com.piepenguin.rfwindmill.lib.Util;
import com.piepenguin.rfwindmill.tileentities.TileEntityRotorBlock;
import com.piepenguin.rfwindmill.tileentities.TileEntityWindmillBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WindmillBlock
extends Block
implements ITileEntityProvider {
    protected final float[] efficiency;
    protected final int[] maximumEnergyTransfer;
    protected final int[] capacity;
    private static final int maxMeta = 4;
    private String name;
    private IIcon[] icons;

    public WindmillBlock(String pName, float[] pEfficiency, int[] pCapacity) {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149672_a(Block.field_149777_j);
        this.efficiency = pEfficiency;
        this.maximumEnergyTransfer = new int[this.efficiency.length];
        Arrays.fill(this.maximumEnergyTransfer, (int)(ModConfiguration.getWindGenerationBase() * (float)ModConfiguration.getWindmillEnergyTransferMultiplier()));
        this.capacity = pCapacity;
        this.name = pName;
        this.func_149663_c("rfwindmill_" + this.name);
        this.func_149647_a(CreativeTabs.field_78030_b);
        GameRegistry.registerBlock((Block)this, ItemBlockWindmillBlock.class, (String)this.name);
        this.icons = new IIcon[4];
    }

    public void func_149651_a(IIconRegister pIconRegister) {
        for (int i = 0; i < 4; ++i) {
            this.icons[i] = pIconRegister.func_94245_a("rfwindmill:" + this.name + (i + 1) + "Side");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int pSide, int pMeta) {
        return this.icons[pMeta];
    }

    public TileEntity func_149915_a(World pWorld, int pMeta) {
        return new TileEntityWindmillBlock(this.efficiency[pMeta], this.maximumEnergyTransfer[pMeta], this.capacity[pMeta]);
    }

    public boolean hasTileEntity(int pMetadata) {
        return true;
    }

    public int func_149692_a(int pMeta) {
        return pMeta;
    }

    public void func_149666_a(Item pItem, CreativeTabs pCreativeTabs, List list) {
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack(pItem, 1, i));
        }
    }

    public void func_149689_a(World pWorld, int pX, int pY, int pZ, EntityLivingBase pEntity, ItemStack pItemStack) {
        if (pItemStack.field_77990_d != null) {
            TileEntityWindmillBlock entity = (TileEntityWindmillBlock)pWorld.func_147438_o(pX, pY, pZ);
            entity.setEnergyStored(pItemStack.field_77990_d.func_74762_e("ESEnergy"));
        }
        super.func_149689_a(pWorld, pX, pY, pZ, pEntity, pItemStack);
    }

    public boolean func_149727_a(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer, int pSide, float pDx, float pDy, float pDz) {
        if (!pWorld.field_72995_K) {
            if (pPlayer.func_70093_af()) {
                if (Util.hasWrench(pPlayer, pX, pY, pZ)) {
                    this.dismantle(pWorld, pX, pY, pZ);
                    return true;
                }
                this.printChatInfo(pWorld, pX, pY, pZ, pPlayer);
                return true;
            }
            ItemStack equippedItem = pPlayer.func_71045_bC();
            if (equippedItem != null && (equippedItem.func_77973_b() == ModItems.rotor1 || equippedItem.func_77973_b() == ModItems.rotor2 || equippedItem.func_77973_b() == ModItems.rotor3 || equippedItem.func_77973_b() == ModItems.rotor4)) {
                ForgeDirection fDirection = ForgeDirection.getOrientation((int)pSide);
                if (fDirection == ForgeDirection.DOWN || fDirection == ForgeDirection.UP) {
                    return false;
                }
                int dx = pX + fDirection.offsetX;
                int dy = pY + fDirection.offsetY;
                int dz = pZ + fDirection.offsetZ;
                TileEntityWindmillBlock entity = (TileEntityWindmillBlock)pWorld.func_147438_o(pX, pY, pZ);
                if (RotorBlock.canPlace(pWorld, dx, dy, dz, pPlayer, fDirection) && !entity.hasRotor()) {
                    RFWItem equippedRotor = (RFWItem)equippedItem.func_77973_b();
                    pWorld.func_147449_b(dx, dy, dz, ModBlocks.rotorBlock1);
                    pWorld.func_72921_c(dx, dy, dz, Util.directionToInt(fDirection), 2);
                    TileEntityRotorBlock rotorEntity = (TileEntityRotorBlock)pWorld.func_147438_o(dx, dy, dz);
                    int rotorType = -1;
                    if (equippedRotor == ModItems.rotor1) {
                        rotorType = 0;
                    } else if (equippedRotor == ModItems.rotor2) {
                        rotorType = 1;
                    } else if (equippedRotor == ModItems.rotor3) {
                        rotorType = 2;
                    } else if (equippedRotor == ModItems.rotor4) {
                        rotorType = 3;
                    }
                    rotorEntity.setType(rotorType);
                    entity.setRotor(rotorType, fDirection);
                    if (equippedItem.field_77994_a > 1) {
                        --equippedItem.field_77994_a;
                    } else {
                        pPlayer.func_71028_bD();
                    }
                }
            }
        }
        return false;
    }

    public void func_149681_a(World pWorld, int pX, int pY, int pZ, int pSide, EntityPlayer pPlayer) {
        if (!pWorld.field_72995_K) {
            this.dismantle(pWorld, pX, pY, pZ);
        }
    }

    private void dismantle(World pWorld, int pX, int pY, int pZ) {
        TileEntityWindmillBlock entity = (TileEntityWindmillBlock)pWorld.func_147438_o(pX, pY, pZ);
        Preconditions.checkNotNull((Object)entity);
        if (entity.hasRotor()) {
            ForgeDirection dir = entity.getRotorDir();
            RotorBlock rotor = (RotorBlock)pWorld.func_147439_a(pX + dir.offsetX, pY + dir.offsetY, pZ + dir.offsetZ);
            rotor.dismantle(pWorld, pX + dir.offsetX, pY + dir.offsetY, pZ + dir.offsetZ);
        }
        ItemStack itemStack = new ItemStack((Block)this, 1, entity.func_145832_p());
        int energy = entity.getEnergyStored();
        if (energy > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.func_77978_p().func_74768_a("ESEnergy", energy);
        }
        pWorld.func_147468_f(pX, pY, pZ);
        EntityItem entityItem = new EntityItem(pWorld, (double)pX + 0.5, (double)pY + 0.5, (double)pZ + 0.5, itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        pWorld.func_72838_d((Entity)entityItem);
    }

    private void printChatInfo(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer) {
        TileEntityWindmillBlock entity = (TileEntityWindmillBlock)pWorld.func_147438_o(pX, pY, pZ);
        String msg = String.format("%s: %d/%d RF %s: %.2f RF/t", Lang.localise("energy.stored"), entity.getEnergyStored(), entity.getMaxEnergyStored(), Lang.localise("energy.generating"), Float.valueOf(entity.getCurrentEnergyGeneration()));
        pPlayer.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }
}

