/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.lib;

import cofh.api.energy.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyStorage
implements IEnergyStorage {
    private float energy;
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    public static final String NBT_ENERGY = "ESEnergy";
    public static final String NBT_CAPACITY = "ESCapacity";
    public static final String NBT_MAX_RECEIVE = "ESMaxReceive";
    public static final String NBT_MAX_EXTRACT = "ESMaxExtract";

    public EnergyStorage() {
        this(0, 0, 0);
    }

    public EnergyStorage(int pCapacity, int pMaxReceive, int pMaxExtract) {
        this.capacity = pCapacity;
        this.maxReceive = pMaxReceive;
        this.maxExtract = pMaxExtract;
    }

    public EnergyStorage(int pCapacity, int pMaxTransfer) {
        this(pCapacity, pMaxTransfer, pMaxTransfer);
    }

    public EnergyStorage(int pCapacity) {
        this(pCapacity, pCapacity, pCapacity);
    }

    public void readFromNBT(NBTTagCompound pNbt) {
        this.setMaxEnergyStored(pNbt.func_74762_e(NBT_CAPACITY));
        this.setMaxReceive(pNbt.func_74762_e(NBT_MAX_RECEIVE));
        this.setMaxExtract(pNbt.func_74762_e(NBT_MAX_EXTRACT));
        this.setEnergyStored(pNbt.func_74762_e(NBT_ENERGY));
    }

    public void writeToNBT(NBTTagCompound pNbt) {
        if (this.energy < 0.0f) {
            this.energy = 0.0f;
        }
        pNbt.func_74768_a(NBT_CAPACITY, this.getMaxEnergyStored());
        pNbt.func_74768_a(NBT_MAX_RECEIVE, this.getMaxReceive());
        pNbt.func_74768_a(NBT_MAX_EXTRACT, this.getMaxExtract());
        pNbt.func_74768_a(NBT_ENERGY, this.getEnergyStored());
    }

    @Override
    public int receiveEnergy(int pMaxReceive, boolean pSimulate) {
        int energyReceived = Math.min(this.capacity - (int)this.energy, Math.min(this.maxReceive, pMaxReceive));
        if (!pSimulate) {
            this.energy += (float)energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(int pMaxExtract, boolean pSimulate) {
        int energyExtracted = Math.min((int)this.energy, Math.min(this.maxExtract, pMaxExtract));
        if (!pSimulate) {
            this.energy -= (float)energyExtracted;
        }
        return energyExtracted;
    }

    public void modifyEnergyStored(float pEnergy) {
        this.energy += pEnergy;
        if (this.energy > (float)this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0.0f) {
            this.energy = 0.0f;
        }
    }

    @Override
    public int getEnergyStored() {
        return (int)this.energy;
    }

    public void setEnergyStored(int pEnergy) {
        this.energy = pEnergy;
        if (this.energy > (float)this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0.0f) {
            this.energy = 0.0f;
        }
    }

    public int getExtract() {
        return Math.min(this.maxExtract, (int)this.energy);
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public void setMaxEnergyStored(int pCapacity) {
        this.capacity = pCapacity;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setMaxExtract(int pMaxExtract) {
        this.maxExtract = pMaxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public void setMaxReceive(int pMaxReceive) {
        this.maxReceive = pMaxReceive;
    }

    public void setMaxTransfer(int pMaxTransfer) {
        this.setMaxExtract(pMaxTransfer);
        this.setMaxReceive(pMaxTransfer);
    }
}

