/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.lib;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ModConfiguration {
    private static Configuration config;
    private static boolean forceVanillaRecipes;
    private static boolean forceIronRotor;
    private static float[] windmillEfficiency;
    private static int[] windmillEnergyStorage;
    private static int windmillEnergyTransferMultiplier;
    private static double[] rotorEnergyMultiplier;
    private static double weatherMultiplierRain;
    private static double weatherMultiplierThunder;
    private static double handcrankEnergyMultiplier;
    private static float windGenerationBase;
    private static float angularVelocityPerRF;

    public static void init(File pConfigFile) {
        if (pConfigFile != null) {
            config = new Configuration(pConfigFile);
        }
        FMLCommonHandler.instance().bus().register((Object)new ModConfiguration());
        ModConfiguration.loadConfig();
    }

    private static void loadConfig() {
        Preconditions.checkNotNull((Object)config);
        forceVanillaRecipes = config.get("general", "ForceVanillaRecipes", false, "Ignore Thermal Expansion and use Vanilla recipes instead").getBoolean();
        forceIronRotor = config.get("general", "ForceIronRotorTexture", false, "Use the iron rotor texture regardless of the rotor material").getBoolean();
        windGenerationBase = (float)config.get("general", "WindGenerationBase", 40.0, "The amount of energy in the wind in RF/t").getDouble();
        ModConfiguration.windmillEfficiency[0] = (float)config.get("general", "WindmillBasicEfficiency", 0.1, "How good the windmill is at extracting energy from the wind").getDouble();
        ModConfiguration.windmillEfficiency[1] = (float)config.get("general", "WindmillHardenedEfficiency", 0.3).getDouble();
        ModConfiguration.windmillEfficiency[2] = (float)config.get("general", "WindmillReinforcedEfficiency", 0.6).getDouble();
        ModConfiguration.windmillEfficiency[3] = (float)config.get("general", "WindmillResonantEfficiency", 0.9).getDouble();
        ModConfiguration.windmillEnergyStorage[0] = config.get("general", "WindmillBasicEnergyStorage", 16000, "Energy storage capacity of the windmill in RF").getInt();
        ModConfiguration.windmillEnergyStorage[1] = config.get("general", "WindmillHardenedEnergyStorage", 32000).getInt();
        ModConfiguration.windmillEnergyStorage[2] = config.get("general", "WindmillReinforcedEnergyStorage", 48000).getInt();
        ModConfiguration.windmillEnergyStorage[3] = config.get("general", "WindmillResonantEnergyStorage", 64000).getInt();
        windmillEnergyTransferMultiplier = config.get("general", "WindmillEnergyTransferMultiplier", 4, "Multiply by the base wind energy generation to get the rate of energy transfer in RF/t").getInt();
        ModConfiguration.rotorEnergyMultiplier[0] = config.get("general", "RotorBasicEnergyMultiplier", 0.625, "Multiplier applied to the windmill generation due to the rotor").getDouble();
        ModConfiguration.rotorEnergyMultiplier[1] = config.get("general", "RotorHardenedEnergyMultiplier", 0.75).getDouble();
        ModConfiguration.rotorEnergyMultiplier[2] = config.get("general", "RotorReinforcedEnergyMultiplier", 0.875).getDouble();
        ModConfiguration.rotorEnergyMultiplier[3] = config.get("general", "RotorResonantEnergyMultiplier", 1.0).getDouble();
        weatherMultiplierRain = config.get("general", "WeatherRainEnergyGenerationMultiplier", 1.2, "Multiplier applied to the windmill generation when it's raining").getDouble();
        weatherMultiplierThunder = config.get("general", "WeatherThunderEnergyGenerationMultiplier", 1.5, "Multiplier applied to the windmill generation when it's raining").getDouble();
        handcrankEnergyMultiplier = config.get("general", "HandcrankEnergyMultiplier", 0.4, "Multiplier applied to energy generation when turning rotors by hand").getDouble();
        angularVelocityPerRF = (float)config.get("general", "AngularVelocityPerRF", 0.5, "Degrees per RF per tick that the rotor rotates by").getDouble();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean useVanillaRecipes() {
        return forceVanillaRecipes;
    }

    public static boolean useIronRotorTexture() {
        return forceIronRotor;
    }

    public static float[] getWindmillEfficiency() {
        return windmillEfficiency;
    }

    public static int[] getWindmillEnergyStorage() {
        return windmillEnergyStorage;
    }

    public static int getWindmillEnergyTransferMultiplier() {
        return windmillEnergyTransferMultiplier;
    }

    public static float getRotorEnergyMultiplier(int pType) {
        return (float)rotorEnergyMultiplier[pType];
    }

    public static float getWeatherMultiplierRain() {
        return (float)weatherMultiplierRain;
    }

    public static float getWeatherMultiplierThunder() {
        return (float)weatherMultiplierThunder;
    }

    public static float getHandcrankEnergyMultiplier() {
        return (float)handcrankEnergyMultiplier;
    }

    public static float getWindGenerationBase() {
        return windGenerationBase;
    }

    public static float getAngularVelocityPerRF() {
        return angularVelocityPerRF;
    }

    static {
        windmillEfficiency = new float[4];
        windmillEnergyStorage = new int[4];
        rotorEnergyMultiplier = new double[4];
    }
}

