/*
 * Decompiled with CFR 0.152.
 */
package com.piepenguin.rfwindmill.tileentities;

import com.piepenguin.rfwindmill.items.ModItems;
import com.piepenguin.rfwindmill.items.RFWItem;
import com.piepenguin.rfwindmill.lib.ModConfiguration;
import com.piepenguin.rfwindmill.lib.Util;
import com.piepenguin.rfwindmill.tileentities.TileEntityWindmillBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRotorBlock
extends TileEntity {
    private float rotation = 0.0f;
    private float scale = 0.0f;
    private static final String NBT_ROTOR_TYPE = "RFWRotorType";
    private int type = 0;
    public static String publicName = "tileEntityRotorBlock";
    private static final float degreesPerRFPerTick = ModConfiguration.getAngularVelocityPerRF();

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            ForgeDirection turbineDir = Util.intToDirection(this.func_145832_p() & 3).getOpposite();
            int parentX = this.field_145851_c + turbineDir.offsetX;
            int parentY = this.field_145848_d + turbineDir.offsetY;
            int parentZ = this.field_145849_e + turbineDir.offsetZ;
            TileEntityWindmillBlock entity = (TileEntityWindmillBlock)this.field_145850_b.func_147438_o(parentX, parentY, parentZ);
            if (entity != null) {
                this.rotation += entity.getCurrentEnergyGeneration() * degreesPerRFPerTick;
            }
            this.scale = 1.0f;
        }
    }

    public void readSyncableDataFromNBT(NBTTagCompound pNbt) {
        this.type = pNbt.func_74762_e(NBT_ROTOR_TYPE);
    }

    public void writeSyncableDataToNBT(NBTTagCompound pNbt) {
        pNbt.func_74768_a(NBT_ROTOR_TYPE, this.type);
    }

    public void func_145839_a(NBTTagCompound pNbt) {
        super.func_145839_a(pNbt);
        this.readSyncableDataFromNBT(pNbt);
    }

    public void func_145841_b(NBTTagCompound pNbt) {
        super.func_145841_b(pNbt);
        this.writeSyncableDataToNBT(pNbt);
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager pNet, S35PacketUpdateTileEntity pPacket) {
        this.readSyncableDataFromNBT(pPacket.func_148857_g());
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScale() {
        return this.scale;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int pType) {
        this.type = pType;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (this.type << 2) + (this.func_145832_p() & 3), 2);
    }

    public int getTexture() {
        if (ModConfiguration.useIronRotorTexture()) {
            return 0;
        }
        switch (this.type) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return Util.useThermalExpansion() ? 2 : 4;
            }
            case 3: 
        }
        return Util.useThermalExpansion() ? 3 : 5;
    }

    public RFWItem getRotorItem() {
        switch (this.type) {
            default: {
                return ModItems.rotor1;
            }
            case 1: {
                return ModItems.rotor2;
            }
            case 2: {
                return ModItems.rotor3;
            }
            case 3: 
        }
        return ModItems.rotor4;
    }
}

