/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.thaumicenergistics;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.awt.Point;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.common.network.packet.server.Packet_S_KnowledgeInscriber;

public class KnowledgeInscriberNEIntegration
implements IOverlayHandler {
    private static final Item FAKE_ASPECT = GameRegistry.findItem((String)"thaumcraftneiplugin", (String)"Aspect");
    private static final TObjectByteHashMap<Point> SHAPED_SLOT_MAPPINGS = new TObjectByteHashMap(10, 0.9f, -1);
    private final boolean shapeless;

    public KnowledgeInscriberNEIntegration(boolean shapeless) {
        this.shapeless = shapeless;
    }

    public void overlayRecipe(GuiContainer guiContainer, IRecipeHandler handler, int recipeID, boolean shift) {
        try {
            ItemStack[] matrix = new ItemStack[9];
            if (this.shapeless) {
                int slot = 0;
                for (PositionedStack input : handler.getIngredientStacks(recipeID)) {
                    if (input == null) continue;
                    ItemStack item = KnowledgeInscriberNEIntegration.getFirst(input);
                    if (item != null && item.func_77973_b() != FAKE_ASPECT) {
                        matrix[slot++] = item;
                    }
                    if (slot < 8) continue;
                    break;
                }
            } else {
                for (PositionedStack input : handler.getIngredientStacks(recipeID)) {
                    byte slot;
                    if (input == null || (slot = SHAPED_SLOT_MAPPINGS.get((Object)new Point(input.relx, input.rely))) == -1) continue;
                    matrix[slot] = KnowledgeInscriberNEIntegration.getFirst(input);
                }
            }
            Packet_S_KnowledgeInscriber.sendNEISelect((EntityPlayer)Minecraft.func_71410_x().field_71439_g, matrix);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static ItemStack getFirst(@Nonnull PositionedStack p) {
        ItemStack result;
        ItemStack itemStack = result = p.item != null || p.items.length == 0 ? p.item : p.items[0];
        if (result != null && result.func_77960_j() == Short.MAX_VALUE) {
            NBTTagCompound nbt = result.field_77990_d == null ? null : (NBTTagCompound)result.field_77990_d.func_74737_b();
            result = new ItemStack(result.func_77973_b(), result.field_77994_a);
            result.func_77982_d(nbt);
        }
        return result;
    }

    static {
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(48, 33), (byte)0);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(75, 33), (byte)1);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(103, 33), (byte)2);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(49, 60), (byte)3);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(76, 60), (byte)4);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(103, 60), (byte)5);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(49, 87), (byte)6);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(76, 87), (byte)7);
        SHAPED_SLOT_MAPPINGS.put((Object)new Point(103, 87), (byte)8);
        SHAPED_SLOT_MAPPINGS.trimToSize();
    }
}

