/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import appeng.core.localization.GuiText;
import appeng.helpers.IPriorityHost;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.client.gui.abstraction.ThEBaseGui;
import thaumicenergistics.client.gui.buttons.GuiButtonAETab;
import thaumicenergistics.client.gui.widget.DigitTextField;
import thaumicenergistics.client.textures.AEStateIconsEnum;
import thaumicenergistics.client.textures.GuiTextureManager;
import thaumicenergistics.common.container.ContainerPriority;
import thaumicenergistics.common.network.packet.server.Packet_S_ChangeGui;
import thaumicenergistics.common.network.packet.server.Packet_S_Priority;
import thaumicenergistics.common.parts.ThEPartBase;

@SideOnly(value=Side.CLIENT)
public class GuiPriority
extends ThEBaseGui {
    private static final AdjustmentButtonDef[] ADJUSTMENT_BUTTONS = new AdjustmentButtonDef[]{new AdjustmentButtonDef(AdjustmentButtonDef.EnumButtonWidth.Small, 1), new AdjustmentButtonDef(AdjustmentButtonDef.EnumButtonWidth.Medium, 10), new AdjustmentButtonDef(AdjustmentButtonDef.EnumButtonWidth.Large, 100), new AdjustmentButtonDef(AdjustmentButtonDef.EnumButtonWidth.Small, -1), new AdjustmentButtonDef(AdjustmentButtonDef.EnumButtonWidth.Medium, -10), new AdjustmentButtonDef(AdjustmentButtonDef.EnumButtonWidth.Large, -100)};
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 107;
    private static final int PART_SWITCH_BUTTON_ID = 0;
    private static final int PART_SWITCH_BUTTON_X_POSITION = 154;
    private static final int ADJUSTMENT_BUTTONS_ID = 1;
    private static final int ADJUSTMENT_BUTTONS_X_POSITION = 35;
    private static final int[] ADJUSTMENT_BUTTONS_Y_POSITION = new int[]{30, 70};
    private static final int ADJUSTMENT_BUTTONS_X_PADDING = 5;
    private static final int AMOUNT_OFFSET_X = 61;
    private static final int AMOUNT_OFFSET_Y = 57;
    private static final int AMOUNT_WIDTH = 80;
    private static final int AMOUNT_HEIGHT = 10;
    private static final int AMOUNT_MAX_CHARS = 8;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 6;
    private final ThEPartBase part;
    private final EntityPlayer player;
    private final String title;
    private DigitTextField amountField;

    public GuiPriority(IPriorityHost host, EntityPlayer player) {
        super(new ContainerPriority(host, player));
        this.part = (ThEPartBase)host;
        this.player = player;
        this.field_146999_f = 176;
        this.field_147000_g = 107;
        this.title = GuiText.Priority.getLocal();
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.PRIORITY.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, 6, 6, 0);
        this.amountField.func_146194_f();
    }

    protected void func_73869_a(char key, int keyID) {
        super.func_73869_a(key, keyID);
        if (this.amountField.func_146179_b().length() < 8) {
            this.amountField.func_146201_a(key, keyID);
            if (this.amountField.func_146179_b().equals("-")) {
                return;
            }
            int newPriority = 0;
            try {
                newPriority = Integer.parseInt(this.amountField.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Packet_S_Priority.sendPriority(newPriority, this.player);
        }
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        if (button.field_146127_k == 0) {
            TileEntity host = this.part.getHostTile();
            Packet_S_ChangeGui.sendGuiChangeToPart(this.part, this.player, host.func_145831_w(), host.field_145851_c, host.field_145848_d, host.field_145849_e);
            return;
        }
        try {
            AdjustmentButtonDef abDef = ADJUSTMENT_BUTTONS[button.field_146127_k - 1];
            Packet_S_Priority.sendPriorityDelta(abDef.amount, this.player);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButtonAETab(0, this.field_147003_i + 154, this.field_147009_r, AEStateIconsEnum.WRENCH, this.part.getUnlocalizedName()));
        int buttonXPosition = 35;
        int buttonYPosition = ADJUSTMENT_BUTTONS_Y_POSITION[0];
        for (int adjustmentButtonIndex = 0; adjustmentButtonIndex < ADJUSTMENT_BUTTONS.length; ++adjustmentButtonIndex) {
            AdjustmentButtonDef def = ADJUSTMENT_BUTTONS[adjustmentButtonIndex];
            int ID = 1 + adjustmentButtonIndex;
            if (adjustmentButtonIndex == ADJUSTMENT_BUTTONS.length / 2) {
                buttonXPosition = 35;
                buttonYPosition = ADJUSTMENT_BUTTONS_Y_POSITION[1];
            }
            this.field_146292_n.add(def.makeButton(ID, this.field_147003_i + buttonXPosition, this.field_147009_r + buttonYPosition));
            buttonXPosition += def.width + 5;
        }
        this.amountField = new DigitTextField(this.field_146289_q, 61, 57, 80, 10);
        this.amountField.func_146195_b(true);
        this.amountField.func_146185_a(false);
        this.amountField.func_146193_g(-1);
        if (this.field_146297_k.func_71356_B()) {
            Packet_S_Priority.sendPriorityRequest(this.player);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void onServerSendPriority(int priority) {
        this.amountField.func_146180_a(Integer.toString(priority));
    }

    private static class AdjustmentButtonDef {
        private static final int BUTTON_HEIGHT = 20;
        public final int width;
        public final String caption;
        public final int amount;

        public AdjustmentButtonDef(EnumButtonWidth buttonWidth, int amount) {
            this.width = buttonWidth.width;
            this.caption = (amount > 0 ? "+" : "") + Integer.toString(amount);
            this.amount = amount;
        }

        public GuiButton makeButton(int ID, int xPosition, int yPosition) {
            return new GuiButton(ID, xPosition, yPosition, this.width, 20, this.caption);
        }

        static enum EnumButtonWidth {
            Small(25),
            Medium(35),
            Large(45);

            public final int width;

            private EnumButtonWidth(int width) {
                this.width = width;
            }
        }
    }
}

