/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.blocks;

import appeng.api.implementations.items.IMemoryCard;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.ThaumicEnergistics;
import thaumicenergistics.common.blocks.AbstractBlockAEWrenchable;
import thaumicenergistics.common.blocks.BlockEnum;
import thaumicenergistics.common.tiles.TileArcaneAssembler;

public class BlockArcaneAssembler
extends AbstractBlockAEWrenchable {
    public static final int MAX_SPEED_UPGRADES = 4;

    public BlockArcaneAssembler() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(ThaumicEnergistics.ThETab);
    }

    @Override
    protected boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack playerHolding = player.field_71071_by.func_70448_g();
        TileEntity tileAssembler = world.func_147438_o(x, y, z);
        if (tileAssembler instanceof TileArcaneAssembler) {
            if (playerHolding != null && playerHolding.func_77973_b() instanceof IMemoryCard) {
                ((TileArcaneAssembler)tileAssembler).onMemoryCardActivate(player, (IMemoryCard)playerHolding.func_77973_b(), playerHolding);
            } else if (((TileArcaneAssembler)tileAssembler).func_70300_a(player)) {
                ThEGuiHandler.launchGui(50, player, world, x, y, z);
            }
        }
        return true;
    }

    @Override
    protected ItemStack onDismantled(World world, int x, int y, int z) {
        ItemStack itemStack = new ItemStack((Block)this);
        TileEntity tileAssembler = world.func_147438_o(x, y, z);
        if (tileAssembler instanceof TileArcaneAssembler) {
            NBTTagCompound data = new NBTTagCompound();
            ((TileArcaneAssembler)tileAssembler).writeVisLevelsToNBT(data);
            if (!data.func_82582_d()) {
                itemStack.func_77982_d(data);
            }
        }
        return itemStack;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metaData) {
        TileEntity tileAssembler;
        if (!world.field_72995_K && (tileAssembler = world.func_147438_o(x, y, z)) instanceof TileArcaneAssembler) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ((TileArcaneAssembler)tileAssembler).getDrops(world, x, y, z, drops);
            for (ItemStack drop : drops) {
                world.func_72838_d((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)y, 0.2 + (double)z, drop));
            }
            ((TileArcaneAssembler)tileAssembler).onBreak();
        }
        super.func_149749_a(world, x, y, z, block, metaData);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileArcaneAssembler();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return BlockTextureManager.ARCANE_ASSEMBLER.getTexture();
    }

    public String func_149739_a() {
        return BlockEnum.ARCANE_ASSEMBLER.getUnlocalizedName();
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileAssembler = world.func_147438_o(x, y, z);
        if (tileAssembler instanceof TileArcaneAssembler) {
            if (itemStack.func_77942_o()) {
                ((TileArcaneAssembler)tileAssembler).readVisLevelsFromNBT(itemStack.func_77978_p());
            }
            if (player instanceof EntityPlayer) {
                ((TileArcaneAssembler)tileAssembler).setOwner((EntityPlayer)player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister register) {
    }

    public final boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }
}

