/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.blocks;

import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.ThaumicEnergistics;
import thaumicenergistics.common.blocks.AbstractBlockAEWrenchable;
import thaumicenergistics.common.blocks.BlockEnum;
import thaumicenergistics.common.tiles.TileEssentiaVibrationChamber;
import thaumicenergistics.common.utils.EffectiveSide;

public class BlockEssentiaVibrationChamber
extends AbstractBlockAEWrenchable {
    public BlockEssentiaVibrationChamber() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(ThaumicEnergistics.ThETab);
    }

    private TileEssentiaVibrationChamber getEVCTile(IBlockAccess world, int x, int y, int z) {
        TileEntity te;
        if (world != null && (te = world.func_147438_o(x, y, z)) instanceof TileEssentiaVibrationChamber) {
            return (TileEssentiaVibrationChamber)te;
        }
        return null;
    }

    @Override
    protected boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && this.getEVCTile((IBlockAccess)world, x, y, z) != null) {
            ThEGuiHandler.launchGui(70, player, world, x, y, z);
        }
        return true;
    }

    @Override
    protected ItemStack onDismantled(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        TileEssentiaVibrationChamber chamber = this.getEVCTile((IBlockAccess)world, x, y, z);
        if (chamber == null) {
            return null;
        }
        if (!chamber.hasSaveDataForDismanle()) {
            return null;
        }
        chamber.resetForDismantle();
        NBTTagCompound tag = new NBTTagCompound();
        chamber.onNBTSave(tag);
        ItemStack representive = new ItemStack((Block)this);
        representive.func_77982_d(tag);
        return representive;
    }

    public TileEntity func_149915_a(World world, int metaData) {
        return new TileEssentiaVibrationChamber();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEssentiaVibrationChamber chamber = this.getEVCTile(world, x, y, z);
        if (chamber == null) {
            return this.func_149691_a(side, 0);
        }
        if (chamber.getForward() != null && side == chamber.getForward().ordinal()) {
            Aspect aspect = chamber.getProcessingAspect();
            if (aspect == Aspect.ENERGY) {
                return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[3];
            }
            if (aspect == Aspect.FIRE) {
                return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[2];
            }
            return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[1];
        }
        return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 4) {
            return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[1];
        }
        return BlockTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTextures()[0];
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEssentiaVibrationChamber chamber = this.getEVCTile(world, x, y, z);
        if (chamber != null) {
            return chamber.getProcessingAspect() != null ? 12 : 0;
        }
        return 0;
    }

    public String func_149739_a() {
        return BlockEnum.ESSENTIA_VIBRATION_CHAMBER.getUnlocalizedName();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileEssentiaVibrationChamber chamber = this.getEVCTile((IBlockAccess)world, x, y, z);
        if (chamber == null) {
            return;
        }
        if (itemStack.func_77978_p() != null && EffectiveSide.isServerSide()) {
            chamber.onNBTLoad(itemStack.func_77978_p());
        }
        if (player instanceof EntityPlayer) {
            chamber.setOwner((EntityPlayer)player);
        }
        ForgeDirection face = ForgeDirection.NORTH;
        if (player.field_70125_A > 50.0f) {
            face = ForgeDirection.UP;
        } else if (player.field_70125_A < -50.0f) {
            face = ForgeDirection.DOWN;
        } else {
            int sideIndex = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (sideIndex) {
                case 0: {
                    face = ForgeDirection.NORTH;
                    break;
                }
                case 1: {
                    face = ForgeDirection.EAST;
                    break;
                }
                case 2: {
                    face = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    face = ForgeDirection.WEST;
                }
            }
        }
        chamber.setOrientation(face, ForgeDirection.UP);
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister register) {
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEssentiaVibrationChamber chamber = this.getEVCTile((IBlockAccess)world, x, y, z);
        if (chamber == null) {
            return false;
        }
        ForgeDirection forward = chamber.getForward();
        ForgeDirection up = chamber.getUp();
        forward = Platform.rotateAround((ForgeDirection)forward, (ForgeDirection)axis);
        up = Platform.rotateAround((ForgeDirection)up, (ForgeDirection)axis);
        chamber.setOrientation(forward, up);
        return true;
    }
}

