/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.implementations.items.IUpgradeModule;
import appeng.container.slot.SlotInaccessible;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.IVisDiscountGear;
import thaumicenergistics.common.container.ContainerWithNetworkTool;
import thaumicenergistics.common.container.slot.SlotArmor;
import thaumicenergistics.common.container.slot.SlotRestrictive;
import thaumicenergistics.common.tiles.TileArcaneAssembler;

public class ContainerArcaneAssembler
extends ContainerWithNetworkTool {
    private static final int PLAYER_INV_POSITION_Y = 115;
    private static final int HOTBAR_INV_POSITION_Y = 173;
    private static final int PATTERN_SLOT_X = 26;
    private static final int PATTERN_SLOT_Y = 25;
    private static final int PATTERN_ROWS = 3;
    private static final int PATTERN_COLS = 7;
    private static final int KCORE_SLOT_X = 187;
    private static final int KCORE_SLOT_Y = 8;
    private static final int UPGRADE_SLOT_COUNT = 4;
    private static final int UPGRADE_SLOT_X = 187;
    private static final int UPGRADE_SLOT_Y = 26;
    private static final int TARGET_SLOT_X = 14;
    private static final int TARGET_SLOT_Y = 87;
    private static final int DISCOUNT_ARMOR_SLOT_X = 210;
    private static final int DISCOUNT_ARMOR_SLOT_Y = 26;
    private static final int DISCOUNT_ARMOR_COUNT = 4;
    public final TileArcaneAssembler assembler;
    private SlotRestrictive kCoreSlot;
    private final SlotArmor[] discountSlots = new SlotArmor[4];
    private final SlotInaccessible[] patternSlots = new SlotInaccessible[21];

    public ContainerArcaneAssembler(EntityPlayer player, World world, int X, int Y, int Z) {
        super(player);
        TileEntity tile = world.func_147438_o(X, Y, Z);
        if (!(tile instanceof TileArcaneAssembler)) {
            this.assembler = null;
            player.func_71053_j();
            return;
        }
        this.assembler = (TileArcaneAssembler)tile;
        IInventory assemblerInventory = this.assembler.getInternalInventory();
        this.bindPlayerInventory((IInventory)player.field_71071_by, 115, 173);
        this.bindToNetworkTool(player.field_71071_by, this.assembler.getLocation(), 0, 35);
        this.kCoreSlot = new SlotRestrictive(assemblerInventory, 0, 187, 8);
        this.func_75146_a(this.kCoreSlot);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 7; ++col) {
                int index = row * 7 + col;
                int invIndex = 1 + index;
                this.patternSlots[index] = new SlotInaccessible(assemblerInventory, invIndex, 26 + 18 * col, 25 + 18 * row);
                this.func_75146_a((Slot)this.patternSlots[index]);
            }
        }
        this.addUpgradeSlots(this.assembler.getUpgradeInventory(), 4, 187, 26);
        this.func_75146_a((Slot)new SlotInaccessible(assemblerInventory, 22, 14, 87));
        for (int index = 0; index < 4; ++index) {
            this.discountSlots[index] = new SlotArmor(assemblerInventory, 23 + index, 210, 26 + index * 18, index, true);
            this.func_75146_a(this.discountSlots[index]);
        }
    }

    private boolean mergeWithArmorSlots(ItemStack slotStack) {
        for (int index = 0; index < 4; ++index) {
            if (!this.discountSlots[index].func_75214_a(slotStack)) continue;
            if (this.discountSlots[index].func_75216_d()) break;
            this.discountSlots[index].func_75215_d(slotStack.func_77946_l());
            slotStack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.assembler != null) {
            return this.assembler.func_70300_a(player);
        }
        return false;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (player.field_70170_p.field_72995_K) {
            return null;
        }
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (!(slotStack.func_77973_b() instanceof IUpgradeModule)) {
                    if (this.kCoreSlot.func_75214_a(slotStack)) {
                        didMerge = this.func_75135_a(slotStack, this.kCoreSlot.field_75222_d, this.kCoreSlot.field_75222_d + 1, false);
                    } else if (slotStack.func_77973_b() instanceof IVisDiscountGear) {
                        didMerge = this.mergeWithArmorSlots(slotStack);
                    }
                    if (!didMerge) {
                        didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                    }
                }
            } else if ((this.kCoreSlot.field_75222_d == slotNumber || slotNumber >= this.discountSlots[0].field_75222_d && slotNumber <= this.discountSlots[3].field_75222_d) && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            }
            if (didMerge) {
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
                return null;
            }
        }
        return super.func_82846_b(player, slotNumber);
    }
}

