/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.api.gui.ICraftingIssuerContainer;
import thaumicenergistics.client.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.container.ContainerInternalCrafting;
import thaumicenergistics.common.container.ContainerWithPlayerInventory;
import thaumicenergistics.common.container.slot.SlotArcaneCraftingResult;
import thaumicenergistics.common.container.slot.SlotArmor;
import thaumicenergistics.common.container.slot.SlotRestrictive;
import thaumicenergistics.common.integration.tc.ArcaneRecipeHelper;
import thaumicenergistics.common.network.packet.client.Packet_C_ArcaneCraftingTerminal;
import thaumicenergistics.common.network.packet.client.Packet_C_Sync;
import thaumicenergistics.common.parts.PartArcaneCraftingTerminal;
import thaumicenergistics.common.utils.ThEUtils;

public class ContainerPartArcaneCraftingTerminal
extends ContainerWithPlayerInventory
implements IMEMonitorHandlerReceiver<IAEItemStack>,
ICraftingIssuerContainer {
    private static int PLAYER_INV_POSITION_Y = 162;
    private static int HOTBAR_INV_POSITION_Y = 220;
    private static int CRAFTING_GRID_SIZE = 3;
    public static int CRAFTING_GRID_TOTAL_SIZE = CRAFTING_GRID_SIZE * CRAFTING_GRID_SIZE;
    public static int CRAFTING_SLOT_X_POS = 44;
    public static int CRAFTING_SLOT_Y_POS = 90;
    private static int RESULT_SLOT_X_POS = 116;
    private static int RESULT_SLOT_Y_POS = 126;
    private static int WAND_SLOT_XPOS = 116;
    private static int WAND_SLOT_YPOS = 90;
    public static int VIEW_SLOT_XPOS = 206;
    public static int VIEW_SLOT_YPOS = 8;
    public static int ARMOR_SLOT_X_POS = 8;
    public static int ARMOR_SLOT_Y_POS = 81;
    public static int ARMOR_SLOT_COUNT = 4;
    private static CraftingManager CRAFT_MANAGER = CraftingManager.func_77594_a();
    private final PartArcaneCraftingTerminal terminal;
    private final PlayerSource playerSource;
    private IMEMonitor<IAEItemStack> monitor;
    private int firstCraftingSlotNumber = -1;
    private int lastCraftingSlotNumber = -1;
    private int firstViewSlotNumber = -1;
    private int lastViewSlotNumber = -1;
    private final SlotRestrictive wandSlot;
    private final SlotArcaneCraftingResult resultSlot;
    private ItemStack wand;
    private AspectList requiredAspects;
    private List<ArcaneCrafingCost> craftingCost = new ArrayList<ArcaneCrafingCost>();
    private SortOrder cachedSortOrder = PartArcaneCraftingTerminal.DEFAULT_SORT_ORDER;
    private SortDir cachedSortDirection = PartArcaneCraftingTerminal.DEFAULT_SORT_DIR;
    private ViewItems cachedViewMode = PartArcaneCraftingTerminal.DEFAULT_VIEW_MODE;

    public ContainerPartArcaneCraftingTerminal(PartArcaneCraftingTerminal terminal, EntityPlayer player) {
        super(player);
        this.terminal = terminal;
        this.playerSource = new PlayerSource(this.player, (IActionHost)terminal);
        this.bindPlayerInventory((IInventory)player.field_71071_by, PLAYER_INV_POSITION_Y, HOTBAR_INV_POSITION_Y);
        Slot craftingSlot = null;
        for (int row = 0; row < CRAFTING_GRID_SIZE; ++row) {
            for (int column = 0; column < CRAFTING_GRID_SIZE; ++column) {
                int slotIndex = row * CRAFTING_GRID_SIZE + column;
                craftingSlot = new Slot((IInventory)terminal, slotIndex, CRAFTING_SLOT_X_POS + column * 18, CRAFTING_SLOT_Y_POS + row * 18);
                this.func_75146_a(craftingSlot);
                if (row + column != 0) continue;
                this.firstCraftingSlotNumber = craftingSlot.field_75222_d;
            }
        }
        if (craftingSlot != null) {
            this.lastCraftingSlotNumber = craftingSlot.field_75222_d;
        }
        this.resultSlot = new SlotArcaneCraftingResult(player, this, terminal, terminal, 10, RESULT_SLOT_X_POS, RESULT_SLOT_Y_POS);
        this.func_75146_a((Slot)this.resultSlot);
        this.wandSlot = new SlotRestrictive(terminal, 9, WAND_SLOT_XPOS, WAND_SLOT_YPOS);
        this.func_75146_a(this.wandSlot);
        SlotRestrictive viewSlot = null;
        for (int viewSlotID = 11; viewSlotID <= 15; ++viewSlotID) {
            int row = viewSlotID - 11;
            int yPos = VIEW_SLOT_YPOS + row * 18;
            viewSlot = new SlotRestrictive(terminal, viewSlotID, VIEW_SLOT_XPOS, yPos);
            this.func_75146_a(viewSlot);
            if (row != 0) continue;
            this.firstViewSlotNumber = viewSlot.field_75222_d;
        }
        if (viewSlot != null) {
            this.lastViewSlotNumber = viewSlot.field_75222_d;
        }
        for (int armorIndex = 0; armorIndex < ARMOR_SLOT_COUNT; ++armorIndex) {
            int yPos = ARMOR_SLOT_Y_POS + 18 * armorIndex;
            SlotArmor armorSlot = new SlotArmor(terminal, 16 + armorIndex, ARMOR_SLOT_X_POS, yPos, armorIndex, false);
            this.func_75146_a(armorSlot);
            armorSlot = new SlotArmor((IInventory)player.field_71071_by, 36 + (3 - armorIndex), 0, -1000, armorIndex, false);
            this.func_75146_a(armorSlot);
        }
        if (!player.field_70170_p.field_72995_K) {
            this.registerForUpdates();
        }
        this.attachToMonitor();
    }

    private boolean attachToMonitor() {
        IGrid grid;
        if (this.player.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
        if ((grid = this.terminal.getGridBlock().getGrid()) != null) {
            this.monitor = this.terminal.getItemInventory();
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, (Object)grid.hashCode());
                return true;
            }
        }
        return false;
    }

    private boolean clearCraftingGrid(boolean sendUpdate) {
        if (this.player.field_70170_p.field_72995_K) {
            return false;
        }
        boolean clearedAll = true;
        for (int index = this.firstCraftingSlotNumber; index <= this.lastCraftingSlotNumber; ++index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) continue;
            ItemStack slotStack = slot.func_75211_c();
            boolean didMerge = this.mergeWithMENetwork(slotStack);
            if (!didMerge) {
                clearedAll = false;
                continue;
            }
            if (slotStack == null || slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
                continue;
            }
            clearedAll = false;
            slot.func_75218_e();
        }
        this.func_75142_b();
        return clearedAll;
    }

    private void doShiftAutoCrafting(EntityPlayer player) {
        int autoCraftCounter = 0;
        ItemStack resultStack = this.resultSlot.func_75211_c();
        ItemStack slotStackOriginal = resultStack.func_77946_l();
        for (autoCraftCounter = slotStackOriginal.field_77994_a; autoCraftCounter <= 64; autoCraftCounter += slotStackOriginal.field_77994_a) {
            boolean didMerge;
            boolean bl = didMerge = this.mergeSlotWithPlayerInventory(resultStack) || this.mergeSlotWithHotbarInventory(resultStack);
            if (!didMerge) break;
            this.resultSlot.onPickupFromSlotViaTransfer(player, resultStack);
            this.func_75130_a(null);
            resultStack = this.resultSlot.func_75211_c();
            if (resultStack == null || resultStack.field_77994_a == 0 || !resultStack.func_77973_b().equals(slotStackOriginal.func_77973_b())) break;
        }
        if (autoCraftCounter > 0) {
            this.resultSlot.func_75218_e();
            this.func_75142_b();
        }
    }

    private boolean doStacksMatch(IAEItemStack keyStack, IAEItemStack potentialMatch) {
        if (keyStack.getItemStack().func_77969_a(potentialMatch.getItemStack())) {
            return true;
        }
        int[] keyIDs = OreDictionary.getOreIDs((ItemStack)keyStack.getItemStack());
        int[] matchIDs = OreDictionary.getOreIDs((ItemStack)potentialMatch.getItemStack());
        if (keyIDs.length == 0 || matchIDs.length == 0) {
            return false;
        }
        for (int keyID : keyIDs) {
            for (int matchID : matchIDs) {
                if (keyID != matchID) continue;
                return true;
            }
        }
        return false;
    }

    private ItemStack findMatchingArcaneResult() {
        ItemStack arcaneResult = null;
        IArcaneRecipe matchingRecipe = ArcaneRecipeHelper.INSTANCE.findMatchingArcaneResult(this.terminal, 0, CRAFTING_GRID_TOTAL_SIZE, this.player);
        if (matchingRecipe != null) {
            arcaneResult = this.validateWandVisAmount(matchingRecipe);
        }
        return arcaneResult;
    }

    private ItemStack findMatchingRegularResult() {
        InventoryCrafting craftingInventory = new InventoryCrafting((Container)new ContainerInternalCrafting(), CRAFTING_GRID_SIZE, CRAFTING_GRID_SIZE);
        for (int slotIndex = 0; slotIndex < CRAFTING_GRID_TOTAL_SIZE; ++slotIndex) {
            craftingInventory.func_70299_a(slotIndex, this.terminal.func_70301_a(slotIndex));
        }
        return CRAFT_MANAGER.func_82787_a(craftingInventory, this.terminal.getWorldObj());
    }

    private ItemStack[] getViewCells() {
        ArrayList<ItemStack> viewCells = new ArrayList<ItemStack>();
        for (int viewSlotIndex = this.firstViewSlotNumber; viewSlotIndex <= this.lastViewSlotNumber; ++viewSlotIndex) {
            Slot viewSlot = this.getSlotOrNull(viewSlotIndex);
            if (viewSlot == null || !viewSlot.func_75216_d()) continue;
            viewCells.add(viewSlot.func_75211_c());
        }
        return viewCells.toArray(new ItemStack[viewCells.size()]);
    }

    private void getWand() {
        if (this.wand == this.wandSlot.func_75211_c()) {
            return;
        }
        if (ThEUtils.isItemValidWand(this.wandSlot.func_75211_c(), false)) {
            this.wand = this.wandSlot.func_75211_c();
            return;
        }
        this.wand = null;
    }

    private boolean mergeWithMENetwork(ItemStack itemStack) {
        IAEItemStack toInject = AEApi.instance().storage().createItemStack(itemStack);
        IAEItemStack leftOver = (IAEItemStack)this.monitor.injectItems((IAEStack)toInject, Actionable.MODULATE, (BaseActionSource)this.playerSource);
        if (leftOver != null && leftOver.getStackSize() > 0L) {
            if (leftOver.getStackSize() == toInject.getStackSize()) {
                return false;
            }
            itemStack.field_77994_a = (int)leftOver.getStackSize();
            return true;
        }
        itemStack.field_77994_a = 0;
        return true;
    }

    private boolean mergeWithViewCells(ItemStack itemStack) {
        if (!this.terminal.func_94041_b(11, itemStack)) {
            return false;
        }
        for (int viewSlotIndex = this.firstViewSlotNumber; viewSlotIndex <= this.lastViewSlotNumber; ++viewSlotIndex) {
            Slot viewSlot = this.getSlotOrNull(viewSlotIndex);
            if (viewSlot == null || viewSlot.func_75216_d()) continue;
            viewSlot.func_75215_d(itemStack.func_77946_l());
            itemStack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateGUIViewCells() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiArcaneCraftingTerminal) {
            ((GuiArcaneCraftingTerminal)gui).onViewCellsChanged(this.getViewCells());
        }
    }

    private ItemStack validateWandVisAmount(IArcaneRecipe forRecipe) {
        boolean hasAll = true;
        AspectList wandAspectList = null;
        ItemWandCasting wandItem = null;
        this.requiredAspects = ArcaneRecipeHelper.INSTANCE.getRecipeAspectCost(this.terminal, 0, CRAFTING_GRID_TOTAL_SIZE, forRecipe);
        if (this.requiredAspects == null) {
            return null;
        }
        Aspect[] recipeAspects = this.requiredAspects.getAspects();
        if (this.wand != null) {
            wandItem = (ItemWandCasting)this.wand.func_77973_b();
            wandAspectList = wandItem.getAllVis(this.wand);
        }
        for (Aspect currentAspect : recipeAspects) {
            int baseVis = this.requiredAspects.getAmount(currentAspect);
            int requiredVis = baseVis * 100;
            boolean hasEnough = false;
            if (wandItem != null && wandAspectList != null) {
                requiredVis = (int)((float)requiredVis * wandItem.getConsumptionModifier(this.wand, this.player, currentAspect, true));
                boolean bl = hasEnough = wandAspectList.getAmount(currentAspect) >= requiredVis;
            }
            if (!hasEnough) {
                hasAll = false;
            }
            this.craftingCost.add(new ArcaneCrafingCost((float)requiredVis / 100.0f, currentAspect, hasEnough));
        }
        if (hasAll) {
            return ArcaneRecipeHelper.INSTANCE.getRecipeOutput(this.terminal, 0, CRAFTING_GRID_TOTAL_SIZE, forRecipe);
        }
        return null;
    }

    @Override
    protected boolean detectAndSendChangesMP(EntityPlayerMP playerMP) {
        boolean sendModeUpdate = false;
        if (this.cachedSortOrder != this.terminal.getSortingOrder()) {
            this.cachedSortOrder = this.terminal.getSortingOrder();
            sendModeUpdate = true;
        }
        if (this.cachedSortDirection != this.terminal.getSortingDirection()) {
            this.cachedSortDirection = this.terminal.getSortingDirection();
            sendModeUpdate = true;
        }
        if (this.cachedViewMode != this.terminal.getViewMode()) {
            this.cachedViewMode = this.terminal.getViewMode();
            sendModeUpdate = true;
        }
        if (sendModeUpdate) {
            Packet_C_ArcaneCraftingTerminal.sendModeChange(this.player, this.cachedSortOrder, this.cachedSortDirection, this.cachedViewMode);
        }
        if (this.monitor == null && this.attachToMonitor()) {
            this.onClientRequestFullUpdate(this.player);
        }
        return false;
    }

    protected boolean slotClickedWasInCraftingInventory(int slotNumber) {
        return slotNumber >= this.firstCraftingSlotNumber && slotNumber <= this.lastCraftingSlotNumber;
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.terminal != null) {
            return this.terminal.func_70300_a(player);
        }
        return false;
    }

    public void changeSlotsYOffset(int deltaY) {
        for (Object slotObj : this.field_75151_b) {
            Slot slot = (Slot)slotObj;
            if (slot.field_75222_d >= this.firstViewSlotNumber && slot.field_75222_d <= this.lastViewSlotNumber) continue;
            slot.field_75221_f += deltaY;
        }
    }

    public List<ArcaneCrafingCost> getCraftingCost(boolean forceUpdate) {
        if (forceUpdate) {
            this.craftingCost.clear();
            this.findMatchingArcaneResult();
        }
        if (this.craftingCost.isEmpty()) {
            return Collections.emptyList();
        }
        return this.craftingCost;
    }

    @Override
    public ICraftingIssuerHost getCraftingHost() {
        return this.terminal;
    }

    public boolean isValid(Object authToken) {
        if (this.monitor == null) {
            return false;
        }
        IGrid grid = this.terminal.getGridBlock().getGrid();
        if (grid != null && grid.hashCode() == ((Integer)authToken).intValue()) {
            return true;
        }
        this.monitor = null;
        this.onClientRequestFullUpdate(this.player);
        return false;
    }

    public void onClientNEIRequestSetCraftingGrid(EntityPlayer player, IAEItemStack[] gridItems) {
        if (this.clearCraftingGrid(false)) {
            for (int craftingSlotIndex = 0; craftingSlotIndex < 9; ++craftingSlotIndex) {
                ItemStack matchingStack;
                IAEItemStack slotStack = gridItems[craftingSlotIndex];
                if (slotStack == null || (matchingStack = this.requestCraftingReplenishment(slotStack.getItemStack())) == null) continue;
                Slot slot = (Slot)this.field_75151_b.get(this.firstCraftingSlotNumber + craftingSlotIndex);
                slot.func_75215_d(matchingStack);
            }
            this.func_75142_b();
        }
    }

    public void onClientRequestAutoCraft(EntityPlayer player, IAEItemStack result) {
        TileEntity te = this.terminal.getHostTile();
        ThEGuiHandler.launchGui(80, player, te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        if (player.field_71070_bA instanceof ContainerCraftAmount) {
            ContainerCraftAmount cca = (ContainerCraftAmount)this.player.field_71070_bA;
            cca.setOpenContext(new ContainerOpenContext((Object)te));
            cca.getOpenContext().setWorld(te.func_145831_w());
            cca.getOpenContext().setX(te.field_145851_c);
            cca.getOpenContext().setY(te.field_145848_d);
            cca.getOpenContext().setZ(te.field_145849_e);
            cca.getOpenContext().setSide(this.terminal.getSide());
            cca.getCraftingItem().func_75215_d(result.getItemStack());
            cca.setItemToCraft(result);
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71137_h = false;
            }
            cca.func_75142_b();
        }
    }

    public void onClientRequestClearCraftingGrid(EntityPlayer player) {
        this.clearCraftingGrid(true);
    }

    public void onClientRequestDeposit(EntityPlayer player, int mouseButton) {
        IAEItemStack leftOverStack;
        boolean depositOne;
        if (player == null || this.monitor == null) {
            return;
        }
        ItemStack playerHolding = player.field_71071_by.func_70445_o();
        if (playerHolding == null) {
            return;
        }
        IAEItemStack toInjectStack = AEApi.instance().storage().createItemStack(playerHolding);
        boolean bl = depositOne = mouseButton == 1 || mouseButton == -2;
        if (depositOne) {
            toInjectStack.setStackSize(1L);
        }
        if ((leftOverStack = (IAEItemStack)this.monitor.injectItems((IAEStack)toInjectStack, Actionable.MODULATE, (BaseActionSource)this.playerSource)) != null && leftOverStack.getStackSize() > 0L) {
            if (toInjectStack.getStackSize() == 1L) {
                return;
            }
            player.field_71071_by.func_70437_b(leftOverStack.getItemStack());
        } else if (depositOne && playerHolding.field_77994_a > 1) {
            --playerHolding.field_77994_a;
            player.field_71071_by.func_70437_b(playerHolding);
            leftOverStack = AEApi.instance().storage().createItemStack(playerHolding);
        } else {
            player.field_71071_by.func_70437_b(null);
        }
        Packet_C_Sync.sendPlayerHeldItem(player, leftOverStack == null ? null : leftOverStack.getItemStack());
    }

    public void onClientRequestDepositRegion(EntityPlayer player, int slotNumber) {
        ArrayList<Slot> slotsToDeposit = null;
        if (this.slotClickedWasInPlayerInventory(slotNumber)) {
            slotsToDeposit = this.getNonEmptySlotsFromPlayerInventory();
        } else if (this.slotClickedWasInHotbarInventory(slotNumber)) {
            slotsToDeposit = this.getNonEmptySlotsFromHotbar();
        }
        if (slotsToDeposit != null) {
            for (Slot slot : slotsToDeposit) {
                ItemStack slotStack;
                boolean didMerge;
                if (slot == null || !slot.func_75216_d() || !(didMerge = this.mergeWithMENetwork(slotStack = slot.func_75211_c()))) continue;
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                    continue;
                }
                slot.func_75218_e();
            }
            this.func_75142_b();
        }
    }

    public void onClientRequestExtract(EntityPlayer player, IAEItemStack requestAEStack, int mouseButton, boolean isShiftHeld) {
        if (player == null || this.monitor == null || requestAEStack == null || requestAEStack.getStackSize() == 0L) {
            return;
        }
        Slot targetSlot = null;
        ItemStack cursorStack = null;
        ItemStack requestStack = requestAEStack.getItemStack();
        int amountToExtract = 0;
        switch (mouseButton) {
            case 0: {
                if (isShiftHeld) {
                    targetSlot = this.locateMergeSlot(requestStack);
                    if (targetSlot == null) break;
                    int slotRoom = 0;
                    if (targetSlot.func_75216_d()) {
                        ItemStack slotStack = targetSlot.func_75211_c();
                        slotRoom = slotStack.func_77976_d() - slotStack.field_77994_a;
                    } else {
                        slotRoom = requestStack.func_77976_d();
                    }
                    amountToExtract = Math.min(requestStack.field_77994_a, slotRoom);
                    break;
                }
                amountToExtract = Math.min(requestStack.func_77976_d(), requestStack.field_77994_a);
                break;
            }
            case 1: {
                if (isShiftHeld) {
                    amountToExtract = 1;
                    break;
                }
                double halfRequest = Math.ceil((double)requestStack.field_77994_a / 2.0);
                double halfMax = Math.ceil((double)requestStack.func_77976_d() / 2.0);
                amountToExtract = (int)Math.min(halfMax, halfRequest);
                break;
            }
            case 2: {
                if (player.field_71075_bZ.field_75098_d) {
                    requestStack.field_77994_a = requestStack.func_77976_d();
                    player.field_71071_by.func_70437_b(requestStack);
                    Packet_C_Sync.sendPlayerHeldItem(player, requestStack);
                }
                return;
            }
            case -2: {
                if (!isShiftHeld) break;
                amountToExtract = 1;
            }
        }
        if (targetSlot == null && amountToExtract > 0 && (cursorStack = player.field_71071_by.func_70445_o()) != null) {
            if (!cursorStack.func_77969_a(requestStack)) {
                return;
            }
            int cursorRoom = cursorStack.func_77976_d() - cursorStack.field_77994_a;
            amountToExtract = Math.min(cursorRoom, amountToExtract);
        }
        if (amountToExtract <= 0) {
            return;
        }
        IAEItemStack toExtract = requestAEStack.copy();
        toExtract.setStackSize((long)amountToExtract);
        IAEItemStack extractedStack = (IAEItemStack)this.monitor.extractItems((IAEStack)toExtract, Actionable.MODULATE, (BaseActionSource)this.playerSource);
        if (extractedStack != null && extractedStack.getStackSize() > 0L) {
            if (targetSlot != null) {
                if (targetSlot.func_75216_d()) {
                    targetSlot.func_75211_c().field_77994_a += (int)extractedStack.getStackSize();
                } else {
                    targetSlot.func_75215_d(extractedStack.getItemStack());
                }
            } else {
                if (cursorStack != null) {
                    cursorStack.field_77994_a += (int)extractedStack.getStackSize();
                } else {
                    this.player.field_71071_by.func_70437_b(extractedStack.getItemStack());
                }
                Packet_C_Sync.sendPlayerHeldItem(this.player, this.player.field_71071_by.func_70445_o());
            }
        }
    }

    public void onClientRequestFullUpdate(EntityPlayer player) {
        if (this.monitor != null && this.terminal.isActive()) {
            IItemList fullList = this.monitor.getStorageList();
            Packet_C_ArcaneCraftingTerminal.sendAllNetworkItems(player, (IItemList<IAEItemStack>)fullList);
        } else {
            Packet_C_ArcaneCraftingTerminal.sendAllNetworkItems(player, (IItemList<IAEItemStack>)AEApi.instance().storage().createItemList());
        }
    }

    public void onClientRequestSetSort(SortOrder order, SortDir dir, ViewItems viewMode) {
        this.terminal.setSorts(order, dir, viewMode);
    }

    public void onClientRequestSwapArmor(EntityPlayer player) {
        this.terminal.swapStoredArmor(player);
        this.func_75142_b();
        Packet_C_ArcaneCraftingTerminal.updateAspectCost(player);
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.terminal != null) {
            this.terminal.removeListener(this);
        }
        if (!player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75130_a(IInventory inventory) {
        this.requiredAspects = null;
        this.craftingCost.clear();
        this.getWand();
        ItemStack craftResult = this.findMatchingRegularResult();
        if (craftResult == null) {
            craftResult = this.findMatchingArcaneResult();
        }
        this.resultSlot.setResultAspects(this.requiredAspects);
        this.resultSlot.setWand(this.wand);
        this.terminal.setInventorySlotContentsWithoutNotify(10, craftResult);
    }

    public void onListUpdate() {
        if (!this.terminal.isActive()) {
            Packet_C_ArcaneCraftingTerminal.sendAllNetworkItems(this.player, (IItemList<IAEItemStack>)AEApi.instance().storage().createItemList());
        }
    }

    public void onViewCellChange() {
        if (this.player.field_70170_p.field_72995_K) {
            this.updateGUIViewCells();
        }
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> changes, BaseActionSource actionSource) {
        if (this.monitor == null) {
            return;
        }
        for (IAEItemStack change : changes) {
            IAEItemStack newAmount = (IAEItemStack)this.monitor.getStorageList().findPrecise((IAEStack)change);
            if (newAmount == null) {
                newAmount = change.copy();
                newAmount.setStackSize(0L);
            }
            Packet_C_ArcaneCraftingTerminal.stackAmountChanged(this.player, newAmount);
        }
    }

    public void registerForUpdates() {
        this.terminal.registerListener(this);
    }

    public ItemStack requestCraftingReplenishment(ItemStack itemStack) {
        if (this.monitor == null) {
            return null;
        }
        ItemStack replenishmentPlayer = this.takeItemFromPlayer(itemStack, 1);
        if (replenishmentPlayer != null) {
            return replenishmentPlayer;
        }
        IAEItemStack requestStack = AEApi.instance().storage().createItemStack(itemStack);
        requestStack.setStackSize(1L);
        IAEItemStack replenishmentAE = (IAEItemStack)this.monitor.extractItems((IAEStack)requestStack, Actionable.MODULATE, (BaseActionSource)this.playerSource);
        if (replenishmentAE != null) {
            return replenishmentAE.getItemStack();
        }
        IItemList networkItems = this.monitor.getStorageList();
        for (IAEItemStack potentialMatch : networkItems) {
            if (!this.doStacksMatch(requestStack, potentialMatch)) continue;
            requestStack = potentialMatch.copy();
            requestStack.setStackSize(1L);
            replenishmentAE = (IAEItemStack)this.monitor.extractItems((IAEStack)requestStack, Actionable.MODULATE, (BaseActionSource)this.playerSource);
            if (replenishmentAE == null || replenishmentAE.getStackSize() <= 0L) continue;
            return replenishmentAE.getItemStack();
        }
        return null;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (player.field_70170_p.field_72995_K) {
            return null;
        }
        Slot slot = this.getSlotOrNull(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (this.slotClickedWasInCraftingInventory(slotNumber)) {
                didMerge = this.mergeWithMENetwork(slotStack);
                if (!didMerge && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                    didMerge = this.mergeSlotWithPlayerInventory(slotStack);
                }
            } else if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (this.wandSlot.func_75214_a(slotStack)) {
                    didMerge = this.func_75135_a(slotStack, this.wandSlot.field_75222_d, this.wandSlot.field_75222_d + 1, false);
                }
                if (!(didMerge || (didMerge = this.mergeWithViewCells(slotStack)) || (didMerge = this.mergeWithMENetwork(slotStack)) || (didMerge = this.func_75135_a(slotStack, this.firstCraftingSlotNumber, this.lastCraftingSlotNumber + 1, false)))) {
                    didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            } else {
                if (slot == this.resultSlot) {
                    this.doShiftAutoCrafting(player);
                    return null;
                }
                if (slot == this.wandSlot) {
                    didMerge = this.mergeSlotWithHotbarInventory(slotStack);
                    if (!didMerge && !(didMerge = this.mergeSlotWithPlayerInventory(slotStack))) {
                        didMerge = this.mergeWithMENetwork(slotStack);
                    }
                } else if (slotNumber >= this.firstViewSlotNumber && slotNumber <= this.lastViewSlotNumber && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                    didMerge = this.mergeSlotWithPlayerInventory(slotStack);
                }
            }
            if (didMerge) {
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
            }
        }
        return null;
    }

    public class ArcaneCrafingCost {
        public final float visCost;
        public final Aspect primal;
        public final boolean hasEnoughVis;

        public ArcaneCrafingCost(float visCost, Aspect primal, boolean hasEnough) {
            this.visCost = (float)Math.round(visCost * 10.0f) / 10.0f;
            this.primal = primal;
            this.hasEnoughVis = hasEnough;
        }
    }
}

