/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container.slot;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;

public class SlotArcaneCraftingResult
extends SlotCrafting {
    private IInventory terminalInventory;
    private AspectList craftingAspects = null;
    private ItemStack wand;
    private ItemWandCasting wandItem;
    private ContainerPartArcaneCraftingTerminal hostContianer;

    public SlotArcaneCraftingResult(EntityPlayer player, ContainerPartArcaneCraftingTerminal hostContianer, IInventory terminalInventory, IInventory slotInventory, int slotIndex, int xPos, int yPos) {
        super(player, terminalInventory, slotInventory, slotIndex, xPos, yPos);
        this.terminalInventory = terminalInventory;
        this.hostContianer = hostContianer;
    }

    public void func_82870_a(EntityPlayer player, ItemStack itemStack) {
        this.onPickupFromSlotViaTransfer(player, itemStack);
        if (!player.field_70170_p.field_72995_K) {
            this.hostContianer.func_75142_b();
        }
    }

    public void onPickupFromSlotViaTransfer(EntityPlayer player, ItemStack itemStack) {
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, itemStack, this.terminalInventory);
        this.func_75208_c(itemStack);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.craftingAspects != null) {
            this.wandItem.consumeAllVisCrafting(this.wand, player, this.craftingAspects, true);
        }
        for (int slotIndex = 0; slotIndex < ContainerPartArcaneCraftingTerminal.CRAFTING_GRID_TOTAL_SIZE; ++slotIndex) {
            ItemStack replenishment;
            ItemStack slotStack = this.terminalInventory.func_70301_a(slotIndex);
            if (slotStack == null) continue;
            boolean shouldDecrement = true;
            if (slotStack.func_77973_b().hasContainerItem(slotStack)) {
                ItemStack slotContainerStack = slotStack.func_77973_b().getContainerItem(slotStack);
                if (slotContainerStack.func_77984_f() && slotContainerStack.func_77960_j() >= slotContainerStack.func_77958_k()) {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, slotContainerStack));
                    slotContainerStack = null;
                }
                if (!(slotContainerStack == null || slotStack.func_77973_b().func_77630_h(slotStack) && player.field_71071_by.func_70441_a(slotContainerStack))) {
                    this.terminalInventory.func_70299_a(slotIndex, slotContainerStack);
                    shouldDecrement = false;
                }
            }
            if (shouldDecrement && slotStack.field_77994_a == 1 && (replenishment = this.hostContianer.requestCraftingReplenishment(slotStack)) != null) {
                if (!ItemStack.func_77989_b((ItemStack)replenishment, (ItemStack)slotStack)) {
                    this.terminalInventory.func_70299_a(slotIndex, replenishment);
                }
                shouldDecrement = false;
            }
            if (!shouldDecrement) continue;
            this.terminalInventory.func_70298_a(slotIndex, 1);
        }
    }

    public void setResultAspects(AspectList aspectList) {
        this.craftingAspects = aspectList;
    }

    public void setWand(ItemStack wand) {
        if (wand != null) {
            this.wand = wand;
            this.wandItem = (ItemWandCasting)wand.func_77973_b();
        } else {
            this.wand = null;
            this.wandItem = null;
        }
    }
}

