/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration;

import appeng.api.config.Upgrades;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.integration.ModuleCC;
import thaumicenergistics.common.integration.ModuleEC2;
import thaumicenergistics.common.integration.ModuleNEI;
import thaumicenergistics.common.integration.ModuleWaila;
import thaumicenergistics.common.tiles.TileEssentiaProvider;
import thaumicenergistics.common.utils.EffectiveSide;
import thaumicenergistics.common.utils.ThELog;

public final class IntegrationCore {
    private static final String MODID_WAILA = "Waila";
    private static final String MODID_NEI = "NEI";
    private static final String MODID_EC2 = "EC2";
    private static final String MODID_CC = "CC";

    @SideOnly(value=Side.CLIENT)
    private static void integrateWithClientMods() {
        IntegrationCore.integrateWithMod(MODID_NEI);
        IntegrationCore.integrateWithMod(MODID_WAILA);
    }

    private static void integrateWithMod(String modID) {
        try {
            switch (modID) {
                case "Waila": {
                    if (Loader.isModLoaded((String)MODID_WAILA)) {
                        new ModuleWaila();
                        break;
                    }
                    ThELog.info("Skipping integration with %s", modID);
                    break;
                }
                case "NEI": {
                    if (Loader.isModLoaded((String)"NotEnoughItems")) {
                        new ModuleNEI();
                        break;
                    }
                    ThELog.info("Skipping integration with %s", modID);
                    break;
                }
                case "EC2": {
                    if (Loader.isModLoaded((String)"extracells")) {
                        new ModuleEC2();
                        break;
                    }
                    ThELog.info("Skipping integration with %s", modID);
                    break;
                }
                case "CC": {
                    if (Loader.isModLoaded((String)"computercraft")) {
                        new ModuleCC();
                        break;
                    }
                    ThELog.info("Skipping integration with %s", modID);
                    break;
                }
                default: {
                    ThELog.info("Skipping integration with %s", modID);
                }
            }
            ThELog.info("Successfully integrated with %s", modID);
        }
        catch (Throwable e) {
            ThELog.info("Skipping integration with %s", modID);
        }
    }

    public static void init() {
        long startTime = ThELog.beginSection("Integration");
        try {
            if (EffectiveSide.isClientSide()) {
                IntegrationCore.integrateWithClientMods();
            }
            if (ThEApi.instance().config().blacklistEssentiaFluidInExtraCells()) {
                IntegrationCore.integrateWithMod(MODID_EC2);
            }
            IntegrationCore.integrateWithMod(MODID_CC);
            FMLInterModComms.sendMessage((String)"ThaumicTinkerer", (String)"AddCCBlacklist", (String)TileEssentiaProvider.class.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Upgrades.SPEED.registerItem(ThEApi.instance().blocks().ArcaneAssembler.getStack(), 4);
        ThELog.endSection("Integration", startTime);
    }
}

