/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.inventory;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.AEConfig;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.api.IThEWirelessEssentiaTerminal;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.grid.ICraftingIssuerHost;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.common.grid.EssentiaPassThroughMonitor;
import thaumicenergistics.common.grid.WirelessAELink;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.items.ItemWirelessEssentiaTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_ChangeGui;
import thaumicenergistics.common.registries.EnumCache;
import thaumicenergistics.common.storage.AspectStackComparator;

public class HandlerWirelessEssentiaTerminal
extends WirelessAELink
implements IActionHost,
ICraftingIssuerHost,
IGuiItemObject {
    private static final String NBT_KEY_SORTING_MODE = "SortingMode2";
    private static final String NBT_KEY_VIEW_MODE = "ViewMode";
    private final IThEWirelessEssentiaTerminal wirelessTerminal;
    private final ItemStack wirelessItemstack;
    private double wirelessPowerMultiplier = 1.0;

    public HandlerWirelessEssentiaTerminal(EntityPlayer player, String encryptionKey, IThEWirelessEssentiaTerminal wirelessTerminalInterface, ItemStack wirelessTerminalItemstack) {
        super(player, encryptionKey);
        this.wirelessTerminal = wirelessTerminalInterface;
        this.wirelessItemstack = wirelessTerminalItemstack;
    }

    public static boolean isTerminalLinked(IThEWirelessEssentiaTerminal wirelessTerminal, ItemStack wirelessTerminalItemstack) {
        return !wirelessTerminal.getEncryptionKey(wirelessTerminalItemstack).isEmpty();
    }

    @Override
    protected int getUserPositionX() {
        return (int)this.player.field_70165_t;
    }

    @Override
    protected int getUserPositionY() {
        return (int)this.player.field_70163_u;
    }

    @Override
    protected int getUserPositionZ() {
        return (int)this.player.field_70161_v;
    }

    @Override
    protected World getUserWorld() {
        return this.player.field_70170_p;
    }

    public double extractPower(double amount, Actionable mode) {
        if (ItemWirelessEssentiaTerminal.GLOBAL_POWER_MULTIPLIER == 0.0) {
            return amount;
        }
        double adjustedAmount = amount * this.wirelessPowerMultiplier;
        double extractedAmount = 0.0;
        extractedAmount = mode == Actionable.SIMULATE ? Math.min(this.wirelessTerminal.getAECurrentPower(this.wirelessItemstack), adjustedAmount) : this.wirelessTerminal.extractAEPower(this.wirelessItemstack, adjustedAmount);
        return extractedAmount /= this.wirelessPowerMultiplier;
    }

    public IGridNode getActionableNode() {
        if (this.accessPoint != null) {
            return this.accessPoint.getActionableNode();
        }
        return null;
    }

    public BaseActionSource getActionHost() {
        return this.actionSource;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.NONE;
    }

    public IConfigManager getConfigManager() {
        return null;
    }

    @Override
    public IMEEssentiaMonitor getEssentiaInventory() {
        IMEEssentiaMonitor essMonitor = super.getEssentiaInventory();
        if (essMonitor == null) {
            return null;
        }
        PowerRedirector pr = new PowerRedirector();
        EssentiaPassThroughMonitor monitor = new EssentiaPassThroughMonitor(essMonitor, pr);
        return monitor;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.getActionableNode();
    }

    @Override
    public ItemStack getIcon() {
        return ItemEnum.WIRELESS_TERMINAL.getStack();
    }

    public ItemStack getItemStack() {
        return this.wirelessItemstack;
    }

    public AspectStackComparator.AspectStackComparatorMode getSortingMode() {
        NBTTagCompound dataTagCompound = this.wirelessTerminal.getWETerminalTag(this.wirelessItemstack);
        if (dataTagCompound.func_74764_b(NBT_KEY_SORTING_MODE)) {
            return AspectStackComparator.AspectStackComparatorMode.VALUES[dataTagCompound.func_74762_e(NBT_KEY_SORTING_MODE)];
        }
        return AspectStackComparator.AspectStackComparatorMode.MODE_ALPHABETIC;
    }

    public ItemStack getTerminalItem() {
        return this.wirelessItemstack;
    }

    public ViewItems getViewMode() {
        NBTTagCompound dataTagCompound = this.wirelessTerminal.getWETerminalTag(this.wirelessItemstack);
        if (dataTagCompound.func_74764_b(NBT_KEY_VIEW_MODE)) {
            return EnumCache.AE_VIEW_ITEMS[dataTagCompound.func_74762_e(NBT_KEY_VIEW_MODE)];
        }
        return ViewItems.ALL;
    }

    @Override
    public boolean hasPowerToCommunicate() {
        return this.wirelessTerminal.getAECurrentPower(this.wirelessItemstack) > 0.0;
    }

    @Override
    public void launchGUI(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            Packet_S_ChangeGui.sendGuiChangeToWirelessTerminal(player);
        } else {
            ThEApi.instance().interact().openWirelessTerminalGui(player);
        }
    }

    public void securityBreak() {
    }

    public void setSortingMode(AspectStackComparator.AspectStackComparatorMode mode) {
        NBTTagCompound dataTag = this.wirelessTerminal.getWETerminalTag(this.wirelessItemstack);
        dataTag.func_74768_a(NBT_KEY_SORTING_MODE, mode.ordinal());
    }

    public void setViewMode(ViewItems viewMode) {
        NBTTagCompound dataTag = this.wirelessTerminal.getWETerminalTag(this.wirelessItemstack);
        dataTag.func_74768_a(NBT_KEY_VIEW_MODE, viewMode.ordinal());
    }

    public void updatePowerMultiplier() {
        double distance = WirelessAELink.getSquaredDistanceFromAP(this.apLocation, this.getUserPositionX(), this.getUserPositionY(), this.getUserPositionZ());
        distance = Math.sqrt(distance);
        this.wirelessPowerMultiplier = AEConfig.instance.wireless_getDrainRate(distance);
    }

    private class PowerRedirector
    implements IEnergyGrid {
        public void addNode(IGridNode gridNode, IGridHost machine) {
        }

        public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
            return HandlerWirelessEssentiaTerminal.this.extractPower(amt, mode);
        }

        public double extractAEPower(double amt, Actionable mode, Set<IEnergyGrid> seen) {
            return HandlerWirelessEssentiaTerminal.this.extractPower(amt, mode);
        }

        public double getAvgPowerInjection() {
            return 0.0;
        }

        public double getAvgPowerUsage() {
            return 0.0;
        }

        public double getEnergyDemand(double maxRequired) {
            return 0.0;
        }

        public double getEnergyDemand(double d, Set<IEnergyGrid> seen) {
            return 0.0;
        }

        public double getIdlePowerUsage() {
            return 0.0;
        }

        public double getMaxStoredPower() {
            return 0.0;
        }

        public double getStoredPower() {
            return 0.0;
        }

        public double injectAEPower(double amt, Actionable mode, Set<IEnergyGrid> seen) {
            return amt;
        }

        public double injectPower(double amt, Actionable mode) {
            return amt;
        }

        public boolean isNetworkPowered() {
            return true;
        }

        public void onJoin(IGridStorage sourceStorage) {
        }

        public void onSplit(IGridStorage destinationStorage) {
        }

        public void onUpdateTick() {
        }

        public void populateGridStorage(IGridStorage destinationStorage) {
        }

        public void removeNode(IGridNode gridNode, IGridHost machine) {
        }
    }
}

