/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.ThEBasePacket;
import thaumicenergistics.common.network.packet.server.ThEServerPacket;
import thaumicenergistics.common.parts.ThEPartBase;

public class Packet_S_ChangeGui
extends ThEServerPacket {
    private static final byte MODE_REGULAR = 0;
    private static final byte MODE_PART = 1;
    private static final byte MODE_WIRELESS = 2;
    private int guiID;
    private ThEPartBase part;
    private World world;
    private int x;
    private int y;
    private int z;

    private static Packet_S_ChangeGui newPacket(EntityPlayer player, byte mode) {
        Packet_S_ChangeGui packet = new Packet_S_ChangeGui();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendGuiChange(int guiID, EntityPlayer player, World world, int x, int y, int z) {
        Packet_S_ChangeGui packet = Packet_S_ChangeGui.newPacket(player, (byte)0);
        packet.guiID = guiID;
        packet.world = world;
        packet.x = x;
        packet.y = y;
        packet.z = z;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendGuiChangeToPart(ThEPartBase part, EntityPlayer player, World world, int x, int y, int z) {
        Packet_S_ChangeGui packet = Packet_S_ChangeGui.newPacket(player, (byte)1);
        packet.part = part;
        packet.world = world;
        packet.x = x;
        packet.y = y;
        packet.z = z;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendGuiChangeToWirelessTerminal(EntityPlayer player) {
        Packet_S_ChangeGui packet = Packet_S_ChangeGui.newPacket(player, (byte)2);
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                ThEGuiHandler.launchGui(this.guiID, this.player, this.world, this.x, this.y, this.z);
                break;
            }
            case 1: {
                ThEGuiHandler.launchGui(this.part, this.player, this.world, this.x, this.y, this.z);
                break;
            }
            case 2: {
                ThEApi.instance().interact().openWirelessTerminalGui(this.player);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        if (this.mode != 2) {
            if (this.mode == 0) {
                this.guiID = stream.readInt();
            } else if (this.mode == 1) {
                this.part = ThEBasePacket.readPart(stream);
            }
            this.world = ThEBasePacket.readWorld(stream);
            this.x = stream.readInt();
            this.y = stream.readInt();
            this.z = stream.readInt();
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        if (this.mode != 2 && Minecraft.func_71410_x().func_71356_B()) {
            if (this.mode == 0) {
                stream.writeInt(this.guiID);
            } else if (this.mode == 1) {
                ThEBasePacket.writePart(this.part, stream);
            }
            ThEBasePacket.writeWorld(this.world, stream);
            stream.writeInt(this.x);
            stream.writeInt(this.y);
            stream.writeInt(this.z);
        }
    }
}

