/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.ThEBasePacket;
import thaumicenergistics.common.network.packet.server.ThEServerPacket;
import thaumicenergistics.common.parts.PartEssentiaLevelEmitter;

public class Packet_S_EssentiaEmitter
extends ThEServerPacket {
    private static final byte MODE_SEND_WANTED = 1;
    private static final byte MODE_ADJUST_WANTED = 2;
    private static final byte MODE_TOGGLE_REDSTONE = 3;
    private PartEssentiaLevelEmitter part;
    private long wantedAmount;
    private int adjustmentAmount;

    private static Packet_S_EssentiaEmitter newPacket(EntityPlayer player, byte mode) {
        Packet_S_EssentiaEmitter packet = new Packet_S_EssentiaEmitter();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendRedstoneModeToggle(PartEssentiaLevelEmitter part, EntityPlayer player) {
        Packet_S_EssentiaEmitter packet = Packet_S_EssentiaEmitter.newPacket(player, (byte)3);
        packet.part = part;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendWantedAmount(long wantedAmount, PartEssentiaLevelEmitter part, EntityPlayer player) {
        Packet_S_EssentiaEmitter packet = Packet_S_EssentiaEmitter.newPacket(player, (byte)1);
        packet.part = part;
        packet.wantedAmount = wantedAmount;
        NetworkHandler.sendPacketToServer(packet);
    }

    public static void sendWantedAmountDelta(int adjustmentAmount, PartEssentiaLevelEmitter part, EntityPlayer player) {
        Packet_S_EssentiaEmitter packet = Packet_S_EssentiaEmitter.newPacket(player, (byte)2);
        packet.part = part;
        packet.adjustmentAmount = adjustmentAmount;
        NetworkHandler.sendPacketToServer(packet);
    }

    @Override
    public void execute() {
        if (this.part == null) {
            return;
        }
        switch (this.mode) {
            case 1: {
                this.part.onSetThresholdLevel(this.wantedAmount, this.player);
                break;
            }
            case 2: {
                this.part.onAdjustThresholdLevel(this.adjustmentAmount, this.player);
                break;
            }
            case 3: {
                this.part.onClientToggleRedstoneMode(this.player);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 3: {
                this.part = (PartEssentiaLevelEmitter)ThEBasePacket.readPart(stream);
                break;
            }
            case 1: {
                this.part = (PartEssentiaLevelEmitter)ThEBasePacket.readPart(stream);
                this.wantedAmount = stream.readLong();
                break;
            }
            case 2: {
                this.part = (PartEssentiaLevelEmitter)ThEBasePacket.readPart(stream);
                this.adjustmentAmount = stream.readInt();
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 3: {
                if (!Minecraft.func_71410_x().func_71356_B()) break;
                ThEBasePacket.writePart(this.part, stream);
                break;
            }
            case 1: {
                if (Minecraft.func_71410_x().func_71356_B()) {
                    ThEBasePacket.writePart(this.part, stream);
                }
                stream.writeLong(this.wantedAmount);
                break;
            }
            case 2: {
                if (Minecraft.func_71410_x().func_71356_B()) {
                    ThEBasePacket.writePart(this.part, stream);
                }
                stream.writeInt(this.adjustmentAmount);
            }
        }
    }
}

