/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.yggdrasil.CompatProfile;
import java.util.UUID;
import pro.gravit.launcher.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUsernameRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.uuid.BatchProfileByUsernameRequest;
import pro.gravit.launcher.request.uuid.ProfileByUUIDRequest;
import pro.gravit.launcher.request.uuid.ProfileByUsernameRequest;
import pro.gravit.utils.helper.LogHelper;

public class CompatBridge {
    public static final int PROFILES_MAX_BATCH_SIZE = 128;

    private CompatBridge() {
    }

    public static CompatProfile checkServer(String username, String serverID) throws Exception {
        LogHelper.debug((String)"CompatBridge.checkServer, Username: '%s', Server ID: %s", (Object[])new Object[]{username, serverID});
        return CompatProfile.fromPlayerProfile(((CheckServerRequestEvent)new CheckServerRequest((String)username, (String)serverID).request()).playerProfile);
    }

    public static boolean joinServer(String username, String accessToken, String serverID) throws Exception {
        LogHelper.debug((String)"LegacyBridge.joinServer, Username: '%s', Access token: %s, Server ID: %s", (Object[])new Object[]{username, accessToken, serverID});
        return ((JoinServerRequestEvent)new JoinServerRequest((String)username, (String)accessToken, (String)serverID).request()).allow;
    }

    public static CompatProfile profileByUsername(String username) throws Exception {
        return CompatProfile.fromPlayerProfile(((ProfileByUsernameRequestEvent)new ProfileByUsernameRequest((String)username).request()).playerProfile);
    }

    public static CompatProfile profileByUUID(UUID uuid) throws Exception {
        return CompatProfile.fromPlayerProfile(((ProfileByUUIDRequestEvent)new ProfileByUUIDRequest((UUID)uuid).request()).playerProfile);
    }

    public static CompatProfile[] profilesByUsername(String ... usernames) throws Exception {
        PlayerProfile[] profiles = ((BatchProfileByUsernameRequestEvent)new BatchProfileByUsernameRequest((String[])usernames).request()).playerProfiles;
        CompatProfile[] resultProfiles = new CompatProfile[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            resultProfiles[i] = CompatProfile.fromPlayerProfile(profiles[i]);
        }
        return resultProfiles;
    }
}

