/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import java.util.UUID;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.utils.helper.SecurityHelper;

public class CompatProfile {
    public static final String SKIN_URL_PROPERTY = "skinURL";
    public static final String SKIN_DIGEST_PROPERTY = "skinDigest";
    public static final String CLOAK_URL_PROPERTY = "cloakURL";
    public static final String CLOAK_DIGEST_PROPERTY = "cloakDigest";
    public final UUID uuid;
    public final String uuidHash;
    public final String username;
    public final String skinURL;
    public final String skinDigest;
    public final String cloakURL;
    public final String cloakDigest;

    public CompatProfile(UUID uuid, String username, String skinURL, String skinDigest, String cloakURL, String cloakDigest) {
        this.uuid = uuid;
        this.uuidHash = Launcher.toHash((UUID)uuid);
        this.username = username;
        this.skinURL = skinURL;
        this.skinDigest = skinDigest;
        this.cloakURL = cloakURL;
        this.cloakDigest = cloakDigest;
    }

    public static CompatProfile fromPlayerProfile(PlayerProfile profile) {
        return profile == null ? null : new CompatProfile(profile.uuid, profile.username, profile.skin == null ? null : profile.skin.url, profile.skin == null ? null : SecurityHelper.toHex((byte[])profile.skin.digest), profile.cloak == null ? null : profile.cloak.url, profile.cloak == null ? null : SecurityHelper.toHex((byte[])profile.cloak.digest));
    }

    public int countProperties() {
        int count = 0;
        if (this.skinURL != null) {
            ++count;
        }
        if (this.skinDigest != null) {
            ++count;
        }
        if (this.cloakURL != null) {
            ++count;
        }
        if (this.cloakDigest != null) {
            ++count;
        }
        return count;
    }
}

