/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.PluginChannelListener;
import com.mumfrey.liteloader.ServerCommandProvider;
import com.mumfrey.liteloader.ServerPlayerListener;
import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.CommonPluginChannelListener;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import net.minecraft.server.MinecraftServer;

public abstract class Events<TClient, TServer extends MinecraftServer>
implements InterfaceProvider,
bqz {
    protected final LiteLoader loader;
    protected final GameEngine<TClient, TServer> engine;
    protected final qi profiler;
    protected LiteLoaderMods mods;
    private FastIterable<ServerCommandProvider> serverCommandProviders = new HandlerList<ServerCommandProvider>(ServerCommandProvider.class);
    private FastIterable<ServerPlayerListener> serverPlayerListeners = new HandlerList<ServerPlayerListener>(ServerPlayerListener.class);

    public Events(LiteLoader loader, GameEngine<TClient, TServer> engine, LoaderProperties properties) {
        this.loader = loader;
        this.engine = engine;
        this.profiler = engine.getProfiler();
    }

    void setMods(LiteLoaderMods mods) {
        this.mods = mods;
    }

    protected void onStartupComplete() {
        LoadingProgress.setMessage("Checking mods...");
        this.mods.onStartupComplete();
        LoadingProgress.setMessage("Initialising CoreProviders...");
        this.loader.onStartupComplete();
        LoadingProgress.setMessage("Starting Game...");
    }

    @Deprecated
    public void addListener(LiteMod listener) {
        LiteLoader.getInterfaceManager().registerListener(listener);
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return LiteMod.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(ServerCommandProvider.class);
        delegate.registerInterface(ServerPlayerListener.class);
        delegate.registerInterface(CommonPluginChannelListener.class);
    }

    public void addCommonPluginChannelListener(CommonPluginChannelListener listener) {
        if (!(listener instanceof PluginChannelListener) && !(listener instanceof ServerPluginChannelListener)) {
            LiteLoaderLogger.warning("Interface error for mod '%1s'. Implementing CommonPluginChannelListener has no effect! Use PluginChannelListener or ServerPluginChannelListener instead", listener.getName());
        }
    }

    public void addServerCommandProvider(ServerCommandProvider serverCommandProvider) {
        this.serverCommandProviders.add(serverCommandProvider);
    }

    public void addServerPlayerListener(ServerPlayerListener serverPlayerListener) {
        this.serverPlayerListeners.add(serverPlayerListener);
    }

    public void a(bqy resourceManager) {
        LoadingProgress.setMessage("Reloading Resources...");
    }

    public void onStartServer(MinecraftServer instance, String folderName, String worldName, ahj worldSettings) {
        ab commandManager = instance.J();
        if (commandManager instanceof bl) {
            bl serverCommandManager = (bl)commandManager;
            this.serverCommandProviders.all().provideCommands(serverCommandManager);
        }
        LiteLoader.getServerPluginChannels().onServerStartup();
    }

    public void onSpawnPlayer(oi scm, mw player, GameProfile profile) {
        this.serverPlayerListeners.all().onPlayerConnect(player, profile);
    }

    public void onPlayerLogin(oi scm, mw player) {
        LiteLoader.getServerPluginChannels().onPlayerJoined(player);
    }

    public void onInitializePlayerConnection(oi scm, ej netManager, mw player) {
        this.serverPlayerListeners.all().onPlayerLoggedIn(player);
    }

    public void onRespawnPlayer(oi scm, mw player, mw oldPlayer, int dimension, boolean won) {
        this.serverPlayerListeners.all().onPlayerRespawn(player, oldPlayer, dimension, won);
    }

    public void onPlayerLogout(oi scm, mw player) {
        this.serverPlayerListeners.all().onPlayerLogout(player);
    }

    protected void onTick(boolean clock, float partialTicks, boolean inGame) {
        this.loader.onTick(clock, partialTicks, inGame);
    }

    protected void onPostRender(int mouseX, int mouseY, float partialTicks) {
        this.loader.onPostRender(mouseX, mouseY, partialTicks);
    }

    protected void onWorldChanged(ahb world) {
        this.loader.onWorldChanged(world);
    }

    @Deprecated
    public void addChatFilter(Object chatFilter) {
    }

    @Deprecated
    public void addTickListener(Object tickListener) {
    }
}

