/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.InterfaceDependancies;
import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.ASMInit;
import codechicken.lib.asm.ObfMapping;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class InterfaceDependancyTransformer
implements IClassTransformer {
    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode cnode = ASMHelper.createClassNode((byte[])bytes, (int)7);
        boolean hasDependancyInterfaces = false;
        if (cnode.visibleAnnotations != null) {
            for (AnnotationNode ann : cnode.visibleAnnotations) {
                if (!ann.desc.equals(Type.getDescriptor(InterfaceDependancies.class))) continue;
                hasDependancyInterfaces = true;
                break;
            }
        }
        if (!hasDependancyInterfaces) {
            return bytes;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String iface : cnode.interfaces) {
            try {
                Launch.classLoader.findClass(new ObfMapping(iface).toRuntime().javaClass());
            }
            catch (ClassNotFoundException cnfe) {
                toRemove.add(iface);
            }
        }
        if (toRemove.isEmpty()) {
            return bytes;
        }
        cnode = ASMHelper.createClassNode((byte[])bytes);
        cnode.interfaces.removeAll(toRemove);
        return ASMHelper.createBytes((ClassNode)cnode, (int)0);
    }

    static {
        ASMInit.init();
    }
}

