/*
 * Decompiled with CFR 0.152.
 */
package codechicken.obfuscator;

import codechicken.core.launch.CodeChickenCorePlugin;
import codechicken.obfuscator.ConstantObfuscator;
import codechicken.obfuscator.DummyOutputStream;
import codechicken.obfuscator.ILogStreams;
import codechicken.obfuscator.ObfDirection;
import codechicken.obfuscator.ObfRemapper;
import codechicken.obfuscator.ObfuscationMap;
import com.google.common.base.Function;
import java.io.File;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.ClassNode;

public class ObfuscationRun
implements ILogStreams {
    public final ObfDirection obfDir;
    public final ObfuscationMap obf;
    public final ObfRemapper obfMapper;
    public final ConstantObfuscator cstMappper;
    public File[] mappings;
    public Map<String, String> config;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private PrintStream quietStream = new PrintStream(DummyOutputStream.instance);
    private boolean verbose;
    private boolean quiet;
    public boolean clean;
    private long startTime;
    private boolean finished;

    public ObfuscationRun(boolean obfuscate, File[] mappings, Map<String, String> config) {
        this.obfDir = new ObfDirection().setObfuscate(obfuscate);
        this.mappings = mappings;
        this.config = config;
        this.obf = new ObfuscationMap().setLog(this);
        this.obfMapper = new ObfRemapper(this.obf, this.obfDir);
        this.cstMappper = new ConstantObfuscator(this.obfMapper, config.get("classConstantCalls").split(","), config.get("descConstantCalls").split(","));
    }

    public ObfuscationRun setClean() {
        this.clean = true;
        return this;
    }

    public ObfuscationRun setVerbose() {
        this.verbose = true;
        return this;
    }

    public ObfuscationRun setQuiet() {
        this.quiet = true;
        return this;
    }

    public ObfuscationRun setOut(PrintStream p) {
        this.out = p;
        return this;
    }

    @Override
    public PrintStream out() {
        return this.quiet ? this.quietStream : this.out;
    }

    public PrintStream fine() {
        return this.verbose ? this.out : this.quietStream;
    }

    public ObfuscationRun setErr(PrintStream p) {
        this.err = p;
        return this;
    }

    @Override
    public PrintStream err() {
        return this.quiet ? this.quietStream : this.err;
    }

    public ObfuscationRun setSearge() {
        this.obfDir.setSearge(true);
        return this;
    }

    public ObfuscationRun setSeargeConstants() {
        this.obfDir.setSeargeConstants(true);
        return this;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public static Map<String, String> fillDefaults(Map<String, String> config) {
        if (!config.containsKey("excludedPackages")) {
            config.put("excludedPackages", "java/;sun/;javax/;scala/;argo/;org/lwjgl/;org/objectweb/;org/bouncycastle/;com/google/");
        }
        if (!config.containsKey("ignore")) {
            config.put("ignore", ".");
        }
        if (!config.containsKey("classConstantCalls")) {
            config.put("classConstantCalls", "codechicken/lib/asm/ObfMapping.<init>(Ljava/lang/String;)V,codechicken/lib/asm/ObfMapping.subclass(Ljava/lang/String;)Lcodechicken/lib/asm/ObfMapping;,codechicken/lib/asm/ObfMapping.<init>(Lcodechicken/lib/asm/ObfMapping;Ljava/lang/String;)V");
        }
        if (!config.containsKey("descConstantCalls")) {
            config.put("descConstantCalls", "codechicken/lib/asm/ObfMapping.<init>(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V,org/objectweb/asm/MethodVisitor.visitFieldInsn(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V,org/objectweb/asm/tree/MethodNode.visitFieldInsn(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V,org/objectweb/asm/MethodVisitor.visitMethodInsn(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V,org/objectweb/asm/tree/MethodNode.visitMethodInsn(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V,org/objectweb/asm/tree/MethodInsnNode.<init>(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V,org/objectweb/asm/tree/FieldInsnNode.<init>(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        }
        return config;
    }

    public static void processLines(File file, Function<String, Void> function) {
        CodeChickenCorePlugin.logger.warn("[ObfuscationRun:processLines] Attempt to call a method for a file \"" + file.getAbsolutePath() + "\"!");
    }

    public static void processFiles(File dir, Function<File, Void> function, boolean recursive) {
        CodeChickenCorePlugin.logger.warn("[ObfuscationRun:processFiles] Attempt to " + (recursive ? "recursive " : "") + "process a method with directory argument \"" + dir.getAbsolutePath() + "\"!");
    }

    public static void deleteDir(File directory, boolean remove) {
        CodeChickenCorePlugin.logger.warn("[ObfuscationRun:deleteDir] Attempt to " + (remove ? "remove" : "create") + " directory \"" + directory.getAbsolutePath() + "\" !");
    }

    public static File[] parseConfDir(File confDir) {
        CodeChickenCorePlugin.logger.warn("[ObfuscationRun:parseConfDir] Attempt to parse config directory \"" + confDir.getAbsolutePath() + "\"");
        return new File[0];
    }

    public long startTime() {
        return this.startTime;
    }

    public void remap(ClassNode cnode, ClassVisitor cv) {
        this.cstMappper.transform(cnode);
        cnode.accept((ClassVisitor)new RemappingClassAdapter(cv, (Remapper)this.obfMapper));
    }

    public static List<String> getParents(ClassNode cnode) {
        LinkedList<String> parents = new LinkedList<String>();
        if (cnode.superName != null) {
            parents.add(cnode.superName);
        }
        for (String s_interface : cnode.interfaces) {
            parents.add(s_interface);
        }
        return parents;
    }

    public void finish(boolean errored) {
        long millis = System.currentTimeMillis() - this.startTime;
        this.out().println((errored ? "Errored after" : "Done in ") + new DecimalFormat("0.00").format((double)millis / 1000.0) + "s");
        this.finished = true;
    }

    public boolean finished() {
        return this.finished;
    }

    public void parseMappings() {
        this.obf.parseMappings(this.mappings);
    }
}

