/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world;

import codechicken.lib.world.ChunkExtension;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class WorldExtension {
    public final World world;
    public Map<Chunk, ChunkExtension> chunkMap = new WeakHashMap<Chunk, ChunkExtension>();

    public WorldExtension(World world) {
        this.world = world;
    }

    public void load() {
    }

    public void unload() {
    }

    public void save() {
    }

    public void preTick() {
    }

    public void postTick() {
    }

    protected final void addChunk(ChunkExtension extension) {
        this.chunkMap.put(extension.chunk, extension);
    }

    protected final void loadChunk(Chunk chunk) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.load();
        }
    }

    protected final void unloadChunk(Chunk chunk) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.unload();
        }
    }

    protected final void loadChunkData(Chunk chunk, NBTTagCompound tag) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.loadData(tag);
        }
    }

    protected final void saveChunkData(Chunk chunk, NBTTagCompound tag) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.saveData(tag);
        }
    }

    protected final void remChunk(Chunk chunk) {
        this.chunkMap.remove(chunk);
    }

    protected final void watchChunk(Chunk chunk, EntityPlayerMP player) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.watchPlayer(player);
        }
    }

    protected final void unwatchChunk(Chunk chunk, EntityPlayerMP player) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.unwatchPlayer(player);
        }
    }

    protected final void sendChunkUpdates(Chunk chunk) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.sendUpdatePackets();
        }
    }

    public boolean containsChunk(Chunk chunk) {
        return this.chunkMap.containsKey(chunk);
    }

    public ChunkExtension getChunkExtension(int chunkXPos, int chunkZPos) {
        if (!this.world.func_72899_e(chunkXPos << 4, 128, chunkZPos << 4)) {
            return null;
        }
        Chunk chunk = this.world.func_72964_e(chunkXPos, chunkZPos);
        return chunk != null ? this.chunkMap.get(chunk) : null;
    }
}

