/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.tabmod.client.gui;

import com.gamerforea.tabmod.TabMod;
import com.gamerforea.tabmod.util.PlayerData;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiPlayerTabOverlay
extends Gui {
    private static final boolean FORCE_DRAW_HEADS = true;
    private static final Ordering ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private final Minecraft mc = Minecraft.func_71410_x();

    public void renderPlayerlist(int width) {
        int columnWidth;
        ScoreObjective scoreObjective = this.mc.field_71441_e.func_96441_U().func_96539_a(0);
        NetHandlerPlayClient handler = this.mc.field_71439_g.field_71174_a;
        List list = ENTRY_ORDERING.sortedCopy((Iterable)Lists.transform((List)handler.field_147303_b, (Function)new Function(){

            public Object apply(Object input) {
                return new ExtendedPlayerInfo((GuiPlayerInfo)input);
            }
        }));
        int maxPlayers = Math.min(80, Math.min(list.size(), handler.field_147304_c));
        if (list.size() > maxPlayers) {
            list = list.subList(0, maxPlayers);
        }
        int maxNameWidth = 0;
        int maxScoreWidth = 0;
        for (ExtendedPlayerInfo playerInfo : list) {
            int nameWidth = this.mc.field_71466_p.func_78256_a(playerInfo.getDisplayName());
            System.out.println("[Display]" + playerInfo.playerName);
            System.out.println("[Name]" + playerInfo.displayName);
            maxNameWidth = Math.max(maxNameWidth, nameWidth);
            if (scoreObjective == null) continue;
            columnWidth = this.mc.field_71466_p.func_78256_a(" " + playerInfo.getScore(scoreObjective).func_96652_c());
            maxScoreWidth = Math.max(maxScoreWidth, columnWidth);
        }
        int rows = maxPlayers;
        int columns = 1;
        while (rows > 20) {
            rows = (maxPlayers + ++columns - 1) / columns;
        }
        boolean drawHeads = true;
        columnWidth = Math.min(columns * ((drawHeads ? 9 : 0) + maxNameWidth + maxScoreWidth + 13), width - 50) / columns;
        int left = width / 2 - (columnWidth * columns + (columns - 1) * 5) / 2;
        int border = 10;
        int l1 = columnWidth * columns + (columns - 1) * 5;
        GuiPlayerTabOverlay.func_73734_a((int)(width / 2 - l1 / 2 - 1), (int)(border - 1), (int)(width / 2 + l1 / 2 + 1), (int)(border + rows * 9), (int)Integer.MIN_VALUE);
        for (int playerIndex = 0; playerIndex < maxPlayers; ++playerIndex) {
            int k5;
            int l5;
            int row = playerIndex / rows;
            int column = playerIndex % rows;
            int x = left + row * columnWidth + row * 5;
            int y = border + column * 9;
            GuiPlayerTabOverlay.func_73734_a((int)x, (int)y, (int)(x + columnWidth), (int)(y + 8), (int)0x20FFFFFF);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            ExtendedPlayerInfo playerInfo = (ExtendedPlayerInfo)list.get(playerIndex);
            if (playerInfo == null || playerInfo.playerData == null) continue;
            if (drawHeads && TabMod.skinHolder.bindSkin(playerInfo.playerData.gameProfile.getName())) {
                Gui.func_152125_a((int)x, (int)y, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)32.0f);
                x += 9;
            }
            String displayName = playerInfo.getDisplayName();
            this.mc.field_71466_p.func_78261_a(displayName, x, y, -1);
            if (scoreObjective != null && (l5 = (k5 = x + maxNameWidth + 1) + maxScoreWidth) - k5 > 5) {
                this.drawScoreboardValues(scoreObjective, y, displayName, k5, l5, playerInfo);
            }
            this.drawPing(columnWidth, x - (drawHeads ? 9 : 0), y, playerInfo);
        }
    }

    private void drawPing(int p_175245_1_, int p_175245_2_, int p_175245_3_, ExtendedPlayerInfo playerInfo) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        int responseTime = playerInfo.playerInfo.field_78829_b;
        int index = responseTime < 0 ? 5 : (responseTime < 150 ? 0 : (responseTime < 300 ? 1 : (responseTime < 600 ? 2 : (responseTime < 1000 ? 3 : 4))));
        this.field_73735_i += 100.0f;
        this.func_73729_b(p_175245_2_ + p_175245_1_ - 11, p_175245_3_, 0, 176 + index * 8, 10, 8);
        this.field_73735_i -= 100.0f;
    }

    private void drawScoreboardValues(ScoreObjective scoreObjective, int value, String name, int p_175247_4_, int p_175247_5_, ExtendedPlayerInfo info) {
        int points = info.getScore(scoreObjective).func_96652_c();
        String s = EnumChatFormatting.YELLOW.toString() + points;
        this.mc.field_71466_p.func_78261_a(s, p_175247_5_ - this.mc.field_71466_p.func_78256_a(s), value, 0xFFFFFF);
    }

    private ResourceLocation getLocationSkin(ExtendedPlayerInfo playerInfo) {
        if (playerInfo == null) {
            return AbstractClientPlayer.field_110314_b;
        }
        String playerName = playerInfo.playerData.tabName;
        if (playerName.isEmpty()) {
            return AbstractClientPlayer.field_110314_b;
        }
        return playerInfo.playerData.getSkinResource();
    }

    @SideOnly(value=Side.CLIENT)
    private final class ExtendedPlayerInfo {
        public final GuiPlayerInfo playerInfo;
        public final PlayerData playerData;
        public final String playerName;
        private final int index;
        private String displayName;
        private Score score;

        public ExtendedPlayerInfo(GuiPlayerInfo playerInfo) {
            this.playerInfo = playerInfo;
            this.playerData = (PlayerData)TabMod.instance.playerDataMap.get(playerInfo.field_78831_a);
            this.playerName = this.playerData == null ? "" : Strings.nullToEmpty((String)this.playerData.tabName);
            this.index = this.playerData == null ? -1 : this.playerData.index;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            ScorePlayerTeam team = ((GuiPlayerTabOverlay)GuiPlayerTabOverlay.this).mc.field_71441_e.func_96441_U().func_96509_i(this.playerInfo.field_78831_a);
            this.displayName = ScorePlayerTeam.func_96667_a((Team)team, (String)this.playerInfo.field_78831_a);
            return this.displayName;
        }

        public Score getScore(ScoreObjective scoreObjective) {
            return this.score != null ? this.score : (this.score = scoreObjective.func_96682_a().func_96529_a(this.playerInfo.field_78831_a, scoreObjective));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class PlayerComparator
    implements Comparator<ExtendedPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(ExtendedPlayerInfo a, ExtendedPlayerInfo b) {
            return ComparisonChain.start().compare(a.index, b.index).compare((Comparable)((Object)a.playerName), (Comparable)((Object)b.playerName)).compare((Comparable)((Object)a.playerInfo.field_78831_a), (Comparable)((Object)b.playerInfo.field_78831_a)).result();
        }

        PlayerComparator(Object x0) {
            this();
        }
    }
}

