/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.tabmod.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;

public final class PlayerData {
    private static final String TAG_PROFILE = "Profile";
    private static final String TAG_TAB_NAME = "TabName";
    private static final String TAG_INDEX = "Index";
    public final GameProfile gameProfile;
    public final String tabName;
    public final int index;

    public PlayerData(GameProfile gameProfile, String tabName, int index) {
        this.gameProfile = Objects.requireNonNull(gameProfile, "gameProfile must not be null");
        this.tabName = tabName;
        this.index = index;
    }

    @Nullable
    public static PlayerData readFromNBT(NBTTagCompound nbt) {
        GameProfile gameProfile;
        if (nbt.func_150297_b(TAG_PROFILE, 10) && nbt.func_150297_b(TAG_TAB_NAME, 8) && nbt.func_150297_b(TAG_INDEX, 3) && (gameProfile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l(TAG_PROFILE))) != null) {
            String tabName = nbt.func_74779_i(TAG_TAB_NAME);
            int index = nbt.func_74762_e(TAG_INDEX);
            return new PlayerData(gameProfile, tabName, index);
        }
        return null;
    }

    @Nullable
    public static NBTTagCompound writePlayerToNBT(NBTTagCompound nbt, EntityPlayerMP player) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTUtil.func_152460_a((NBTTagCompound)tag, (GameProfile)player.func_146103_bH());
        nbt.func_74782_a(TAG_PROFILE, (NBTBase)tag);
        nbt.func_74778_a(TAG_TAB_NAME, player.getDisplayName());
        nbt.func_74768_a(TAG_INDEX, -1);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ResourceLocation getSkinResource() {
        ResourceLocation skinResource = null;
        Minecraft mc = Minecraft.func_71410_x();
        SkinManager skinManager = mc.func_152342_ad();
        Map profileTextures = skinManager.func_152788_a(this.gameProfile);
        MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)profileTextures.get(MinecraftProfileTexture.Type.SKIN);
        if (profileTexture != null) {
            skinResource = skinManager.func_152792_a(profileTexture, MinecraftProfileTexture.Type.SKIN);
        }
        return skinResource == null ? AbstractClientPlayer.field_110314_b : skinResource;
    }
}

