/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils;

import com.google.common.annotations.Beta;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Beta
public class CompletableFutureBuilder<T> {
    private final CompletableFuture<T> completableFuture;
    private final Settings settings;

    private CompletableFutureBuilder(CompletableFuture<T> completableFuture) {
        this(completableFuture, new Settings());
    }

    private CompletableFutureBuilder(CompletableFuture<T> completableFuture, Settings settings) {
        this.completableFuture = completableFuture;
        this.settings = settings;
    }

    public CompletableFutureBuilder<Void> thenAccept(Consumer<T> consumer) {
        return new CompletableFutureBuilder<Void>((CompletableFuture<Void>)this.completableFuture.thenAccept((Consumer)consumer), this.settings);
    }

    public CompletableFutureBuilder<Void> thenAcceptSync(Consumer<T> consumer) {
        return new CompletableFutureBuilder<Void>((CompletableFuture<Void>)this.completableFuture.thenAccept(t -> this.acceptSync0(t, consumer)), this.settings);
    }

    public <R> CompletableFutureBuilder<R> thenApply(Function<T, R> function) {
        return new CompletableFutureBuilder<T>(this.completableFuture.thenApply(function), this.settings);
    }

    public <R> CompletableFutureBuilder<R> thenApplySync(Function<T, R> function) {
        return new CompletableFutureBuilder<T>(this.completableFuture.thenApply((T t) -> this.applySync0(t, function)), this.settings);
    }

    public CompletableFuture<T> build() {
        return this.completableFuture;
    }

    public CompletableFutureBuilder<T> syncQueueTimeout(long timeout) {
        this.settings.timeout = timeout;
        return this;
    }

    public static CompletableFutureBuilder<Void> runAsync(Runnable runnable) {
        return new CompletableFutureBuilder<Void>(CompletableFuture.runAsync(runnable));
    }

    public static CompletableFutureBuilder<Void> runAsync(Runnable runnable, Executor executor) {
        return new CompletableFutureBuilder<Void>(CompletableFuture.runAsync(runnable, executor));
    }

    public static CompletableFutureBuilder<Void> runSync(Runnable runnable) {
        return CompletableFutureBuilder.runAsync(() -> {}).thenAcceptSync(o -> runnable.run());
    }

    public static <T> CompletableFutureBuilder<T> supplyAsync(Supplier<T> supplier) {
        return new CompletableFutureBuilder<T>(CompletableFuture.supplyAsync(supplier));
    }

    public static <T> CompletableFutureBuilder<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        return new CompletableFutureBuilder<T>(CompletableFuture.supplyAsync(supplier, executor));
    }

    public static <T> CompletableFutureBuilder<T> supplySync(Supplier<T> supplier) {
        return CompletableFutureBuilder.supplyAsync(() -> null).thenApplySync(o -> supplier.get());
    }

    public static <T> CompletableFutureBuilder<T> builder(CompletableFuture<T> completableFuture) {
        return new CompletableFutureBuilder<T>(completableFuture);
    }

    public static <T> CompletableFutureBuilder<T> builder() {
        return new CompletableFutureBuilder<Object>(CompletableFuture.supplyAsync(() -> null));
    }

    public static <T> CompletableFutureBuilder<T> builder(Executor executor) {
        return new CompletableFutureBuilder<Object>(CompletableFuture.supplyAsync(() -> null, executor));
    }

    private <U> U acceptSync0(U object, Consumer<U> consumer) {
        return this.returnSyncResult(new FutureTask<U>(() -> consumer.accept(object), object));
    }

    private <U, R> R applySync0(U object, Function<U, R> function) {
        return (R)this.returnSyncResult(new FutureTask<Object>(() -> function.apply(object)));
    }

    private <R> R returnSyncResult(FutureTask<R> e) {
        if (e != null) {
            SyncQueueHandler.QUEUE.add(e);
            long l = System.currentTimeMillis();
            while (!e.isDone()) {
                if (this.settings.timeout == -1L || System.currentTimeMillis() - l < this.settings.timeout) continue;
                System.out.println(e + " is time outed");
                SyncQueueHandler.remove(e);
                return null;
            }
            return e.get();
        }
        return null;
    }

    private static class Settings {
        private static final long DEFAULT_SYNC_TASK_TIMEOUT = 1000L;
        private long timeout = 1000L;

        private Settings() {
        }
    }

    public static class SyncQueueHandler {
        private static final Queue<FutureTask<?>> QUEUE = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void update() {
            Queue<FutureTask<?>> queue = QUEUE;
            synchronized (queue) {
                while (!QUEUE.isEmpty()) {
                    QUEUE.poll().run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void remove(FutureTask<?> futureTask) {
            Queue<FutureTask<?>> queue = QUEUE;
            synchronized (queue) {
                QUEUE.remove(futureTask);
            }
        }
    }
}

