/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils;

import java.util.List;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityUtils {
    public static int getDistanceToTheEntity(Entity start, Entity end) {
        return EntityUtils.getDistanceEntityToThePlace(start, new Vector3d((double)((float)end.field_70165_t), (double)((float)end.field_70163_u), (double)((float)end.field_70161_v)));
    }

    public static int getDistanceEntityToThePlace(Entity start, Vector3d end) {
        return (int)EntityUtils.getDistance(new Vector3d((double)((float)start.field_70165_t), (double)((float)start.field_70163_u), (double)((float)start.field_70161_v)), new Vector3d(end.x, end.y, end.z));
    }

    public static int getDistancePlaceToTheEntity(Vector3d start, Entity end) {
        return (int)EntityUtils.getDistance(new Vector3d(start.x, start.y, start.z), new Vector3d((double)((float)end.field_70165_t), (double)((float)end.field_70163_u), (double)((float)end.field_70161_v)));
    }

    public static double getDistance(Vector3d start, Vector3d end) {
        double x = start.x - end.x;
        double y = start.y - end.y - 2.0;
        double z = start.z - end.z;
        return MathHelper.func_76133_a((double)(x * x + y * y + z * z));
    }

    public static boolean isEntityInside(Entity entity, int dim, double x, double y, double z, double radius) {
        return entity.field_71093_bK == dim && entity.field_70165_t >= x - radius && entity.field_70163_u >= y - radius && entity.field_70161_v >= z - radius && entity.field_70165_t < x + radius && entity.field_70163_u < y + radius && entity.field_70161_v < z + radius;
    }

    public static String getUUID(Entity entity) {
        return entity.func_110124_au().toString();
    }

    public static int getEntityID(Entity entity) {
        return entity.func_145782_y();
    }

    public static String getEntityName(Entity entity) {
        return entity.func_70005_c_();
    }

    public Entity getEntityByID(World world, int id) {
        return world.func_73045_a(id);
    }

    public Entity getPointedEntity() {
        return Minecraft.func_71410_x().field_71476_x.field_72308_g;
    }

    public static Vector3d getEntityPosition(Entity ent) {
        return new Vector3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }

    public static EntityItem createEntityItem(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        EntityItem entityitem;
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            entityitem = new EntityItem(world, x + d, y + d1, z + d2, stack);
            entityitem.field_145804_b = 10;
        } else {
            entityitem = new EntityItem(world, x, y, z, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            entityitem.field_145804_b = 0;
        }
        return entityitem;
    }

    public static void dropItems(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        if (stack != null && stack.field_77994_a > 0) {
            EntityItem entityitem = EntityUtils.createEntityItem(world, stack, x, y, z, doRandomSpread);
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void dropItemsInventory(World world, ItemStack[] inventory, int x, int y, int z, boolean doRandomSpread) {
        if (inventory != null) {
            ItemStack[] var6 = inventory;
            int var7 = inventory.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                ItemStack stack = var6[var8];
                if (stack == null || stack.field_77994_a <= 0) continue;
                EntityUtils.dropItems(world, stack.func_77946_l(), x, y, z, doRandomSpread);
            }
        }
    }

    public static void dropItemsInventory(World world, IInventory inventory, int x, int y, int z, boolean doRandomSpread) {
        for (int l = 0; l < inventory.func_70302_i_(); ++l) {
            ItemStack items = inventory.func_70301_a(l);
            if (items == null || items.field_77994_a <= 0) continue;
            EntityUtils.dropItems(world, inventory.func_70301_a(l).func_77946_l(), x, y, z, doRandomSpread);
        }
    }

    public static List getNearEntityFromEntity(Class cls, Entity entity, int dis) {
        AxisAlignedBB range = entity.field_70121_D.func_72314_b((double)dis, (double)dis, (double)dis);
        List list = entity.field_70170_p.func_72872_a(cls, range);
        return list;
    }
}

