/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class SyncResultHandler<T> {
    private static Consumer<Runnable> mainThreadExecutor;
    private final CompletableFuture<T> completableFuture;
    private final boolean checkNonNullResult;

    public SyncResultHandler(CompletableFuture<T> completableFuture) {
        this(completableFuture, true);
    }

    public SyncResultHandler(CompletableFuture<T> completableFuture, boolean checkNonNullResult) {
        this.completableFuture = completableFuture;
        this.checkNonNullResult = checkNonNullResult;
    }

    public void thenAcceptSync(Consumer<T> consumer) {
        if (mainThreadExecutor == null) {
            throw new RuntimeException("The main thread executor wasn't set! I can't work in the main thread.");
        }
        this.completableFuture.thenAcceptAsync(result -> {
            if (this.checkNonNullResult && result == null) {
                return;
            }
            mainThreadExecutor.accept(() -> consumer.accept(result));
        });
    }

    public static void setMainThreadExecutor(Consumer<Runnable> mainThreadExecutor) {
        SyncResultHandler.mainThreadExecutor = mainThreadExecutor;
    }
}

