/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.config;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.vizzi.Utils.config.ThrConsumer;
import ru.vizzi.Utils.config.ThrFunction;

public final class Flex {
    @Nonnull
    public static <T, V> List<V> aggregateValues(@Nonnull Collection<T> collection, @Nonnull Predicate<T> predicate, @Nonnull Function<T, V> function) {
        ArrayList list = new ArrayList();
        collection.forEach(t -> {
            if (predicate.test(t)) {
                list.add(function.apply(t));
            }
        });
        return list;
    }

    @SafeVarargs
    public static <T> boolean containsAny(@Nonnull Collection<T> collection, T ... elements) {
        for (T element : elements) {
            if (!collection.contains(element)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean containsAll(@Nonnull Collection<T> collection, T ... elements) {
        if (collection.isEmpty()) {
            return false;
        }
        for (T element : elements) {
            boolean contains = collection.contains(element);
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T, V> T getUniqueElement(@Nonnull Collection<T> collection, @Nonnull Function<T, V> function, @Nonnull BiPredicate<V, V> predicate) {
        T last = null;
        Object o = null;
        for (T t : collection) {
            V apply = function.apply(t);
            if (o != null && !predicate.test(o, apply)) continue;
            last = t;
            o = apply;
        }
        return last;
    }

    public static <T, R> void remapArray(@Nonnull T[] input, @Nonnull R[] output, @Nonnull Function<T, R> function) {
        if (input.length != output.length) {
            throw new IllegalArgumentException("Length of T and R arrays must be the same!");
        }
        for (int i = 0; i < output.length; ++i) {
            output[i] = function.apply(input[i]);
        }
    }

    public static <T> void pollQueue(@Nonnull Queue<FutureTask<T>> queue) {
        while (!queue.isEmpty()) {
            FutureTask<T> poll = queue.poll();
            if (poll != null) {
                poll.run();
                continue;
            }
            if (queue.remove(null)) continue;
            queue.clear();
        }
    }

    public static <K, V> boolean forEach(@Nonnull Map<K, V> map, @Nonnull Function<Map.Entry<K, V>, Boolean> function) {
        for (Map.Entry<K, V> kvEntry : map.entrySet()) {
            if (function.apply(kvEntry).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean forEach(@Nonnull Collection<T> collection, @Nonnull Function<T, Boolean> function) {
        for (T t : collection) {
            if (function.apply(t).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean forEach(@Nonnull T[] array, @Nonnull Function<T, Boolean> function) {
        for (T t : array) {
            if (function.apply(t).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean forEachThr(@Nonnull Collection<T> collection, @Nonnull ThrFunction<T, Boolean> function) throws IOException {
        for (T t : collection) {
            if (function.apply(t).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> void forEachThr(@Nonnull Collection<T> collection, @Nonnull ThrConsumer<T> function) throws IOException {
        for (T t : collection) {
            function.accept(t);
        }
    }

    public static <T, V> boolean removeIf(@Nonnull Map<T, V> map, @Nonnull Predicate<Map.Entry<T, V>> predicate, @Nonnull Consumer<Map.Entry<T, V>> consumer) {
        boolean flag = false;
        Iterator<Map.Entry<T, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, V> next = iterator.next();
            if (!predicate.test(next)) continue;
            consumer.accept(next);
            iterator.remove();
            flag = true;
        }
        return flag;
    }

    public static <T, V> void removeAll(@Nonnull Map<T, V> map, @Nonnull Consumer<Map.Entry<T, V>> consumer) {
        Iterator<Map.Entry<T, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, V> next = iterator.next();
            consumer.accept(next);
            iterator.remove();
        }
    }

    public static <T> boolean removeIf(@Nonnull Collection<T> collection, @Nonnull Predicate<T> predicate, @Nonnull Consumer<T> consumer) {
        boolean flag = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (!predicate.test(next)) continue;
            consumer.accept(next);
            iterator.remove();
            flag = true;
        }
        return flag;
    }

    public static <T, V> int removeAllIf(@Nonnull Map<T, V> map, @Nonnull Predicate<Map.Entry<T, V>> predicate, @Nonnull Consumer<Map.Entry<T, V>> consumer) {
        int i = 0;
        Iterator<Map.Entry<T, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, V> next = iterator.next();
            if (!predicate.test(next)) continue;
            consumer.accept(next);
            iterator.remove();
            ++i;
        }
        return i;
    }

    public static <T> int removeAllIf(@Nonnull Collection<T> collection, @Nonnull Predicate<T> predicate, @Nonnull Consumer<T> consumer) {
        int i = 0;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (!predicate.test(next)) continue;
            consumer.accept(next);
            iterator.remove();
            ++i;
        }
        return i;
    }

    @Nullable
    public static <T> T getArrayElement(@Nonnull T[] array, @Nonnull Predicate<T> predicate) {
        for (T t : array) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static <K, V> K getMapEntryKey(@Nonnull Map<K, V> map, @Nonnull Predicate<Map.Entry<K, V>> predicate) {
        Map.Entry<K, V> mapEntry = Flex.getMapEntry(map, predicate);
        return mapEntry != null ? (K)mapEntry.getKey() : null;
    }

    @Nullable
    public static <K, V> V getMapEntryValue(@Nonnull Map<K, V> map, @Nonnull Predicate<Map.Entry<K, V>> predicate) {
        Map.Entry<K, V> mapEntry = Flex.getMapEntry(map, predicate);
        return mapEntry != null ? (V)mapEntry.getValue() : null;
    }

    @Nullable
    public static <K, V> Map.Entry<K, V> getMapEntry(@Nonnull Map<K, V> map, @Nonnull Predicate<Map.Entry<K, V>> predicate) {
        for (Map.Entry<K, V> tvEntry : map.entrySet()) {
            if (!predicate.test(tvEntry)) continue;
            return tvEntry;
        }
        return null;
    }

    @Nullable
    public static <T> T getCollectionElement(@Nonnull Collection<T> collection, @Nonnull Predicate<T> predicate) {
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static boolean inEnumRange(@Nonnull Class<? extends Enum<?>> aClass, int ordinal) {
        if (ordinal < 0) {
            return false;
        }
        Method values = aClass.getMethod("values", new Class[0]);
        return ((Object[])values.invoke(aClass, new Object[0])).length > ordinal;
    }

    private Flex() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

