/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.Primitives;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.vizzi.Utils.CommonUtils;
import ru.vizzi.Utils.Logger;
import ru.vizzi.Utils.config.ConfigComment;
import ru.vizzi.Utils.config.Configurable;
import ru.vizzi.Utils.config.Flex;

public interface IConfigGson {
    public static final Gson GSON = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getDeclaringClass().getAnnotation(Configurable.class) == null && f.getAnnotation(Configurable.class) == null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }}).excludeFieldsWithModifiers(new int[]{128}).setPrettyPrinting().serializeNulls().create();
    public static final Logger LOGGER = new Logger(IConfigGson.class.getSimpleName());
    public static final String COMMENT_PREFIX = "<--//";

    default public void load() {
        this.loadExceptionally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void loadExceptionally() throws NoSuchFieldException, IllegalAccessException, IOException {
        if (this.getConfigFile().exists()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getConfigFile()));
            try {
                IConfigGson configGson;
                String line;
                StringBuilder source = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    int commentIndex = line.indexOf(COMMENT_PREFIX);
                    if (commentIndex != -1) {
                        line = line.substring(0, commentIndex);
                    }
                    source.append(line).append("\n");
                }
                try {
                    configGson = (IConfigGson)GSON.fromJson(source.toString(), this.getClass());
                }
                catch (Exception t) {
                    throw new IOException("An error has occurred during loading of config: " + this.getConfigFile().getName(), t);
                }
                List<Class<?>> list = CommonUtils.getClassesHierarchy(this.getClass());
                if (configGson == null) return;
                for (Class<?> aClass : list) {
                    for (Field field : aClass.getDeclaredFields()) {
                        if (Modifier.isTransient(field.getModifiers()) || aClass.getAnnotation(Configurable.class) == null && field.getAnnotation(Configurable.class) == null) continue;
                        Field field1 = aClass.getDeclaredField(field.getName());
                        field.setAccessible(true);
                        field1.setAccessible(true);
                        field.set(this, field1.get(configGson));
                    }
                }
                return;
            }
            finally {
                if (Collections.singletonList(bufferedReader).get(0) != null) {
                    bufferedReader.close();
                }
            }
        }
        LOGGER.info("Creating config " + this.getConfigFile().getPath());
        this.save();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void save() {
        if (this.getConfigFile().exists() && !this.getConfigFile().delete()) {
            throw new RuntimeException(this.getConfigFile().getAbsolutePath());
        }
        if (this.getConfigFile().getParentFile() != null) {
            this.getConfigFile().getParentFile().mkdirs();
        }
        String json = GSON.toJson((Object)this);
        HashSet<Class> list = new HashSet<Class>();
        list.add(this.getClass());
        int preSize = 0;
        while (preSize != list.size()) {
            preSize = list.size();
            ArrayList temp = new ArrayList();
            for (Class aClass2 : list) {
                for (Field declaredField : aClass2.getDeclaredFields()) {
                    if (declaredField.getType().isAssignableFrom(List.class) || declaredField.getType().isAssignableFrom(Map.class)) {
                        if (!(declaredField.getGenericType() instanceof ParameterizedType)) continue;
                        Type[] actualTypeArguments = ((ParameterizedType)declaredField.getGenericType()).getActualTypeArguments();
                        Flex.forEach(actualTypeArguments, type -> {
                            if (type instanceof Class) {
                                temp.add((Class)type);
                            }
                            return true;
                        });
                        continue;
                    }
                    temp.add(declaredField.getType());
                    temp.addAll(CommonUtils.getClassesHierarchy(declaredField.getType()));
                }
            }
            list.addAll(temp);
            list.removeIf(aClass -> aClass == File.class || aClass == Class.class || aClass == Object.class || aClass == String.class || Primitives.isPrimitive((Type)aClass) || Map.class.isAssignableFrom((Class<?>)aClass) || List.class.isAssignableFrom((Class<?>)aClass));
        }
        HashMap<String, String> fieldCommentMap = new HashMap<String, String>();
        for (Class aClass2 : list) {
            for (Field field : aClass2.getDeclaredFields()) {
                String comment = null;
                Configurable annotation = field.getAnnotation(Configurable.class);
                if (annotation == null || annotation.comment().equals("")) {
                    ConfigComment configComment = field.getAnnotation(ConfigComment.class);
                    if (configComment != null) {
                        comment = configComment.value().length > 1 && field.getType().isAssignableFrom(List.class) || field.getType().isAssignableFrom(Map.class) ? "\n<--//" + String.join((CharSequence)"\n<--//", configComment.value()) : " <--//" + configComment.value()[0];
                    }
                } else if (!annotation.comment().equals("")) {
                    comment = " <--//" + annotation.comment();
                }
                if (comment == null) continue;
                fieldCommentMap.put(field.getName(), comment);
            }
        }
        String[] split = json.split("\n");
        int i = 0;
        while (i < split.length) {
            for (String s : fieldCommentMap.keySet()) {
                if (!split[i].contains("\"" + s + "\":")) continue;
                int n = i;
                split[n] = split[n] + (String)fieldCommentMap.get(s);
                break;
            }
            int n = i++;
            split[n] = split[n] + "\n";
        }
        try {
            FileWriter fileWriter = new FileWriter(this.getConfigFile());
            try {
                for (String s : split) {
                    fileWriter.write(s);
                }
                fileWriter.flush();
            }
            finally {
                if (Collections.singletonList(fileWriter).get(0) != null) {
                    fileWriter.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getConfigFile();
}

