/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.databases;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import ru.vizzi.Utils.databases.mariadb.ConfigDBType;
import ru.vizzi.Utils.databases.mariadb.ConfigMariaList;
import ru.vizzi.Utils.databases.mariadb.MariaDBProvider;

public class DatabaseManager {
    private static ExecutorService executorService;
    private static ConfigMariaList configMariaDBV2;
    private static ArrayList<MariaDBProvider> dbProviders;
    private static boolean init;

    public static void shutdown() {
        executorService.shutdown();
        init = false;
        try {
            executorService.awaitTermination(10000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static MariaDBProvider getMysql(int id) {
        return dbProviders.get(id);
    }

    public static void init() {
        if (!init) {
            configMariaDBV2 = new ConfigMariaList("config/LibrariesCore/mariaConfig.json");
            ArrayList<ConfigDBType> configMaria = new ArrayList<ConfigDBType>();
            ConfigDBType configDBType = new ConfigDBType();
            configDBType.setDatabase("databasesName");
            configDBType.setHost("localhost");
            configDBType.setPort(3306);
            configDBType.setUsername("root");
            configDBType.setPassword("password");
            configMaria.add(configDBType);
            configMariaDBV2.setConfigMariaDBS(configMaria);
            configMariaDBV2.load();
            if (configMariaDBV2.isEnabled()) {
                executorService = Executors.newFixedThreadPool(16);
                for (ConfigDBType dbType : configMariaDBV2.getConfigMariaDBS()) {
                    MariaDBProvider mariaDBProviderV2 = new MariaDBProvider(dbType);
                    dbProviders.add(mariaDBProviderV2);
                }
                init = true;
            }
        }
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static boolean isInit() {
        return init;
    }

    static {
        dbProviders = new ArrayList();
    }
}

