/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.databases.mariadb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.vizzi.Utils.LibrariesCore;
import ru.vizzi.Utils.databases.BiHolder;
import ru.vizzi.Utils.databases.mariadb.ConfigDBType;

public class MariaDBProvider {
    private ConfigDBType configDBType;

    public MariaDBProvider(ConfigDBType config) {
        this.configDBType = config;
    }

    public Connection getConnection() {
        return DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s?user=%s&password=%s&autoReconnect=true&useUnicode=true&characterEncoding=UTF-8&serverTimezone=UTC&connectTimeout=0&socketTimeout=0", this.configDBType.getHost(), this.configDBType.getPort(), this.configDBType.getDatabase(), this.configDBType.getUsername(), this.configDBType.getPassword()));
    }

    @Nullable
    public BiHolder<Statement, ResultSet> doRequestAsync(@Nonnull String sql) {
        return this.doRequestAsync(sql, 0);
    }

    private BiHolder<Statement, ResultSet> doRequestAsync(@Nonnull String sql, int deep) {
        if (deep < 3) {
            Statement statement = this.getConnection().createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(sql);
                LibrariesCore.logger.debug("SQL: %s successful ", sql);
                return new BiHolder<Statement, ResultSet>(statement, resultSet);
            }
            catch (SQLNonTransientConnectionException e) {
                LibrariesCore.logger.debug("SQL: %s error ", sql);
                e.printStackTrace();
                this.doRequestAsync(sql, deep + 1);
            }
        }
        return null;
    }

    private BiHolder<Statement, ResultSet> doRequestAsyncUpdate(@Nonnull String sql, int deep) {
        if (deep < 3) {
            Statement statement = this.getConnection().createStatement();
            try {
                statement.executeUpdate(sql, 1);
                ResultSet resultSet = statement.getGeneratedKeys();
                LibrariesCore.logger.debug("SQL: %s successful ", sql);
                return new BiHolder<Statement, ResultSet>(statement, resultSet);
            }
            catch (SQLNonTransientConnectionException e) {
                this.doRequestAsync(sql, deep + 1);
            }
        }
        return null;
    }

    @Nullable
    public BiHolder<Statement, ResultSet> doRequestAsyncUpdate(@Nonnull String sql) {
        return this.doRequestAsyncUpdate(sql, 0);
    }
}

