/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import ru.vizzi.Utils.CustomFont.FontContainer;
import ru.vizzi.Utils.CustomFont.FontType;
import ru.vizzi.Utils.gui.GuiButtonNew;
import ru.vizzi.Utils.gui.drawmodule.AnimationHelper;
import ru.vizzi.Utils.gui.drawmodule.GuiDrawUtils;
import ru.vizzi.Utils.gui.drawmodule.GuiUtils;
import ru.vizzi.Utils.gui.drawmodule.ScaleGui;

public class GuiButtonAdvanced
extends GuiButtonNew {
    protected static final Minecraft mc = Minecraft.func_71410_x();
    protected ResourceLocation texture;
    protected ResourceLocation textureHover;
    protected ResourceLocation textureActive;
    protected ResourceLocation textureDisable;
    public float xBase;
    public float yBase;
    public float widthBase;
    public float heightBase;
    protected float textBlending;
    protected float textScale;
    protected int shadowColor = 0x3F3F3F;
    protected float shadowOffset = 1.0f;
    protected boolean customShadow;
    protected boolean shadowFlag = false;
    protected float offsetY = 0.0f;
    protected float offsetX = 0.0f;
    protected float paddingYY = 4.0f;
    protected boolean hovered;
    protected boolean active;
    protected String twoLineText = "";
    public float rounted = 0.0f;
    public int colorBackground = -1;
    public int colorHoverBackground = -1;
    public int colorActiveBackground = -1;
    public int colorDisableBackground = -1;
    public int colorTextActive = -1;
    public int colorText = -1;
    public int colorTextHover = -1;
    public int colorTextDisable = -1;
    public FontContainer font = FontType.FUTURA_PT_MEDIUM.getFontContainer();

    public GuiButtonAdvanced(int id, float x, float y, float width, float height, String text) {
        super(id, x, y, width, height, text);
        this.xBase = x;
        this.yBase = y;
        this.widthBase = width;
        this.heightBase = height;
        this.textScale = height / 36.0f;
    }

    public GuiButtonAdvanced(int id, float x, float y, float width, float height, String text, float textScale) {
        super(id, x, y, width, height, text);
        this.xBase = x;
        this.yBase = y;
        this.widthBase = width;
        this.heightBase = height;
        this.textScale = textScale;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        this.drawButton(mouseX, mouseY);
    }

    protected void updateAnimation(boolean hovered) {
        if (hovered) {
            this.textBlending += AnimationHelper.getAnimationSpeed() * 0.1f;
            if (this.textBlending > 1.0f) {
                this.textBlending = 1.0f;
            }
        } else {
            this.textBlending -= AnimationHelper.getAnimationSpeed() * 0.1f;
            if (this.textBlending < 0.0f) {
                this.textBlending = 0.0f;
            }
        }
    }

    public void drawButton(int mouseX, int mouseY) {
        if (this.visible) {
            boolean hovered = this.isHovered(mouseX, mouseY);
            if (!hovered || !this.hovered) {
                // empty if block
            }
            this.hovered = hovered;
            this.updateAnimation(hovered);
            if (this.colorBackground != -1) {
                if (!this.enabled && this.colorDisableBackground != -1) {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorDisableBackground, 1.0);
                } else if (this.isHovered() && this.colorHoverBackground != -1 && !this.active) {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorHoverBackground, 1.0);
                } else if (this.active && this.colorActiveBackground != -1) {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorActiveBackground, 1.0);
                } else {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorBackground, 1.0);
                }
            }
        }
        if (this.texture != null) {
            if (!this.enabled && this.textureDisable != null) {
                GuiUtils.drawImageNew(this.textureDisable, this.xPosition, this.yPosition, this.width, this.height, 1.0);
            } else if (this.isHovered() && this.textureHover != null && !this.active) {
                GuiUtils.drawImageNew(this.textureHover, this.xPosition, this.yPosition, this.width, this.height, 1.0);
            } else if (this.active && this.textureActive != null) {
                GuiUtils.drawImageNew(this.textureActive, this.xPosition, this.yPosition, this.width, this.height, 1.0);
            } else {
                GuiUtils.drawImageNew(this.texture, this.xPosition, this.yPosition, this.width, this.height, 1.0);
            }
        }
        this.drawText();
    }

    @Override
    public boolean mousePressed(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
        return this.enabled && this.visible && (float)p_146116_2_ >= this.xPosition && (float)p_146116_3_ >= this.yPosition && (float)p_146116_2_ < this.xPosition + this.width && (float)p_146116_3_ < this.yPosition + this.height;
    }

    protected boolean isHovered(int mouseX, int mouseY) {
        this.field_146123_n = (float)mouseX >= this.xPosition && (float)mouseY >= this.yPosition && (float)mouseX < this.xPosition + this.width && (float)mouseY < this.yPosition + this.height;
        return this.field_146123_n;
    }

    protected void drawText() {
        int color = -1;
        if (this.colorText != -1) {
            color = !this.enabled ? this.colorTextDisable : (this.isHovered() && !this.active ? this.colorTextHover : (this.active ? this.colorTextActive : this.colorText));
            float paddingY = this.textScale * this.paddingYY;
            if (this.shadowFlag) {
                GuiDrawUtils.drawStringNoScaleShadow(this.font, this.displayString, this.xPosition + this.shadowOffset + this.offsetX + this.width / 2.0f - this.font.width(this.displayString) * this.textScale / 2.0f, this.yPosition + this.offsetY + this.shadowOffset + this.height / 2.0f - paddingY, this.textScale, this.shadowColor, this.shadowFlag);
                GuiDrawUtils.drawStringNoScaleShadow(this.font, this.twoLineText, this.xPosition + this.shadowOffset + this.offsetX + this.width / 2.0f - this.font.width(this.twoLineText) * this.textScale / 2.0f, this.yPosition + this.offsetY + ScaleGui.get(20.0f) + this.shadowOffset + this.height / 2.0f - paddingY, this.textScale, this.shadowColor, this.shadowFlag);
            }
            if (this.customShadow) {
                GuiDrawUtils.drawStringNoScale(this.font, this.displayString, this.xPosition + this.shadowOffset + this.offsetX + this.width / 2.0f - this.font.width(this.displayString) * this.textScale / 2.0f, this.yPosition + this.offsetY + this.shadowOffset + this.height / 2.0f - paddingY, this.textScale, this.shadowColor);
                GuiDrawUtils.drawStringNoScale(this.font, this.twoLineText, this.xPosition + this.shadowOffset + this.offsetX + this.width / 2.0f - this.font.width(this.twoLineText) * this.textScale / 2.0f, this.yPosition + this.offsetY + ScaleGui.get(20.0f) + this.shadowOffset + this.height / 2.0f - paddingY, this.textScale, this.shadowColor);
            }
            GuiDrawUtils.drawStringNoScale(this.font, this.displayString, this.xPosition + this.offsetX + this.width / 2.0f - this.font.width(this.displayString) * this.textScale / 2.0f, this.yPosition + this.offsetY + this.height / 2.0f - paddingY, this.textScale, color);
            GuiDrawUtils.drawStringNoScale(this.font, this.twoLineText, this.xPosition + this.offsetX + this.width / 2.0f - this.font.width(this.twoLineText) * this.textScale / 2.0f, this.yPosition + this.offsetY + ScaleGui.get(20.0f) + this.height / 2.0f - paddingY, this.textScale, color);
        }
    }

    public void addXPosition(float x) {
        this.xPosition = (int)(this.xBase + x);
    }

    public void addYPosition(float y) {
        this.yPosition = (int)(this.yBase + y);
    }

    public void scaleXPosition(float x) {
        this.xPosition = (int)(this.xBase * x);
    }

    public void scaleYPosition(float y) {
        this.yPosition = (int)(this.yBase * y);
    }

    public void setXPosition(float x) {
        this.xBase = this.xPosition = (float)((int)x);
    }

    public void setYPosition(float y) {
        this.yBase = this.yPosition = (float)((int)y);
    }

    public void setHeight(float height) {
        this.heightBase = this.height = (float)((int)height);
    }

    public void setWidth(float width) {
        this.widthBase = this.width = (float)((int)width);
    }

    public void scaleWidth(float x) {
        this.width = (int)(this.widthBase * x);
    }

    public void scaleHeight(float y) {
        this.height = (int)(this.heightBase * y);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ResourceLocation getTextureHover() {
        return this.textureHover;
    }

    public ResourceLocation getTextureActive() {
        return this.textureActive;
    }

    public ResourceLocation getTextureDisable() {
        return this.textureDisable;
    }

    public float getXBase() {
        return this.xBase;
    }

    public float getYBase() {
        return this.yBase;
    }

    public float getWidthBase() {
        return this.widthBase;
    }

    public float getHeightBase() {
        return this.heightBase;
    }

    public float getTextBlending() {
        return this.textBlending;
    }

    public float getTextScale() {
        return this.textScale;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public float getShadowOffset() {
        return this.shadowOffset;
    }

    public boolean isCustomShadow() {
        return this.customShadow;
    }

    public boolean isShadowFlag() {
        return this.shadowFlag;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getPaddingYY() {
        return this.paddingYY;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getTwoLineText() {
        return this.twoLineText;
    }

    public float getRounted() {
        return this.rounted;
    }

    public int getColorBackground() {
        return this.colorBackground;
    }

    public int getColorHoverBackground() {
        return this.colorHoverBackground;
    }

    public int getColorActiveBackground() {
        return this.colorActiveBackground;
    }

    public int getColorDisableBackground() {
        return this.colorDisableBackground;
    }

    public int getColorTextActive() {
        return this.colorTextActive;
    }

    public int getColorText() {
        return this.colorText;
    }

    public int getColorTextHover() {
        return this.colorTextHover;
    }

    public int getColorTextDisable() {
        return this.colorTextDisable;
    }

    public FontContainer getFont() {
        return this.font;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setTextureHover(ResourceLocation textureHover) {
        this.textureHover = textureHover;
    }

    public void setTextureActive(ResourceLocation textureActive) {
        this.textureActive = textureActive;
    }

    public void setTextureDisable(ResourceLocation textureDisable) {
        this.textureDisable = textureDisable;
    }

    public void setXBase(float xBase) {
        this.xBase = xBase;
    }

    public void setYBase(float yBase) {
        this.yBase = yBase;
    }

    public void setWidthBase(float widthBase) {
        this.widthBase = widthBase;
    }

    public void setHeightBase(float heightBase) {
        this.heightBase = heightBase;
    }

    public void setTextBlending(float textBlending) {
        this.textBlending = textBlending;
    }

    public void setTextScale(float textScale) {
        this.textScale = textScale;
    }

    public void setShadowColor(int shadowColor) {
        this.shadowColor = shadowColor;
    }

    public void setShadowOffset(float shadowOffset) {
        this.shadowOffset = shadowOffset;
    }

    public void setCustomShadow(boolean customShadow) {
        this.customShadow = customShadow;
    }

    public void setShadowFlag(boolean shadowFlag) {
        this.shadowFlag = shadowFlag;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    public void setPaddingYY(float paddingYY) {
        this.paddingYY = paddingYY;
    }

    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setTwoLineText(String twoLineText) {
        this.twoLineText = twoLineText;
    }

    public void setRounted(float rounted) {
        this.rounted = rounted;
    }

    public void setColorBackground(int colorBackground) {
        this.colorBackground = colorBackground;
    }

    public void setColorHoverBackground(int colorHoverBackground) {
        this.colorHoverBackground = colorHoverBackground;
    }

    public void setColorActiveBackground(int colorActiveBackground) {
        this.colorActiveBackground = colorActiveBackground;
    }

    public void setColorDisableBackground(int colorDisableBackground) {
        this.colorDisableBackground = colorDisableBackground;
    }

    public void setColorTextActive(int colorTextActive) {
        this.colorTextActive = colorTextActive;
    }

    public void setColorText(int colorText) {
        this.colorText = colorText;
    }

    public void setColorTextHover(int colorTextHover) {
        this.colorTextHover = colorTextHover;
    }

    public void setColorTextDisable(int colorTextDisable) {
        this.colorTextDisable = colorTextDisable;
    }

    public void setFont(FontContainer font) {
        this.font = font;
    }
}

