/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.gui;

import ru.vizzi.Utils.gui.GuiButtonAdvanced;
import ru.vizzi.Utils.gui.drawmodule.GuiDrawUtils;
import ru.vizzi.Utils.gui.drawmodule.GuiUtils;

public class GuiButtonAdvancedImage
extends GuiButtonAdvanced {
    private float xImage;
    private float yImage;
    private float wImage;
    private float hImage;
    private float xText;

    public GuiButtonAdvancedImage(int id, float x, float y, float width, float height, String text, float textScale, float xImage, float yImage, float wImage, float hImage, float xText) {
        super(id, x, y, width, height, text, textScale);
        this.xImage = xImage;
        this.yImage = yImage;
        this.wImage = wImage;
        this.hImage = hImage;
        this.xText = xText;
    }

    @Override
    public void drawButton(int mouseX, int mouseY) {
        if (this.visible) {
            boolean hovered = this.isHovered(mouseX, mouseY);
            if (!hovered || !this.hovered) {
                // empty if block
            }
            this.hovered = hovered;
            this.updateAnimation(hovered);
            if (this.colorBackground != -1) {
                if (!this.enabled && this.colorDisableBackground != -1) {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorDisableBackground, 1.0);
                } else if (this.isHovered() && this.colorHoverBackground != -1 && !this.active) {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorHoverBackground, 1.0);
                } else if (this.active && this.colorActiveBackground != -1) {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorActiveBackground, 1.0);
                } else {
                    GuiDrawUtils.drawRoundedRect(this.xPosition, this.yPosition, this.width, this.height, this.rounted, this.colorBackground, 1.0);
                }
            }
        }
        if (this.texture != null) {
            if (!this.enabled && this.textureDisable != null) {
                GuiUtils.drawImageNew(this.textureDisable, this.xPosition + this.xImage, this.yPosition + this.yImage, this.wImage, this.hImage, 1.0);
            } else if (this.isHovered() && this.textureHover != null && !this.active) {
                GuiUtils.drawImageNew(this.textureHover, this.xPosition + this.xImage, this.yPosition + this.yImage, this.wImage, this.hImage, 1.0);
            } else if (this.active && this.textureActive != null) {
                GuiUtils.drawImageNew(this.textureActive, this.xPosition + this.xImage, this.yPosition + this.yImage, this.wImage, this.hImage, 1.0);
            } else {
                GuiUtils.drawImageNew(this.texture, this.xPosition + this.xImage, this.yPosition + this.yImage, this.wImage, this.hImage, 1.0);
            }
        }
        this.drawText();
    }

    @Override
    protected void drawText() {
        int color = -1;
        if (this.colorText != -1) {
            color = !this.enabled ? this.colorTextDisable : (this.isHovered() && !this.active ? this.colorTextHover : (this.active ? this.colorTextActive : this.colorText));
            float paddingY = this.textScale * 4.0f;
            GuiDrawUtils.drawStringNoScale(this.font, this.displayString, this.xPosition + this.xText + this.width / 2.0f - this.font.width(this.displayString) * this.textScale / 2.0f, this.yPosition + this.height / 2.0f - paddingY, this.textScale, color);
        }
    }
}

